/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.runtime;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public abstract class RuntimeUtil {
    public static List<Object> runClasses() {
        ArrayList<Object> list = new ArrayList<Object>();
        Thread.currentThread();
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Set<Thread> entry = map.keySet();
        for (Thread thread : entry) {
            for (StackTraceElement element : (StackTraceElement[])map.get(thread).clone()) {
                list.add(element.getClassName());
            }
        }
        return list;
    }

    public static List<String> runMethods() {
        ArrayList<String> list = new ArrayList<String>();
        Thread.currentThread();
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Set<Thread> entry = map.keySet();
        for (Thread thread : entry) {
            for (StackTraceElement element : (StackTraceElement[])map.get(thread).clone()) {
                list.add(element.getMethodName());
            }
        }
        return list;
    }

    public static Iterator<?> list(ClassLoader CL) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class<?> CL_class;
        for (CL_class = CL.getClass(); CL_class != ClassLoader.class; CL_class = CL_class.getSuperclass()) {
        }
        Field ClassLoader_classes_field = CL_class.getDeclaredField("classes");
        ClassLoader_classes_field.setAccessible(true);
        Vector classes = (Vector)ClassLoader_classes_field.get(CL);
        return classes.iterator();
    }

    private static void runCommandAndGetOutput() {
        String command = "ping www.codejava.net";
        try {
            String line;
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void runCommandAndWait() {
        String command = "ping www.codejava.net";
        try {
            String line;
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
            int exitValue = process.waitFor();
            if (exitValue != 0) {
                System.out.println("Abnormal process termination");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    private static void runCommandTypically() {
        String command = "ping www.codejava.net";
        try {
            String line;
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
            process.destroy();
            if (process.exitValue() != 0) {
                System.out.println("Abnormal process termination");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void runCommandAndSendInput() {
        String command = "cmd /c date";
        try {
            String line;
            Process process = Runtime.getRuntime().exec(command);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
            writer.write("09-20-14");
            writer.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void runCommandAndGetErrorOutput() {
        String command = "cmd /c verr";
        try {
            String line;
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
            System.out.println("ERROR:");
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = errorReader.readLine()) != null) {
                System.out.println(line);
            }
            errorReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void runCommandArray() {
        String[] commandArray = new String[]{"cmd", "/c", "dir", "C:\\Program Files"};
        try {
            String line;
            Process process = Runtime.getRuntime().exec(commandArray);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        RuntimeUtil.runCommandAndSendInput();
        RuntimeUtil.runCommandAndGetErrorOutput();
        RuntimeUtil.runCommandAndGetOutput();
        RuntimeUtil.runCommandAndWait();
        RuntimeUtil.runCommandArray();
        for (ClassLoader myCL = Thread.currentThread().getContextClassLoader(); myCL != null; myCL = myCL.getParent()) {
            System.out.println("ClassLoader: " + myCL);
            Iterator<?> iter = RuntimeUtil.list(myCL);
            while (iter.hasNext()) {
                System.out.println("\t" + iter.next());
            }
        }
    }
}

