/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.support;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public enum ReflectionAccess {
    NONE(0),
    FINAL(8),
    STATIC(16),
    ABSTRACT(32),
    NATIVE(64),
    SYNCHRONIZED(128),
    TRANSIENT(256),
    VOLATILE(512),
    DEFAULT(0),
    DEFAULT_NO_STATIC(8),
    DEFAULT_NO_FINAL(16),
    DEFAULT_NO_STATIC_FINAL(24),
    DEFAULT_NO_TRANSIENT(128),
    DEFAULT_NO_STATIC_TRANSIENT(136),
    PRIVATE(2),
    PRIVATE_NO_STATIC(10),
    PRIVATE_NO_FINAL(18),
    PRIVATE_NO_STATIC_FINAL(26),
    PRIVATE_NO_TRANSIENT(132),
    PRIVATE_NO_STATIC_TRANSIENT(140),
    PROTECTED(4),
    PROTECTED_NO_STATIC(12),
    PROTECTED_NO_FINAL(20),
    PROTECTED_NO_STATIC_FINAL(28),
    PROTECTED_NO_TRANSIENT(132),
    PROTECTED_NO_STATIC_TRANSIENT(142),
    PUBLIC(1),
    PUBLIC_NO_STATIC(9),
    PUBLIC_NO_FINAL(17),
    PUBLIC_NO_STATIC_FINAL(25),
    PUBLIC_NO_TRANSIENT(129),
    PUBLIC_NO_STATIC_TRANSIENT(137);

    int id;
    private static LinkedHashMap<Integer, List<Integer>> groupmap;

    private ReflectionAccess(int ID) {
        this.id = ID;
    }

    public static List<Integer> removeValues(List<Integer> integers, Integer ... intArray) {
        LinkedList<Integer> group = new LinkedList<Integer>();
        HashMap<Integer, Integer> intHash = new HashMap<Integer, Integer>();
        for (Integer init : intArray) {
            intHash.put(init, init);
        }
        for (Integer value : integers) {
            if (intHash.get(value) != null) continue;
            group.add(value);
        }
        return group;
    }

    public String toString() {
        return super.toString();
    }

    public boolean isAccess(Integer in) {
        if (groupmap.get(this.id) != null) {
            for (Integer id : groupmap.get(this.id)) {
                if (!in.equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    public Integer allow(Integer in) {
        if (groupmap.get(this.id) != null) {
            for (Integer id : groupmap.get(this.id)) {
                if (!in.equals(id)) continue;
                return id;
            }
        }
        return in;
    }

    public Integer getID() {
        return this.id;
    }

    public static ReflectionAccess valueOf(int modifiers) {
        for (ReflectionAccess access : ReflectionAccess.values()) {
            if (access.getID() != modifiers) continue;
            return access;
        }
        return null;
    }

    static {
        groupmap = new LinkedHashMap();
        LinkedList<Integer> publicGroup = new LinkedList<Integer>();
        publicGroup.add(1);
        publicGroup.add(9);
        publicGroup.add(17);
        publicGroup.add(25);
        publicGroup.add(65);
        publicGroup.add(129);
        publicGroup.add(137);
        groupmap.put(1, publicGroup);
        groupmap.put(9, ReflectionAccess.removeValues(publicGroup, PUBLIC_NO_STATIC.getID(), PUBLIC_NO_STATIC_FINAL.getID(), PUBLIC_NO_STATIC_TRANSIENT.getID()));
        groupmap.put(17, ReflectionAccess.removeValues(publicGroup, PUBLIC_NO_FINAL.getID(), PUBLIC_NO_STATIC_FINAL.getID()));
        groupmap.put(25, ReflectionAccess.removeValues(publicGroup, PUBLIC_NO_STATIC_FINAL.getID()));
        groupmap.put(129, ReflectionAccess.removeValues(publicGroup, PUBLIC_NO_TRANSIENT.getID(), PUBLIC_NO_STATIC_TRANSIENT.getID()));
        groupmap.put(137, ReflectionAccess.removeValues(publicGroup, PUBLIC_NO_STATIC_TRANSIENT.getID()));
        LinkedList<Integer> protectedGroup = new LinkedList<Integer>();
        protectedGroup.add(4);
        protectedGroup.add(12);
        protectedGroup.add(20);
        protectedGroup.add(28);
        protectedGroup.add(68);
        protectedGroup.add(132);
        protectedGroup.add(140);
        protectedGroup.addAll(publicGroup);
        groupmap.put(4, protectedGroup);
        groupmap.put(12, ReflectionAccess.removeValues(protectedGroup, PROTECTED_NO_STATIC.getID(), PROTECTED_NO_STATIC_FINAL.getID(), PROTECTED_NO_STATIC_TRANSIENT.getID(), PUBLIC_NO_STATIC.getID(), PUBLIC_NO_STATIC_FINAL.getID(), PUBLIC_NO_STATIC_TRANSIENT.getID()));
        groupmap.put(20, ReflectionAccess.removeValues(protectedGroup, PROTECTED_NO_FINAL.getID(), PROTECTED_NO_STATIC_FINAL.getID(), PUBLIC_NO_FINAL.getID(), PUBLIC_NO_STATIC_FINAL.getID()));
        groupmap.put(28, ReflectionAccess.removeValues(protectedGroup, PROTECTED_NO_STATIC_FINAL.getID(), PUBLIC_NO_STATIC_FINAL.getID()));
        groupmap.put(132, ReflectionAccess.removeValues(protectedGroup, PROTECTED_NO_TRANSIENT.getID(), PUBLIC_NO_TRANSIENT.getID()));
        groupmap.put(142, ReflectionAccess.removeValues(protectedGroup, PROTECTED_NO_STATIC_TRANSIENT.getID(), PUBLIC_NO_STATIC_TRANSIENT.getID()));
        LinkedList<Integer> defaultGroup = new LinkedList<Integer>();
        defaultGroup.add(0);
        defaultGroup.add(8);
        defaultGroup.add(16);
        defaultGroup.add(24);
        defaultGroup.add(64);
        defaultGroup.add(128);
        defaultGroup.add(136);
        defaultGroup.addAll(protectedGroup);
        groupmap.put(0, defaultGroup);
        groupmap.put(8, ReflectionAccess.removeValues(defaultGroup, DEFAULT_NO_STATIC.getID(), DEFAULT_NO_STATIC_FINAL.getID(), DEFAULT_NO_STATIC_TRANSIENT.getID(), PROTECTED_NO_STATIC.getID(), PROTECTED_NO_STATIC_FINAL.getID(), PROTECTED_NO_STATIC_TRANSIENT.getID(), PUBLIC_NO_STATIC.getID(), PUBLIC_NO_STATIC_FINAL.getID(), PUBLIC_NO_STATIC_TRANSIENT.getID()));
        groupmap.put(16, ReflectionAccess.removeValues(defaultGroup, DEFAULT_NO_FINAL.getID(), DEFAULT_NO_STATIC_FINAL.getID(), PROTECTED_NO_FINAL.getID(), PROTECTED_NO_STATIC_FINAL.getID(), PUBLIC_NO_FINAL.getID(), PUBLIC_NO_STATIC_FINAL.getID()));
        groupmap.put(24, ReflectionAccess.removeValues(defaultGroup, DEFAULT_NO_STATIC_FINAL.getID(), PROTECTED_NO_STATIC.getID(), PUBLIC_NO_STATIC.getID()));
        groupmap.put(128, ReflectionAccess.removeValues(defaultGroup, DEFAULT_NO_TRANSIENT.getID(), PROTECTED_NO_STATIC.getID(), PUBLIC_NO_STATIC.getID()));
        groupmap.put(136, ReflectionAccess.removeValues(defaultGroup, DEFAULT_NO_STATIC_TRANSIENT.getID(), PROTECTED_NO_STATIC_TRANSIENT.getID(), PUBLIC_NO_STATIC_TRANSIENT.getID()));
        LinkedList<Integer> privateGroup = new LinkedList<Integer>();
        privateGroup.add(2);
        privateGroup.add(10);
        privateGroup.add(18);
        privateGroup.add(26);
        privateGroup.add(68);
        privateGroup.add(130);
        privateGroup.addAll(defaultGroup);
        groupmap.put(2, privateGroup);
        groupmap.put(10, ReflectionAccess.removeValues(privateGroup, PRIVATE_NO_STATIC.getID(), PRIVATE_NO_STATIC_FINAL.getID(), PRIVATE_NO_STATIC_TRANSIENT.getID(), DEFAULT_NO_STATIC.getID(), DEFAULT_NO_STATIC_FINAL.getID(), DEFAULT_NO_STATIC_TRANSIENT.getID(), PROTECTED_NO_STATIC.getID(), PROTECTED_NO_STATIC_FINAL.getID(), PROTECTED_NO_STATIC_TRANSIENT.getID(), PUBLIC_NO_STATIC.getID(), PUBLIC_NO_STATIC_FINAL.getID(), PUBLIC_NO_STATIC_TRANSIENT.getID()));
        groupmap.put(16, ReflectionAccess.removeValues(privateGroup, PRIVATE_NO_FINAL.getID(), PRIVATE_NO_STATIC_FINAL.getID(), DEFAULT_NO_FINAL.getID(), DEFAULT_NO_STATIC_FINAL.getID(), PROTECTED_NO_FINAL.getID(), PROTECTED_NO_STATIC_FINAL.getID(), PUBLIC_NO_FINAL.getID(), PUBLIC_NO_STATIC_FINAL.getID()));
        groupmap.put(26, ReflectionAccess.removeValues(privateGroup, PRIVATE_NO_FINAL.getID(), PRIVATE_NO_STATIC_FINAL.getID(), DEFAULT_NO_FINAL.getID(), DEFAULT_NO_STATIC_FINAL.getID(), PROTECTED_NO_FINAL.getID(), PROTECTED_NO_STATIC_FINAL.getID(), PUBLIC_NO_FINAL.getID(), PUBLIC_NO_STATIC_FINAL.getID()));
        groupmap.put(24, ReflectionAccess.removeValues(privateGroup, PRIVATE_NO_STATIC_FINAL.getID(), DEFAULT_NO_STATIC_FINAL.getID(), PROTECTED_NO_STATIC.getID(), PUBLIC_NO_STATIC.getID()));
        groupmap.put(128, ReflectionAccess.removeValues(privateGroup, PRIVATE_NO_TRANSIENT.getID(), DEFAULT_NO_TRANSIENT.getID(), PROTECTED_NO_STATIC.getID(), PUBLIC_NO_STATIC.getID()));
        groupmap.put(136, ReflectionAccess.removeValues(privateGroup, PRIVATE_NO_STATIC_TRANSIENT.getID(), DEFAULT_NO_STATIC_TRANSIENT.getID(), PROTECTED_NO_STATIC_TRANSIENT.getID(), PUBLIC_NO_STATIC_TRANSIENT.getID()));
    }
}

