package io.github.kaststream.api;

import java.io.Serializable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;

/**
 * @deprecated This class will be remove in next version
 *     <p>Use {@link io.github.kaststream.api.v2.FlatMapper} Implement this interface to provide
 *     your own flat map function.
 */
public interface FlatMapper extends Serializable {

  /**
   * Your function implementation. Do what you need on the received rows.
   *
   * @param row the received row
   * @param out the output row collector
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public void flatMap(final Row row, final Collector<Row> out) throws Exception;

  /**
   * Declare the data type information of the data produced by your function.
   *
   * @param typeInfo the input row type information
   * @return the produced data typeInfo
   */
  public TypeInformation<Row> getProducedType(final TypeInformation<Row> typeInfo);

  /**
   * Initialization method for the function.
   *
   * @param configuration The configuration containing the parameters attached to the contract
   * @param typeInfo the input row type information
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public void open(final Configuration configuration, final TypeInformation<Row> typeInfo)
      throws Exception;

  /**
   * Tear-down method for the user code. It is called after the last call to the main working
   * methods. For functions that are part of an iteration, this method will be invoked after each
   * iteration superstep.
   *
   * <p>This method can be used for clean up work.
   *
   * @throws Exception The function may throw exceptions which cause the streaming program to fail
   *     and go into recovery.
   */
  public void close() throws Exception;
}
