/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.http.data;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import io.github.kloping.judge.Judge;
import io.github.kloping.qqbot.entities.ex.FileMsg;
import io.github.kloping.qqbot.entities.exceptions.FileMsgUploadFailedException;
import io.github.kloping.spt.interfaces.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class V2Result {
    private String id;
    private Long timestamp;
    private String group_code;
    private Integer ret = 200;
    private String msg;
    private String file_uuid;
    private String file_info;
    private Integer ttl;
    @JSONField(deserialize=false, serialize=false)
    public static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");

    public static String docMsg(String json) {
        V2Result result = (V2Result)JSON.parseObject((String)json, V2Result.class);
        if (Judge.isNotEmpty((String)result.getMsg())) {
            return result.getMsg();
        }
        return "";
    }

    public static String docFiles(String json) {
        JSONObject data = JSON.parseObject((String)json);
        if (Judge.isEmpty((String)data.getString("file_uuid"))) {
            return "";
        }
        return data.getString("file_uuid");
    }

    public void logFileInfo(Logger logger, FileMsg image) {
        if (this.file_uuid == null) {
            throw new FileMsgUploadFailedException(String.format("Failed to upload image(%s)", image.getUrl()));
        }
        logger.info("file uuid: " + this.file_uuid);
    }

    public void setTimestamp(String timestamp) {
        try {
            Long t0;
            this.timestamp = t0 = Long.valueOf(format.parse(timestamp).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public String getId() {
        return this.id;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getGroup_code() {
        return this.group_code;
    }

    public Integer getRet() {
        return this.ret;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getFile_uuid() {
        return this.file_uuid;
    }

    public String getFile_info() {
        return this.file_info;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setGroup_code(String group_code) {
        this.group_code = group_code;
    }

    public void setRet(Integer ret) {
        this.ret = ret;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setFile_uuid(String file_uuid) {
        this.file_uuid = file_uuid;
    }

    public void setFile_info(String file_info) {
        this.file_info = file_info;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof V2Result)) {
            return false;
        }
        V2Result other = (V2Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        Integer this$ret = this.getRet();
        Integer other$ret = other.getRet();
        if (this$ret == null ? other$ret != null : !((Object)this$ret).equals(other$ret)) {
            return false;
        }
        Integer this$ttl = this.getTtl();
        Integer other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$group_code = this.getGroup_code();
        String other$group_code = other.getGroup_code();
        if (this$group_code == null ? other$group_code != null : !this$group_code.equals(other$group_code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        String this$file_uuid = this.getFile_uuid();
        String other$file_uuid = other.getFile_uuid();
        if (this$file_uuid == null ? other$file_uuid != null : !this$file_uuid.equals(other$file_uuid)) {
            return false;
        }
        String this$file_info = this.getFile_info();
        String other$file_info = other.getFile_info();
        return !(this$file_info == null ? other$file_info != null : !this$file_info.equals(other$file_info));
    }

    protected boolean canEqual(Object other) {
        return other instanceof V2Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        Integer $ret = this.getRet();
        result = result * 59 + ($ret == null ? 43 : ((Object)$ret).hashCode());
        Integer $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $group_code = this.getGroup_code();
        result = result * 59 + ($group_code == null ? 43 : $group_code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        String $file_uuid = this.getFile_uuid();
        result = result * 59 + ($file_uuid == null ? 43 : $file_uuid.hashCode());
        String $file_info = this.getFile_info();
        result = result * 59 + ($file_info == null ? 43 : $file_info.hashCode());
        return result;
    }

    public String toString() {
        return "V2Result(id=" + this.getId() + ", timestamp=" + this.getTimestamp() + ", group_code=" + this.getGroup_code() + ", ret=" + this.getRet() + ", msg=" + this.getMsg() + ", file_uuid=" + this.getFile_uuid() + ", file_info=" + this.getFile_info() + ", ttl=" + this.getTtl() + ")";
    }
}

