/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbridge.listener;

import io.github.kbridge.listener.CommonJmsListener;
import io.github.kbridge.transform.MqPayloadTransformer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PostConstruct;
import javax.jms.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.stereotype.Component;

@Component
public class TopicSubscriber {
    private static final Logger log = LoggerFactory.getLogger(TopicSubscriber.class);
    @Autowired
    private ConnectionFactory connectionFactory;
    @Autowired
    private CommonJmsListener commonJmsListener;
    @Autowired(required=false)
    private List<MqPayloadTransformer> mqPayloadTransformers;

    @PostConstruct
    public void init() {
        ExecutorService executor = Executors.newFixedThreadPool(4, (ThreadFactory)new CustomizableThreadFactory("mq-in-"));
        if (Objects.isNull(this.mqPayloadTransformers)) {
            log.info("no mq topic cofigured");
            return;
        }
        this.mqPayloadTransformers.stream().forEach(s -> this.buildListner(executor, this.commonJmsListener, (MqPayloadTransformer)s));
    }

    private void buildListner(ExecutorService executor, CommonJmsListener messageListener, MqPayloadTransformer mqPTF) {
        DefaultMessageListenerContainer container = new DefaultMessageListenerContainer();
        container.setConnectionFactory(this.connectionFactory);
        container.setDestinationName(mqPTF.mqTopic());
        container.setMessageListener((Object)messageListener);
        container.setPubSubDomain(mqPTF.isPubSubDomain());
        container.setTaskExecutor((Executor)executor);
        container.initialize();
        container.start();
        log.info("topic: {} subscribed ispublish: {} ", (Object)mqPTF.mqTopic(), (Object)mqPTF.isPubSubDomain());
    }
}

