/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javaforce.JFLog;

public class Compression {
    private static final int blocksize = 65536;

    public static void main(String[] args) {
        File output;
        File input;
        try {
            input = new File("tapetool.exe");
            output = new File("compress.dat");
            FileInputStream fis = new FileInputStream(input);
            FileOutputStream fos = new FileOutputStream(output);
            long uncompressed = input.length();
            System.out.println("  org size=" + uncompressed);
            long compressed = Compression.compress(fis, fos, uncompressed);
            System.out.println("  compressed=" + compressed);
            fis.close();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            input = new File("compress.dat");
            output = new File("uncompress.dat");
            long compressed = input.length();
            FileInputStream fis = new FileInputStream(input);
            FileOutputStream fos = new FileOutputStream(output);
            long uncompressed = Compression.decompress(fis, fos, compressed);
            System.out.println("uncompressed=" + uncompressed);
            fis.close();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        System.out.println("done");
    }

    public static long compress(InputStream is, OutputStream os, long uncompressed) throws Exception {
        int compressed;
        long left = uncompressed;
        long wrote = 0L;
        byte[] in = new byte[65536];
        byte[] out = new byte[65536];
        Deflater compress = new Deflater();
        while (left > 0L) {
            int toread;
            int read;
            if (compress.needsInput() && (read = is.read(in, 0, toread = left > 65536L ? 65536 : (int)left)) > 0) {
                compress.setInput(in, 0, read);
                left -= (long)read;
            }
            if ((compressed = compress.deflate(out)) <= 0) continue;
            os.write(out, 0, compressed);
            wrote += (long)compressed;
        }
        compress.finish();
        while (!compress.finished()) {
            compressed = compress.deflate(out);
            if (compressed <= 0) continue;
            os.write(out, 0, compressed);
            wrote += (long)compressed;
        }
        compress.end();
        return wrote;
    }

    public static long decompress(InputStream is, OutputStream os, long compressed) throws Exception {
        int uncompressed;
        long left = compressed;
        long wrote = 0L;
        byte[] in = new byte[65536];
        byte[] out = new byte[65536];
        Inflater decompress = new Inflater();
        while (left > 0L) {
            int toread;
            int read;
            if (decompress.needsInput() && (read = is.read(in, 0, toread = left > 65536L ? 65536 : (int)left)) > 0) {
                decompress.setInput(in, 0, read);
                left -= (long)read;
            }
            if ((uncompressed = decompress.inflate(out)) <= 0) continue;
            os.write(out, 0, uncompressed);
            wrote += (long)uncompressed;
        }
        while (!decompress.finished()) {
            uncompressed = decompress.inflate(out);
            if (uncompressed <= 0) continue;
            os.write(out, 0, uncompressed);
            wrote += (long)uncompressed;
        }
        decompress.end();
        return wrote;
    }

    public static boolean serialize(String file, Object obj) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            boolean res = Compression.serialize(fos, obj);
            fos.close();
            return res;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean serialize(OutputStream os, Object obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            ByteArrayInputStream biis = new ByteArrayInputStream(baos.toByteArray());
            Compression.compress(biis, os, baos.size());
            return true;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static Object deserialize(String file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            Object obj = Compression.deserialize(fis, new File(file).length());
            fis.close();
            return obj;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public static Object deserialize(InputStream is, long length) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Compression.decompress(is, baos, length);
            ByteArrayInputStream biis = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(biis);
            Object obj = ois.readObject();
            return obj;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }
}

