/*
 * Decompiled with CFR 0.152.
 */
package javaforce.cl;

import java.io.File;
import java.util.Random;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.LE;
import javaforce.jni.JFNative;
import javaforce.jni.Library;
import javaforce.jni.LnxNative;

public class CL
implements AutoCloseable {
    public static final int TYPE_DEFAULT = 1;
    public static final int TYPE_CPU = 2;
    public static final int TYPE_GPU = 4;
    public static final int TYPE_ACCELERATOR = 8;
    private long ctx;
    private static final int MEM_READ_WRITE = 1;
    private static final int MEM_WRITE = 2;
    private static final int MEM_READ = 4;
    private static final int SIZE = 65536;

    private static native boolean ninit(String var0);

    public static boolean init() {
        File[] sysFolders;
        String ext = "";
        String apphome = System.getProperty("java.app.home");
        String name = "OpenCL";
        if (apphome == null) {
            apphome = ".";
        }
        if (JF.isWindows()) {
            sysFolders = new File[]{new File(System.getenv("windir") + "\\system32"), new File(apphome), new File(".")};
            ext = ".dll";
            name = name.toLowerCase();
        } else if (JF.isMac()) {
            sysFolders = new File[]{new File("/System/Library/Frameworks/OpenCL.framework/Versions/Current/Libraries"), new File(apphome), new File(".")};
            ext = ".dylib";
        } else {
            sysFolders = new File[]{new File("/usr/lib"), new File(LnxNative.getArchLibFolder())};
            ext = ".so";
        }
        Library[] libs = new Library[]{new Library(name)};
        JFNative.findLibraries(sysFolders, libs, ext);
        if (libs[0].path == null) {
            JFLog.log("Error:Unable to find OpenCL library");
            return false;
        }
        return CL.ninit(libs[0].path);
    }

    private CL(long ctx) {
        this.ctx = ctx;
    }

    private static native long ncreate(String var0, int var1);

    public static CL create(String src, int type) {
        return new CL(CL.ncreate(src, type));
    }

    public static CL create(String src) {
        return CL.create(src, 1);
    }

    private static native long nkernel(long var0, String var2);

    public long kernel(String func) {
        return CL.nkernel(this.ctx, func);
    }

    private native long ncreateBuffer(long var1, int var3, int var4);

    public long createReadBuffer(int size) {
        return this.ncreateBuffer(this.ctx, size, 4);
    }

    public long createWriteBuffer(int size) {
        return this.ncreateBuffer(this.ctx, size, 2);
    }

    public long createReadWriteBuffer(int size) {
        return this.ncreateBuffer(this.ctx, size, 1);
    }

    private static native boolean nsetArg(long var0, long var2, int var4, byte[] var5);

    public boolean setArg(long kernel, int idx, byte[] value) {
        return CL.nsetArg(this.ctx, kernel, idx, value);
    }

    public boolean setArg(long kernel, int idx, long value) {
        byte[] tmp = new byte[8];
        LE.setuint64(tmp, 0, value);
        return CL.nsetArg(this.ctx, kernel, idx, tmp);
    }

    private static native boolean nwriteBufferi8(long var0, long var2, byte[] var4);

    public boolean writeBuffer(long buffer, byte[] data) {
        return CL.nwriteBufferi8(this.ctx, buffer, data);
    }

    private static native boolean nwriteBufferf32(long var0, long var2, float[] var4);

    public boolean writeBuffer(long buffer, float[] data) {
        return CL.nwriteBufferf32(this.ctx, buffer, data);
    }

    private static native boolean nexecute(long var0, long var2, int var4);

    public boolean execute(long kernel, int count) {
        return CL.nexecute(this.ctx, kernel, count);
    }

    private static native boolean nreadBufferi8(long var0, long var2, byte[] var4);

    public boolean readBuffer(long buffer, byte[] data) {
        return CL.nreadBufferi8(this.ctx, buffer, data);
    }

    private static native boolean nreadBufferf32(long var0, long var2, float[] var4);

    public boolean readBuffer(long buffer, float[] data) {
        return CL.nreadBufferf32(this.ctx, buffer, data);
    }

    private static native boolean nfreeKernel(long var0, long var2);

    public boolean freeKernel(long kernel) {
        return CL.nfreeKernel(this.ctx, kernel);
    }

    private static native boolean nfreeBuffer(long var0, long var2);

    public boolean freeBuffer(long buffer) {
        return CL.nfreeBuffer(this.ctx, buffer);
    }

    private static native boolean nclose(long var0);

    @Override
    public void close() {
        if (this.ctx != 0L) {
            CL.nclose(this.ctx);
            this.ctx = 0L;
        }
    }

    public static void main(String[] args) {
        if (!CL.init()) {
            JFLog.log("OpenCL init failed");
            System.exit(1);
        }
        System.out.println("Starting Java test...");
        try {
            CL cl = CL.create("__kernel void square(__global float* input, __global float* output) { int i = get_global_id(0); output[i] = input[i] * input[i]; }", 4);
            long kernel = cl.kernel("square");
            long input = cl.createWriteBuffer(262144);
            long output = cl.createReadBuffer(262144);
            float[] data = new float[65536];
            Random r = new Random();
            for (int i = 0; i < 65536; ++i) {
                data[i] = r.nextFloat();
            }
            float[] results = new float[65536];
            cl.writeBuffer(input, data);
            cl.setArg(kernel, 0, input);
            cl.setArg(kernel, 1, output);
            cl.execute(kernel, 65536);
            cl.readBuffer(output, results);
            cl.freeBuffer(input);
            cl.freeBuffer(output);
            cl.freeKernel(kernel);
            cl.close();
            int correct = 0;
            for (int i = 0; i < 65536; ++i) {
                if (results[i] != data[i] * data[i]) continue;
                ++correct;
            }
            System.out.println("java test:" + correct + "/65536 are correct");
        }
        catch (Throwable t) {
            JFLog.log(t);
        }
    }
}

