/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl.model;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javaforce.JFLog;
import javaforce.JSON;
import javaforce.gl.Model;
import javaforce.gl.Object3;
import javaforce.gl.UVMap;
import javaforce.gl.model.Model_IO;

public class ModelJSON
implements Model_IO {
    private static boolean debug = false;
    public float scale = 16.0f;
    private float tw;
    private float th;
    private float width;
    private float height;
    private float depth;
    private boolean mirror;
    private float[] xyz = new float[3];
    private float[] uv = new float[2];
    private int[] pts = new int[4];

    public ModelJSON() {
        this.scale = 16.0f;
    }

    public ModelJSON(float scale) {
        this.scale = scale;
    }

    public Model load(String filename) {
        try {
            FileInputStream is = new FileInputStream(filename);
            Model model = this.load(is);
            ((InputStream)is).close();
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Model load(InputStream is) {
        Model model = new Model();
        int mapidx = 0;
        try {
            String json = new String(is.readAllBytes());
            JSON.debug = debug;
            JSON.Element root = JSON.parse(json);
            if (debug) {
                root.print();
            }
            for (JSON.Element child : root.children) {
                if (!child.key.startsWith("geometry.")) continue;
                JSON.Element geo = child;
                String ename = geo.key.substring(9);
                int idx = ename.indexOf(46);
                if (idx != -1) {
                    ename = ename.substring(0, idx);
                }
                JSON.Element etw = geo.getChild("texturewidth");
                this.tw = this.getValue(etw.value);
                JSON.Element eth = geo.getChild("textureheight");
                this.th = this.getValue(eth.value);
                JSON.Element bones = geo.getChild("bones");
                for (JSON.Element box : bones.children) {
                    JSON.Element name = box.getChild("name");
                    JSON.Element pvt = box.getChild("pivot");
                    float[] pvts = this.getValues(pvt);
                    JSON.Element cubes = box.getChild("cubes");
                    if (cubes == null) continue;
                    for (JSON.Element cube : cubes.children) {
                        JSON.Element _mirror;
                        JSON.Element org = cube.getChild("origin");
                        float[] orgs = this.getValues(org);
                        JSON.Element size = cube.getChild("size");
                        float[] sizes = this.getValues(size);
                        JSON.Element uv = cube.getChild("uv");
                        float[] uvs = this.getValues(uv);
                        float u = uvs[0];
                        float v = uvs[1];
                        JSON.Element _inflate = cube.getChild("inflate");
                        if (_inflate != null) {
                            float inflate = this.getValue(_inflate.value) / this.scale;
                            float inflate_2 = inflate * 2.0f;
                            sizes[0] = sizes[0] + inflate_2;
                            sizes[1] = sizes[1] + inflate_2;
                            sizes[2] = sizes[2] + inflate_2;
                            orgs[0] = orgs[0] - inflate;
                            orgs[1] = orgs[1] - inflate;
                            orgs[2] = orgs[2] - inflate;
                        }
                        this.mirror = (_mirror = cube.getChild("mirror")) != null && _mirror.value.equals("true");
                        float x = orgs[0];
                        float y = orgs[1];
                        float z = orgs[2];
                        this.width = sizes[0];
                        this.height = sizes[1];
                        this.depth = sizes[2];
                        Object3 obj = new Object3();
                        obj.type = 7;
                        UVMap map = obj.createUVMap();
                        map.name = "map-" + mapidx++;
                        model.addObject(obj);
                        obj.org.x = pvts[0] / this.scale;
                        obj.org.y = pvts[1] / this.scale;
                        obj.org.z = pvts[2] / this.scale;
                        obj.name = name.value;
                        v += this.depth + this.height;
                        x += this.width;
                        z += this.depth;
                        if (this.mirror) {
                            this.addFaceE(obj, x, y, z, u + this.depth + this.width, v);
                        } else {
                            this.addFaceE(obj, x, y, z, u, v);
                        }
                        this.addFaceN(obj, x, y, z -= this.depth, u += this.depth, v);
                        if (this.mirror) {
                            this.mirror(obj);
                        }
                        x -= this.width;
                        u += this.width;
                        if (this.mirror) {
                            this.addFaceW(obj, x, y, z, u - this.depth - this.width, v);
                        } else {
                            this.addFaceW(obj, x, y, z, u, v);
                        }
                        this.addFaceS(obj, x, y, z += this.depth, u += this.depth, v);
                        if (this.mirror) {
                            this.mirror(obj);
                        }
                        this.addFaceB(obj, x, y, z, u -= this.depth, v -= this.height);
                        if (this.mirror) {
                            this.mirror(obj);
                        }
                        this.addFaceA(obj, x, y += this.height, z, u -= this.width, v);
                        if (!this.mirror) continue;
                        this.mirror(obj);
                    }
                }
            }
            return model;
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    private void addFaceW(Object3 obj, float x, float y, float z, float u, float v) {
        int vidx = obj.getVertexCount();
        this.addVertex(obj, x, y, z, u, v);
        this.addVertex(obj, x, y, z += this.depth, u += this.depth, v);
        this.addVertex(obj, x, y += this.height, z, u, v -= this.height);
        this.addVertex(obj, x, y, z -= this.depth, u -= this.depth, v);
        for (int a = 0; a < 4; ++a) {
            this.pts[a] = vidx++;
        }
        obj.addPoly(this.pts);
    }

    private void addFaceS(Object3 obj, float x, float y, float z, float u, float v) {
        int vidx = obj.getVertexCount();
        this.addVertex(obj, x, y, z, u, v);
        this.addVertex(obj, x += this.width, y, z, u += this.width, v);
        this.addVertex(obj, x, y += this.height, z, u, v -= this.height);
        this.addVertex(obj, x -= this.width, y, z, u -= this.width, v);
        for (int a = 0; a < 4; ++a) {
            this.pts[a] = vidx++;
        }
        obj.addPoly(this.pts);
    }

    private void addFaceE(Object3 obj, float x, float y, float z, float u, float v) {
        int vidx = obj.getVertexCount();
        this.addVertex(obj, x, y, z, u, v);
        this.addVertex(obj, x, y, z -= this.depth, u += this.depth, v);
        this.addVertex(obj, x, y += this.height, z, u, v -= this.height);
        this.addVertex(obj, x, y, z += this.depth, u -= this.depth, v);
        for (int a = 0; a < 4; ++a) {
            this.pts[a] = vidx++;
        }
        obj.addPoly(this.pts);
    }

    private void addFaceN(Object3 obj, float x, float y, float z, float u, float v) {
        int vidx = obj.getVertexCount();
        this.addVertex(obj, x, y, z, u, v);
        this.addVertex(obj, x -= this.width, y, z, u += this.width, v);
        this.addVertex(obj, x, y += this.height, z, u, v -= this.height);
        this.addVertex(obj, x += this.width, y, z, u -= this.width, v);
        for (int a = 0; a < 4; ++a) {
            this.pts[a] = vidx++;
        }
        obj.addPoly(this.pts);
    }

    private void addFaceB(Object3 obj, float x, float y, float z, float u, float v) {
        int vidx = obj.getVertexCount();
        this.addVertex(obj, x, y, z, u, v);
        this.addVertex(obj, x, y, z -= this.depth, u, v -= this.depth);
        this.addVertex(obj, x += this.width, y, z, u += this.width, v);
        this.addVertex(obj, x, y, z += this.depth, u, v += this.depth);
        for (int a = 0; a < 4; ++a) {
            this.pts[a] = vidx++;
        }
        obj.addPoly(this.pts);
    }

    private void addFaceA(Object3 obj, float x, float y, float z, float u, float v) {
        int vidx = obj.getVertexCount();
        this.addVertex(obj, x, y, z, u, v);
        this.addVertex(obj, x += this.width, y, z, u += this.width, v);
        this.addVertex(obj, x, y, z -= this.depth, u, v -= this.depth);
        this.addVertex(obj, x -= this.width, y, z, u -= this.width, v);
        for (int a = 0; a < 4; ++a) {
            this.pts[a] = vidx++;
        }
        obj.addPoly(this.pts);
    }

    private void mirror(Object3 obj) {
        float[] uv = obj.getUVMap((int)0).uvl.getBuffer();
        int idx = obj.getVertexCount();
        int v1 = (idx - 4) * 2;
        int v2 = (idx - 3) * 2;
        int v3 = (idx - 2) * 2;
        int v4 = (idx - 1) * 2;
        float tmp = uv[v1];
        uv[v1] = uv[v2];
        uv[v2] = tmp;
        tmp = uv[v3];
        uv[v3] = uv[v4];
        uv[v4] = tmp;
    }

    private void addVertex(Object3 obj, float x, float y, float z, float u, float v) {
        this.xyz[0] = x / this.scale;
        this.xyz[1] = y / this.scale;
        this.xyz[2] = z / this.scale;
        this.uv[0] = u / this.tw;
        this.uv[1] = v / this.th;
        obj.addVertex(this.xyz, this.uv);
    }

    private float getValue(String e) {
        return Float.valueOf(e).floatValue();
    }

    private float[] getValues(JSON.Element array) {
        int cnt = array.getChildCount();
        float[] values = new float[cnt];
        for (int i = 0; i < cnt; ++i) {
            JSON.Element child = array.getChild(i);
            values[i] = Float.valueOf(child.value).floatValue();
        }
        return values;
    }

    @Override
    public boolean save(Model model, OutputStream os) {
        return false;
    }
}

