/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Set;
import javaforce.HTTP;
import javaforce.JFLog;
import javaforce.voip.CallDetails;
import javaforce.voip.CallDetailsServer;
import javaforce.voip.SIP;
import javaforce.voip.SIPInterface;
import javaforce.voip.SIPServerInterface;
import javaforce.voip.TransportType;

public class SIPServer
extends SIP
implements SIPInterface {
    private int localport;
    private String localhost;
    private HashMap<String, CallDetailsServer> cdlist;
    private SIPServerInterface iface;
    private boolean use_qop = false;
    private static final String realm = "javaforce";
    private HashMap<String, Trunk> trunks = new HashMap();

    public boolean init(int localport, SIPServerInterface iface, TransportType type) {
        this.iface = iface;
        this.localport = localport;
        this.cdlist = new HashMap();
        try {
            JFLog.log("Starting SIP Server on port " + localport);
            super.init(this.localhost, localport, this, true, type);
        }
        catch (Exception e) {
            JFLog.log("SIPServer:init() failed : " + String.valueOf(e));
            return false;
        }
        return true;
    }

    @Override
    public void uninit() {
        super.uninit();
    }

    public void enableQOP(boolean state) {
        this.use_qop = state;
    }

    public CallDetailsServer getCallDetailsServer(String callid) {
        CallDetailsServer cd = this.cdlist.get(callid);
        if (cd == null) {
            cd = this.iface.createCallDetailsServer();
            cd.sip = this;
            cd.callid = callid;
            cd.localhost = this.localhost;
            this.setCallDetailsServer(callid, cd);
        }
        return cd;
    }

    public void setCallDetailsServer(String callid, CallDetailsServer cd) {
        if (cd == null) {
            this.cdlist.remove(callid);
        } else {
            this.cdlist.put(callid, cd);
        }
    }

    public boolean issue(CallDetailsServer cd, String header, boolean sdp, boolean src) {
        CallDetails.SideDetails cdsd = src ? cd.pbxsrc : cd.pbxdst;
        JFLog.log("callid:" + cd.callid + "\r\nissue command : " + cd.cmd + " from : " + cd.user + " to : " + cdsd.host + ":" + cdsd.port);
        StringBuilder req = new StringBuilder();
        req.append(cd.cmd + " " + cd.uri + " SIP/2.0\r\n");
        req.append("Via: SIP/2.0/UDP " + cd.localhost + ":" + this.localport + ";branch=" + cdsd.branch + "\r\n");
        req.append("Max-Forwards: 70\r\n");
        req.append("Contact: " + cdsd.contact + "\r\n");
        req.append("To: " + SIPServer.join(cdsd.to) + "\r\n");
        req.append("From: " + SIPServer.join(cdsd.from) + "\r\n");
        req.append("Call-ID: " + cd.callid + "\r\n");
        req.append("Cseq: " + cdsd.cseq + " " + cd.cmd + "\r\n");
        req.append("Allow: INVITE, ACK, CANCEL, BYE, REFER, NOTIFY, OPTIONS\r\n");
        req.append("User-Agent: " + useragent + "\r\n");
        if (header != null) {
            req.append(header);
        }
        if (cd.sdp != null && sdp) {
            String post = String.join((CharSequence)"\r\n", cd.sdp) + "\r\n";
            if (cd.cmd.equals("MESSAGE")) {
                req.append("Content-Type: text/plain\r\n");
            } else {
                req.append("Content-Type: application/sdp\r\n");
            }
            req.append("Content-Length: " + post.length() + "\r\n\r\n");
            req.append(post);
        } else {
            req.append("Content-Length: 0\r\n\r\n");
        }
        if (cdsd.addr == null) {
            try {
                cdsd.addr = InetAddress.getByName(cdsd.host);
            }
            catch (Exception e) {
                JFLog.log(e);
                return false;
            }
        }
        return this.send(cdsd.addr, cdsd.port, req.toString());
    }

    public boolean reply(CallDetailsServer cd, int code, String msg, String header, boolean sdp, boolean src) {
        CallDetails.SideDetails cdsd = src ? cd.pbxsrc : cd.pbxdst;
        JFLog.log("callid:" + cd.callid + "\r\nissue reply : " + code + " to : " + cdsd.host + ":" + cdsd.port);
        StringBuilder req = new StringBuilder();
        req.append("SIP/2.0 " + code + " " + msg + "\r\n");
        if (cdsd.vialist != null) {
            for (int a = 0; a < cdsd.vialist.length; ++a) {
                if (a == 0) {
                    String via = cdsd.vialist[a];
                    String[] f = via.split(";");
                    StringBuilder sb = new StringBuilder();
                    for (int b = 0; b < f.length; ++b) {
                        if (f[b].equals("rport")) {
                            f[b] = "rport=" + cdsd.port;
                        }
                        sb.append(f[b]);
                        sb.append(";");
                    }
                    sb.append("received=" + cdsd.host);
                    req.append(sb.toString());
                    req.append("\r\n");
                    continue;
                }
                req.append(cdsd.vialist[a]);
                req.append("\r\n");
            }
        }
        if (code < 400) {
            req.append("Contact: " + cdsd.contact + "\r\n");
        }
        req.append("To: " + SIPServer.join(cdsd.to) + "\r\n");
        req.append("From: " + SIPServer.join(cdsd.from) + "\r\n");
        req.append("Call-ID: " + cd.callid + "\r\n");
        req.append("Cseq: " + cdsd.cseq + " " + cd.cmd + "\r\n");
        req.append("Allow: INVITE, ACK, CANCEL, BYE, REFER, NOTIFY, OPTIONS\r\n");
        req.append("User-Agent: " + useragent + "\r\n");
        if (header != null) {
            req.append(header);
        }
        if (cd.sdp != null && sdp) {
            String post = String.join((CharSequence)"\r\n", cd.sdp) + "\r\n";
            req.append("Content-Type: application/sdp\r\n");
            req.append("Content-Length: " + post.length() + "\r\n\r\n");
            req.append(post);
        } else {
            req.append("Content-Length: 0\r\n\r\n");
        }
        if (cdsd.addr == null) {
            try {
                cdsd.addr = InetAddress.getByName(cdsd.host);
            }
            catch (Exception e) {
                JFLog.log(e);
                return false;
            }
        }
        return this.send(cdsd.addr, cdsd.port, req.toString());
    }

    @Override
    public String getlocalRTPhost(CallDetails cd) {
        return cd.localhost;
    }

    public boolean register(String user, String pass, String remotehost, int remoteport, int expires, String did, String regcallid) {
        String key = remotehost + ":" + remoteport;
        Trunk trunk = new Trunk();
        trunk.user = user;
        trunk.auth = user;
        trunk.pass = pass;
        this.trunks.put(key, trunk);
        CallDetailsServer cd = this.getCallDetailsServer(regcallid);
        cd.user = user;
        cd.pass = pass;
        cd.pbxsrc.expires = expires;
        cd.pbxsrc.to = new String[]{user, user, remotehost + ":" + remoteport, ":"};
        cd.pbxsrc.from = new String[]{user, user, remotehost + ":" + remoteport, ":"};
        cd.pbxsrc.from = SIPServer.replacetag(cd.pbxsrc.from, SIPServer.generatetag());
        cd.pbxsrc.contact = "<sip:" + did + "@" + cd.localhost + ":" + this.localport + ">";
        cd.uri = "sip:" + remotehost;
        cd.callid = regcallid;
        cd.pbxsrc.branch = this.getbranch();
        ++cd.pbxsrc.cseq;
        cd.cmd = "REGISTER";
        cd.src.host = cd.pbxsrc.host = remotehost;
        cd.src.port = cd.pbxsrc.port = remoteport;
        cd.authsent = false;
        boolean ret = this.issue(cd, null, false, true);
        return ret;
    }

    public void clone(CallDetails.SideDetails src, CallDetails.SideDetails dst) {
        dst.host = src.host;
        dst.port = src.port;
        dst.to = (String[])src.to.clone();
        dst.from = (String[])src.from.clone();
        dst.cseq = src.cseq;
        dst.branch = src.branch;
        dst.contact = src.contact;
        dst.vialist = src.vialist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void packet(String[] msg, String remoteip, int remoteport) {
        try {
            String cmd = null;
            String callid = HTTP.getParameter(msg, "Call-ID");
            if (callid == null) {
                callid = HTTP.getParameter(msg, "i");
            }
            if (callid == null) {
                JFLog.log("Bad packet (no Call-ID) from:" + remoteip + ":" + remoteport);
                return;
            }
            CallDetailsServer cd = this.getCallDetailsServer(callid);
            if (cd.localhost == null && !msg[0].startsWith("SIP/")) {
                int idx1;
                String[] f = msg[0].split(" ");
                String sip = f[1];
                if (sip.startsWith("sip:")) {
                    sip = sip.substring(4);
                }
                idx1 = (idx1 = sip.indexOf("@")) == -1 ? 0 : ++idx1;
                int idx2 = sip.indexOf(":");
                String host = idx2 == -1 ? sip.substring(idx1) : sip.substring(idx1, idx2);
                cd.localhost = InetAddress.getByName(host).getHostAddress();
                JFLog.log("server address=" + cd.localhost);
                this.localhost = cd.localhost;
            }
            cd.lastPacket = System.currentTimeMillis();
            boolean src = false;
            CallDetails.SideDetails cdsd = null;
            CallDetails.SideDetails cdpbx = null;
            Object object = cd.lock;
            synchronized (object) {
                if (cd.src.host == null && cd.dst.host == null) {
                    src = true;
                    cdsd = cd.src;
                    cdpbx = cd.pbxsrc;
                } else if (cd.src.host != null && this.resolve(cd.src.host).equals(remoteip) && cd.src.port == remoteport) {
                    src = true;
                    cdsd = cd.src;
                    cdpbx = cd.pbxsrc;
                } else if (cd.dst.host != null && this.resolve(cd.dst.host).equals(remoteip) && cd.dst.port == remoteport) {
                    src = false;
                    cdsd = cd.dst;
                    cdpbx = cd.pbxdst;
                } else {
                    JFLog.log("Ignoring packet from unknown host:" + remoteip + ":" + remoteport);
                    return;
                }
                cdsd.cseq = this.getcseq(msg);
                cdsd.host = remoteip;
                cdsd.port = remoteport;
                cdsd.branch = this.getbranch(msg);
                String tmp = HTTP.getParameter(msg, "To");
                if (tmp == null) {
                    tmp = HTTP.getParameter(msg, "t");
                }
                cdsd.to = SIPServer.split(tmp);
                tmp = HTTP.getParameter(msg, "From");
                if (tmp == null) {
                    tmp = HTTP.getParameter(msg, "f");
                }
                cdsd.from = SIPServer.split(tmp);
                cd.user = cdsd.from[1];
                cdsd.vialist = this.getvialist(msg);
                cdsd.contact = HTTP.getParameter(msg, "Contact");
                if (cdsd.contact == null) {
                    cdsd.contact = HTTP.getParameter(msg, "m");
                }
                cd.cmd = this.getcseqcmd(msg);
                int reply = this.getResponseType(msg);
                if (reply != -1) {
                    JFLog.log("callid:" + callid + "\r\nreply=" + reply + " from " + remoteip + ":" + remoteport);
                } else {
                    cmd = this.getRequest(msg);
                    JFLog.log("callid:" + callid + "\r\nrequest=" + cmd + " from " + remoteip + ":" + remoteport);
                }
                switch (reply) {
                    case -1: {
                        this.clone(cdsd, cdpbx);
                        if (cmd.equalsIgnoreCase("REGISTER")) {
                            String auth = HTTP.getParameter(msg, "Authorization");
                            if (auth == null) {
                                cd.nonce = this.getnonce();
                                String challenge = "WWW-Authenticate: Digest algorithm=MD5, realm=\"javaforce\", nonce=\"" + cd.nonce + "\"";
                                if (this.use_qop) {
                                    challenge = challenge + ", qop=\"auth\"";
                                }
                                challenge = challenge + "\r\n";
                                this.reply(cd, 401, "REQ AUTH", challenge, false, src);
                                break;
                            }
                            if (!auth.regionMatches(true, 0, "digest ", 0, 7)) {
                                JFLog.log("invalid Authorization");
                                break;
                            }
                            String[] tags = SIPServer.convertParameters(auth.substring(7), ',');
                            String res = HTTP.getParameter(tags, "response");
                            String nonce = HTTP.getParameter(tags, "nonce");
                            if (nonce == null || cd.nonce == null || !cd.nonce.equals(nonce)) {
                                cd.nonce = this.getnonce();
                                String challenge = "WWW-Authenticate: Digest algorithm=MD5, realm=\"javaforce\", nonce=\"" + cd.nonce + "\"";
                                if (this.use_qop) {
                                    challenge = challenge + ", qop=\"auth\"";
                                }
                                challenge = challenge + "\r\n";
                                this.reply(cd, 401, "REQ AUTH", challenge, false, src);
                                break;
                            }
                            String test = this.getResponse(cd.user, this.iface.getPassword(cd.user), realm, cd.cmd, HTTP.getParameter(tags, "uri"), cd.nonce, HTTP.getParameter(tags, "qop"), HTTP.getParameter(tags, "nc"), HTTP.getParameter(tags, "cnonce"));
                            cd.nonce = null;
                            if (!res.equalsIgnoreCase(test)) {
                                this.reply(cd, 403, "BAD PASSWORD", null, false, src);
                                this.setCallDetailsServer(callid, null);
                                break;
                            }
                            this.iface.onRegister(cd.user, this.getexpires(msg), remoteip, remoteport);
                            this.reply(cd, 200, "OK", null, false, src);
                            this.setCallDetailsServer(callid, null);
                            break;
                        }
                        if (cmd.equalsIgnoreCase("INVITE")) {
                            String pass = this.iface.getPassword(cd.user);
                            if (pass != null) {
                                String resln = HTTP.getParameter(msg, "Proxy-Authorization");
                                if (resln == null || cd.nonce == null) {
                                    cd.nonce = this.getnonce();
                                    String challenge = "Proxy-Authenticate: Digest algorithm=MD5, realm=\"javaforce\", nonce=\"" + cd.nonce + "\"\r\n";
                                    this.reply(cd, 407, "REQ AUTH", challenge, false, src);
                                    break;
                                }
                                if (!resln.regionMatches(true, 0, "digest ", 0, 7)) break;
                                String[] tags = SIPServer.convertParameters(resln.substring(7), ',');
                                String res = HTTP.getParameter(tags, "response");
                                String nonce = HTTP.getParameter(tags, "nonce");
                                if (nonce == null || !cd.nonce.equals(nonce)) {
                                    cd.nonce = this.getnonce();
                                    String challenge = "Proxy-Authenticate: Digest algorithm=MD5, realm=\"javaforce\", nonce=\"" + cd.nonce + "\"\r\n";
                                    this.reply(cd, 407, "REQ AUTH", challenge, false, src);
                                    break;
                                }
                                String test = this.getResponse(cd.user, pass, realm, cd.cmd, HTTP.getParameter(tags, "uri"), cd.nonce, null, null, null);
                                cd.nonce = null;
                                if (!res.equalsIgnoreCase(test)) {
                                    this.reply(cd, 403, "BAD PASSWORD", null, false, src);
                                    this.setCallDetailsServer(callid, null);
                                    break;
                                }
                                this.iface.onRegister(cd.user, 3600, remoteip, remoteport);
                            }
                            cd.dialed = cdsd.to[1];
                            cd.fromname = cdsd.from[0];
                            cd.fromnumber = cdsd.from[1];
                            cdsd.sdp = SIPServer.getSDP(msg);
                            JFLog.log("src=" + String.valueOf(cdsd.sdp));
                            cd.authorized = pass != null;
                            this.iface.onInvite(cd, src);
                            break;
                        }
                        if (cmd.equalsIgnoreCase("CANCEL")) {
                            this.iface.onCancel(cd, src);
                            break;
                        }
                        if (cmd.equalsIgnoreCase("BYE")) {
                            this.iface.onBye(cd, src);
                            break;
                        }
                        if (cmd.equalsIgnoreCase("ACK")) break;
                        if (cmd.equalsIgnoreCase("REFER")) {
                            this.iface.onFeature(cd, cmd, HTTP.getParameter(msg, "Refer-To"), src);
                            break;
                        }
                        if (cmd.equalsIgnoreCase("OPTIONS")) {
                            this.iface.onOptions(cd, src);
                            break;
                        }
                        if (cmd.equalsIgnoreCase("SUBSCRIBE")) {
                            this.reply(cd, 200, "OK", null, false, src);
                            this.setCallDetailsServer(callid, null);
                            break;
                        }
                        if (cmd.equalsIgnoreCase("SHUTDOWN")) {
                            this.iface.onFeature(cd, cmd, remoteip, src);
                            this.setCallDetailsServer(callid, null);
                            break;
                        }
                        if (cmd.equalsIgnoreCase("MESSAGE")) {
                            this.iface.onMessage(cd, cdsd.from[1], cdsd.to[1], HTTP.getContent(msg), src);
                            break;
                        }
                        JFLog.log("Unknown command:" + cmd);
                        this.setCallDetailsServer(callid, null);
                        break;
                    }
                    case 100: {
                        this.iface.onTrying(cd, src);
                        break;
                    }
                    case 180: 
                    case 183: {
                        this.iface.onRinging(cd, src);
                        break;
                    }
                    case 200: {
                        if (cd.cmd.equals("INVITE")) {
                            cdsd.to = SIPServer.replacetag(cdsd.to, HTTP.getParameter(msg, "To"));
                            cdsd.to = SIPServer.replacetag(cdsd.to, HTTP.getParameter(msg, "t"));
                            cdpbx.to = (String[])cdsd.to.clone();
                            cdsd.sdp = SIPServer.getSDP(msg);
                        } else {
                            if (cd.cmd.equals("BYE")) {
                                this.setCallDetailsServer(cd.callid, null);
                                break;
                            }
                            if (cd.cmd.equals("REGISTER")) {
                                cd.cmd = "ACK";
                                this.issue(cd, null, false, src);
                                this.setCallDetailsServer(callid, null);
                                break;
                            }
                        }
                        this.iface.onSuccess(cd, src);
                        break;
                    }
                    case 401: {
                        String key;
                        Trunk trunk;
                        if (cd.authsent) {
                            JFLog.log("Server Error : Double 401");
                            this.setCallDetailsServer(callid, null);
                            break;
                        }
                        boolean sdp = false;
                        if (cd.cmd.equals("INVITE")) {
                            cd.cmd = "ACK";
                            this.issue(cd, null, false, src);
                            cd.cmd = "INVITE";
                            sdp = true;
                        }
                        if ((trunk = this.trunks.get(key = remoteip + ":" + remoteport)) == null) {
                            JFLog.log("err:trunk not found:" + key);
                            this.setCallDetailsServer(callid, null);
                            break;
                        }
                        cd.authstr = HTTP.getParameter(msg, "WWW-Authenticate");
                        String epass = this.getAuthResponse(cd, trunk.user, trunk.pass, cdpbx.host, cd.cmd, "Authorization:");
                        if (epass == null) {
                            JFLog.log("err:gen auth failed");
                            this.setCallDetailsServer(callid, null);
                            break;
                        }
                        ++cdsd.cseq;
                        cd.authsent = true;
                        this.issue(cd, epass, sdp, src);
                        break;
                    }
                    case 407: {
                        if (!cd.cmd.equals("INVITE")) break;
                        cd.cmd = "ACK";
                        this.issue(cd, null, false, src);
                        if (cd.authsent) {
                            JFLog.log("Server Error : Double 407");
                            this.setCallDetailsServer(callid, null);
                            break;
                        }
                        String reg = this.iface.getTrunkRegister(remoteip);
                        if (reg == null) {
                            JFLog.log("TRUNK : 407 : no register string for trunk");
                            this.setCallDetailsServer(callid, null);
                            break;
                        }
                        int idx1 = reg.indexOf(":");
                        int idx2 = reg.indexOf("@");
                        if (idx1 == -1 || idx2 == -1) {
                            JFLog.log("TRUNK : 407 : invalid register string for trunk");
                            this.setCallDetailsServer(callid, null);
                            break;
                        }
                        String trunk_user = reg.substring(0, idx1);
                        String trunk_pass = reg.substring(idx1 + 1, idx2);
                        cd.authstr = HTTP.getParameter(msg, "Proxy-Authenticate");
                        String epass = this.getAuthResponse(cd, trunk_user, trunk_pass, cdpbx.host, cd.cmd, "Proxy-Authorization:");
                        if (epass == null) {
                            JFLog.log("err:gen auth failed");
                            this.setCallDetailsServer(callid, null);
                            break;
                        }
                        ++cdsd.cseq;
                        cd.authsent = true;
                        this.issue(cd, epass, true, src);
                        break;
                    }
                    default: {
                        this.iface.onError(cd, reply, src);
                        if (reply != 487) break;
                        this.setCallDetailsServer(cd.callid, null);
                    }
                }
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public Set getCalls() {
        return this.cdlist.keySet();
    }

    private static class Trunk {
        public String user;
        public String auth;
        public String pass;

        private Trunk() {
        }
    }
}

