/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.admins.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.TeamPriorityLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Admin.Builder.class)
public final class Admin {
    private final Optional<String> type;

    private final String id;

    private final String name;

    private final String email;

    private final String jobTitle;

    private final boolean awayModeEnabled;

    private final boolean awayModeReassign;

    private final boolean hasInboxSeat;

    private final List<Integer> teamIds;

    private final Optional<Avatar> avatar;

    private final Optional<TeamPriorityLevel> teamPriorityLevel;

    private final Map<String, Object> additionalProperties;

    private Admin(
            Optional<String> type,
            String id,
            String name,
            String email,
            String jobTitle,
            boolean awayModeEnabled,
            boolean awayModeReassign,
            boolean hasInboxSeat,
            List<Integer> teamIds,
            Optional<Avatar> avatar,
            Optional<TeamPriorityLevel> teamPriorityLevel,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.name = name;
        this.email = email;
        this.jobTitle = jobTitle;
        this.awayModeEnabled = awayModeEnabled;
        this.awayModeReassign = awayModeReassign;
        this.hasInboxSeat = hasInboxSeat;
        this.teamIds = teamIds;
        this.avatar = avatar;
        this.teamPriorityLevel = teamPriorityLevel;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>admin</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The id representing the admin.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The name of the admin.
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The email of the admin.
     */
    @JsonProperty("email")
    public String getEmail() {
        return email;
    }

    /**
     * @return The job title of the admin.
     */
    @JsonProperty("job_title")
    public String getJobTitle() {
        return jobTitle;
    }

    /**
     * @return Identifies if this admin is currently set in away mode.
     */
    @JsonProperty("away_mode_enabled")
    public boolean getAwayModeEnabled() {
        return awayModeEnabled;
    }

    /**
     * @return Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.
     */
    @JsonProperty("away_mode_reassign")
    public boolean getAwayModeReassign() {
        return awayModeReassign;
    }

    /**
     * @return Identifies if this admin has a paid inbox seat to restrict/allow features that require them.
     */
    @JsonProperty("has_inbox_seat")
    public boolean getHasInboxSeat() {
        return hasInboxSeat;
    }

    /**
     * @return This object represents the avatar associated with the admin.
     */
    @JsonProperty("team_ids")
    public List<Integer> getTeamIds() {
        return teamIds;
    }

    /**
     * @return The avatar object associated with the admin
     */
    @JsonProperty("avatar")
    public Optional<Avatar> getAvatar() {
        return avatar;
    }

    @JsonProperty("team_priority_level")
    public Optional<TeamPriorityLevel> getTeamPriorityLevel() {
        return teamPriorityLevel;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Admin && equalTo((Admin) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Admin other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && name.equals(other.name)
                && email.equals(other.email)
                && jobTitle.equals(other.jobTitle)
                && awayModeEnabled == other.awayModeEnabled
                && awayModeReassign == other.awayModeReassign
                && hasInboxSeat == other.hasInboxSeat
                && teamIds.equals(other.teamIds)
                && avatar.equals(other.avatar)
                && teamPriorityLevel.equals(other.teamPriorityLevel);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.name,
                this.email,
                this.jobTitle,
                this.awayModeEnabled,
                this.awayModeReassign,
                this.hasInboxSeat,
                this.teamIds,
                this.avatar,
                this.teamPriorityLevel);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The id representing the admin.
         */
        NameStage id(@NotNull String id);

        Builder from(Admin other);
    }

    public interface NameStage {
        /**
         * The name of the admin.
         */
        EmailStage name(@NotNull String name);
    }

    public interface EmailStage {
        /**
         * The email of the admin.
         */
        JobTitleStage email(@NotNull String email);
    }

    public interface JobTitleStage {
        /**
         * The job title of the admin.
         */
        AwayModeEnabledStage jobTitle(@NotNull String jobTitle);
    }

    public interface AwayModeEnabledStage {
        /**
         * Identifies if this admin is currently set in away mode.
         */
        AwayModeReassignStage awayModeEnabled(boolean awayModeEnabled);
    }

    public interface AwayModeReassignStage {
        /**
         * Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.
         */
        HasInboxSeatStage awayModeReassign(boolean awayModeReassign);
    }

    public interface HasInboxSeatStage {
        /**
         * Identifies if this admin has a paid inbox seat to restrict/allow features that require them.
         */
        _FinalStage hasInboxSeat(boolean hasInboxSeat);
    }

    public interface _FinalStage {
        Admin build();

        /**
         * <p>String representing the object's type. Always has the value <code>admin</code>.</p>
         */
        _FinalStage type(Optional<String> type);

        _FinalStage type(String type);

        /**
         * <p>This object represents the avatar associated with the admin.</p>
         */
        _FinalStage teamIds(List<Integer> teamIds);

        _FinalStage addTeamIds(Integer teamIds);

        _FinalStage addAllTeamIds(List<Integer> teamIds);

        /**
         * <p>The avatar object associated with the admin</p>
         */
        _FinalStage avatar(Optional<Avatar> avatar);

        _FinalStage avatar(Avatar avatar);

        _FinalStage teamPriorityLevel(Optional<TeamPriorityLevel> teamPriorityLevel);

        _FinalStage teamPriorityLevel(TeamPriorityLevel teamPriorityLevel);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements IdStage,
                    NameStage,
                    EmailStage,
                    JobTitleStage,
                    AwayModeEnabledStage,
                    AwayModeReassignStage,
                    HasInboxSeatStage,
                    _FinalStage {
        private String id;

        private String name;

        private String email;

        private String jobTitle;

        private boolean awayModeEnabled;

        private boolean awayModeReassign;

        private boolean hasInboxSeat;

        private Optional<TeamPriorityLevel> teamPriorityLevel = Optional.empty();

        private Optional<Avatar> avatar = Optional.empty();

        private List<Integer> teamIds = new ArrayList<>();

        private Optional<String> type = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Admin other) {
            type(other.getType());
            id(other.getId());
            name(other.getName());
            email(other.getEmail());
            jobTitle(other.getJobTitle());
            awayModeEnabled(other.getAwayModeEnabled());
            awayModeReassign(other.getAwayModeReassign());
            hasInboxSeat(other.getHasInboxSeat());
            teamIds(other.getTeamIds());
            avatar(other.getAvatar());
            teamPriorityLevel(other.getTeamPriorityLevel());
            return this;
        }

        /**
         * The id representing the admin.<p>The id representing the admin.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The name of the admin.<p>The name of the admin.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public EmailStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * The email of the admin.<p>The email of the admin.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("email")
        public JobTitleStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        /**
         * The job title of the admin.<p>The job title of the admin.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("job_title")
        public AwayModeEnabledStage jobTitle(@NotNull String jobTitle) {
            this.jobTitle = Objects.requireNonNull(jobTitle, "jobTitle must not be null");
            return this;
        }

        /**
         * Identifies if this admin is currently set in away mode.<p>Identifies if this admin is currently set in away mode.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("away_mode_enabled")
        public AwayModeReassignStage awayModeEnabled(boolean awayModeEnabled) {
            this.awayModeEnabled = awayModeEnabled;
            return this;
        }

        /**
         * Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.<p>Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("away_mode_reassign")
        public HasInboxSeatStage awayModeReassign(boolean awayModeReassign) {
            this.awayModeReassign = awayModeReassign;
            return this;
        }

        /**
         * Identifies if this admin has a paid inbox seat to restrict/allow features that require them.<p>Identifies if this admin has a paid inbox seat to restrict/allow features that require them.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("has_inbox_seat")
        public _FinalStage hasInboxSeat(boolean hasInboxSeat) {
            this.hasInboxSeat = hasInboxSeat;
            return this;
        }

        @java.lang.Override
        public _FinalStage teamPriorityLevel(TeamPriorityLevel teamPriorityLevel) {
            this.teamPriorityLevel = Optional.ofNullable(teamPriorityLevel);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "team_priority_level", nulls = Nulls.SKIP)
        public _FinalStage teamPriorityLevel(Optional<TeamPriorityLevel> teamPriorityLevel) {
            this.teamPriorityLevel = teamPriorityLevel;
            return this;
        }

        /**
         * <p>The avatar object associated with the admin</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage avatar(Avatar avatar) {
            this.avatar = Optional.ofNullable(avatar);
            return this;
        }

        /**
         * <p>The avatar object associated with the admin</p>
         */
        @java.lang.Override
        @JsonSetter(value = "avatar", nulls = Nulls.SKIP)
        public _FinalStage avatar(Optional<Avatar> avatar) {
            this.avatar = avatar;
            return this;
        }

        /**
         * <p>This object represents the avatar associated with the admin.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllTeamIds(List<Integer> teamIds) {
            this.teamIds.addAll(teamIds);
            return this;
        }

        /**
         * <p>This object represents the avatar associated with the admin.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addTeamIds(Integer teamIds) {
            this.teamIds.add(teamIds);
            return this;
        }

        /**
         * <p>This object represents the avatar associated with the admin.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "team_ids", nulls = Nulls.SKIP)
        public _FinalStage teamIds(List<Integer> teamIds) {
            this.teamIds.clear();
            this.teamIds.addAll(teamIds);
            return this;
        }

        /**
         * <p>String representing the object's type. Always has the value <code>admin</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>String representing the object's type. Always has the value <code>admin</code>.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public _FinalStage type(Optional<String> type) {
            this.type = type;
            return this;
        }

        @java.lang.Override
        public Admin build() {
            return new Admin(
                    type,
                    id,
                    name,
                    email,
                    jobTitle,
                    awayModeEnabled,
                    awayModeReassign,
                    hasInboxSeat,
                    teamIds,
                    avatar,
                    teamPriorityLevel,
                    additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Avatar.Builder.class)
    public static final class Avatar {
        private final String imageUrl;

        private final Map<String, Object> additionalProperties;

        private Avatar(String imageUrl, Map<String, Object> additionalProperties) {
            this.imageUrl = imageUrl;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return URL of the admin's avatar image
         */
        @JsonProperty("image_url")
        public String getImageUrl() {
            return imageUrl;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Avatar && equalTo((Avatar) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Avatar other) {
            return imageUrl.equals(other.imageUrl);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.imageUrl);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static ImageUrlStage builder() {
            return new Builder();
        }

        public interface ImageUrlStage {
            /**
             * URL of the admin's avatar image
             */
            _FinalStage imageUrl(@NotNull String imageUrl);

            Builder from(Avatar other);
        }

        public interface _FinalStage {
            Avatar build();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements ImageUrlStage, _FinalStage {
            private String imageUrl;

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(Avatar other) {
                imageUrl(other.getImageUrl());
                return this;
            }

            /**
             * URL of the admin's avatar image<p>URL of the admin's avatar image</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("image_url")
            public _FinalStage imageUrl(@NotNull String imageUrl) {
                this.imageUrl = Objects.requireNonNull(imageUrl, "imageUrl must not be null");
                return this;
            }

            @java.lang.Override
            public Avatar build() {
                return new Avatar(imageUrl, additionalProperties);
            }
        }
    }
}
