/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.conversations.types.ConversationsManageRequestBody;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ManageConversationPartsRequest.Builder.class)
public final class ManageConversationPartsRequest {
    private final String conversationId;

    private final ConversationsManageRequestBody body;

    private final Map<String, Object> additionalProperties;

    private ManageConversationPartsRequest(
            String conversationId, ConversationsManageRequestBody body, Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The identifier for the conversation as given by Intercom.
     */
    @JsonProperty("conversation_id")
    public String getConversationId() {
        return conversationId;
    }

    @JsonProperty("body")
    public ConversationsManageRequestBody getBody() {
        return body;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ManageConversationPartsRequest && equalTo((ManageConversationPartsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ManageConversationPartsRequest other) {
        return conversationId.equals(other.conversationId) && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.conversationId, this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConversationIdStage builder() {
        return new Builder();
    }

    public interface ConversationIdStage {
        /**
         * The identifier for the conversation as given by Intercom.
         */
        BodyStage conversationId(@NotNull String conversationId);

        Builder from(ManageConversationPartsRequest other);
    }

    public interface BodyStage {
        _FinalStage body(@NotNull ConversationsManageRequestBody body);
    }

    public interface _FinalStage {
        ManageConversationPartsRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ConversationIdStage, BodyStage, _FinalStage {
        private String conversationId;

        private ConversationsManageRequestBody body;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ManageConversationPartsRequest other) {
            conversationId(other.getConversationId());
            body(other.getBody());
            return this;
        }

        /**
         * The identifier for the conversation as given by Intercom.<p>The identifier for the conversation as given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("conversation_id")
        public BodyStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull ConversationsManageRequestBody body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @java.lang.Override
        public ManageConversationPartsRequest build() {
            return new ManageConversationPartsRequest(conversationId, body, additionalProperties);
        }
    }
}
