/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateConversationRequest.Builder.class)
public final class UpdateConversationRequest {
    private final String conversationId;

    private final Optional<String> displayAs;

    private final Optional<Boolean> read;

    private final Optional<Map<String, Object>> customAttributes;

    private final Map<String, Object> additionalProperties;

    private UpdateConversationRequest(
            String conversationId,
            Optional<String> displayAs,
            Optional<Boolean> read,
            Optional<Map<String, Object>> customAttributes,
            Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.displayAs = displayAs;
        this.read = read;
        this.customAttributes = customAttributes;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The id of the conversation to target
     */
    @JsonProperty("conversation_id")
    public String getConversationId() {
        return conversationId;
    }

    /**
     * @return Set to plaintext to retrieve conversation messages in plain text.
     */
    @JsonProperty("display_as")
    public Optional<String> getDisplayAs() {
        return displayAs;
    }

    /**
     * @return Mark a conversation as read within Intercom.
     */
    @JsonProperty("read")
    public Optional<Boolean> getRead() {
        return read;
    }

    @JsonProperty("custom_attributes")
    public Optional<Map<String, Object>> getCustomAttributes() {
        return customAttributes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateConversationRequest && equalTo((UpdateConversationRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateConversationRequest other) {
        return conversationId.equals(other.conversationId)
                && displayAs.equals(other.displayAs)
                && read.equals(other.read)
                && customAttributes.equals(other.customAttributes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.conversationId, this.displayAs, this.read, this.customAttributes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConversationIdStage builder() {
        return new Builder();
    }

    public interface ConversationIdStage {
        /**
         * The id of the conversation to target
         */
        _FinalStage conversationId(@NotNull String conversationId);

        Builder from(UpdateConversationRequest other);
    }

    public interface _FinalStage {
        UpdateConversationRequest build();

        /**
         * <p>Set to plaintext to retrieve conversation messages in plain text.</p>
         */
        _FinalStage displayAs(Optional<String> displayAs);

        _FinalStage displayAs(String displayAs);

        /**
         * <p>Mark a conversation as read within Intercom.</p>
         */
        _FinalStage read(Optional<Boolean> read);

        _FinalStage read(Boolean read);

        _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes);

        _FinalStage customAttributes(Map<String, Object> customAttributes);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ConversationIdStage, _FinalStage {
        private String conversationId;

        private Optional<Map<String, Object>> customAttributes = Optional.empty();

        private Optional<Boolean> read = Optional.empty();

        private Optional<String> displayAs = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateConversationRequest other) {
            conversationId(other.getConversationId());
            displayAs(other.getDisplayAs());
            read(other.getRead());
            customAttributes(other.getCustomAttributes());
            return this;
        }

        /**
         * The id of the conversation to target<p>The id of the conversation to target</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("conversation_id")
        public _FinalStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage customAttributes(Map<String, Object> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "custom_attributes", nulls = Nulls.SKIP)
        public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        /**
         * <p>Mark a conversation as read within Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage read(Boolean read) {
            this.read = Optional.ofNullable(read);
            return this;
        }

        /**
         * <p>Mark a conversation as read within Intercom.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "read", nulls = Nulls.SKIP)
        public _FinalStage read(Optional<Boolean> read) {
            this.read = read;
            return this;
        }

        /**
         * <p>Set to plaintext to retrieve conversation messages in plain text.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage displayAs(String displayAs) {
            this.displayAs = Optional.ofNullable(displayAs);
            return this;
        }

        /**
         * <p>Set to plaintext to retrieve conversation messages in plain text.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "display_as", nulls = Nulls.SKIP)
        public _FinalStage displayAs(Optional<String> displayAs) {
            this.displayAs = displayAs;
            return this;
        }

        @java.lang.Override
        public UpdateConversationRequest build() {
            return new UpdateConversationRequest(
                    conversationId, displayAs, read, customAttributes, additionalProperties);
        }
    }
}
