/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.dataattributes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateDataAttributeRequest.Builder.class)
public final class CreateDataAttributeRequest {
    private final String name;

    private final Model model;

    private final DataType dataType;

    private final Optional<String> description;

    private final Optional<List<String>> options;

    private final Optional<Boolean> messengerWritable;

    private final Map<String, Object> additionalProperties;

    private CreateDataAttributeRequest(
            String name,
            Model model,
            DataType dataType,
            Optional<String> description,
            Optional<List<String>> options,
            Optional<Boolean> messengerWritable,
            Map<String, Object> additionalProperties) {
        this.name = name;
        this.model = model;
        this.dataType = dataType;
        this.description = description;
        this.options = options;
        this.messengerWritable = messengerWritable;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The name of the data attribute.
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The model that the data attribute belongs to.
     */
    @JsonProperty("model")
    public Model getModel() {
        return model;
    }

    /**
     * @return The type of data stored for this attribute.
     */
    @JsonProperty("data_type")
    public DataType getDataType() {
        return dataType;
    }

    /**
     * @return The readable description you see in the UI for the attribute.
     */
    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    /**
     * @return To create list attributes. Provide a set of hashes with <code>value</code> as the key of the options you want to make. <code>data_type</code> must be <code>string</code>.
     */
    @JsonProperty("options")
    public Optional<List<String>> getOptions() {
        return options;
    }

    /**
     * @return Can this attribute be updated by the Messenger
     */
    @JsonProperty("messenger_writable")
    public Optional<Boolean> getMessengerWritable() {
        return messengerWritable;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateDataAttributeRequest && equalTo((CreateDataAttributeRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateDataAttributeRequest other) {
        return name.equals(other.name)
                && model.equals(other.model)
                && dataType.equals(other.dataType)
                && description.equals(other.description)
                && options.equals(other.options)
                && messengerWritable.equals(other.messengerWritable);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.name, this.model, this.dataType, this.description, this.options, this.messengerWritable);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        /**
         * The name of the data attribute.
         */
        ModelStage name(@NotNull String name);

        Builder from(CreateDataAttributeRequest other);
    }

    public interface ModelStage {
        /**
         * The model that the data attribute belongs to.
         */
        DataTypeStage model(@NotNull Model model);
    }

    public interface DataTypeStage {
        /**
         * The type of data stored for this attribute.
         */
        _FinalStage dataType(@NotNull DataType dataType);
    }

    public interface _FinalStage {
        CreateDataAttributeRequest build();

        /**
         * <p>The readable description you see in the UI for the attribute.</p>
         */
        _FinalStage description(Optional<String> description);

        _FinalStage description(String description);

        /**
         * <p>To create list attributes. Provide a set of hashes with <code>value</code> as the key of the options you want to make. <code>data_type</code> must be <code>string</code>.</p>
         */
        _FinalStage options(Optional<List<String>> options);

        _FinalStage options(List<String> options);

        /**
         * <p>Can this attribute be updated by the Messenger</p>
         */
        _FinalStage messengerWritable(Optional<Boolean> messengerWritable);

        _FinalStage messengerWritable(Boolean messengerWritable);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NameStage, ModelStage, DataTypeStage, _FinalStage {
        private String name;

        private Model model;

        private DataType dataType;

        private Optional<Boolean> messengerWritable = Optional.empty();

        private Optional<List<String>> options = Optional.empty();

        private Optional<String> description = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateDataAttributeRequest other) {
            name(other.getName());
            model(other.getModel());
            dataType(other.getDataType());
            description(other.getDescription());
            options(other.getOptions());
            messengerWritable(other.getMessengerWritable());
            return this;
        }

        /**
         * The name of the data attribute.<p>The name of the data attribute.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public ModelStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * The model that the data attribute belongs to.<p>The model that the data attribute belongs to.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("model")
        public DataTypeStage model(@NotNull Model model) {
            this.model = Objects.requireNonNull(model, "model must not be null");
            return this;
        }

        /**
         * The type of data stored for this attribute.<p>The type of data stored for this attribute.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("data_type")
        public _FinalStage dataType(@NotNull DataType dataType) {
            this.dataType = Objects.requireNonNull(dataType, "dataType must not be null");
            return this;
        }

        /**
         * <p>Can this attribute be updated by the Messenger</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage messengerWritable(Boolean messengerWritable) {
            this.messengerWritable = Optional.ofNullable(messengerWritable);
            return this;
        }

        /**
         * <p>Can this attribute be updated by the Messenger</p>
         */
        @java.lang.Override
        @JsonSetter(value = "messenger_writable", nulls = Nulls.SKIP)
        public _FinalStage messengerWritable(Optional<Boolean> messengerWritable) {
            this.messengerWritable = messengerWritable;
            return this;
        }

        /**
         * <p>To create list attributes. Provide a set of hashes with <code>value</code> as the key of the options you want to make. <code>data_type</code> must be <code>string</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage options(List<String> options) {
            this.options = Optional.ofNullable(options);
            return this;
        }

        /**
         * <p>To create list attributes. Provide a set of hashes with <code>value</code> as the key of the options you want to make. <code>data_type</code> must be <code>string</code>.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "options", nulls = Nulls.SKIP)
        public _FinalStage options(Optional<List<String>> options) {
            this.options = options;
            return this;
        }

        /**
         * <p>The readable description you see in the UI for the attribute.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        /**
         * <p>The readable description you see in the UI for the attribute.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @java.lang.Override
        public CreateDataAttributeRequest build() {
            return new CreateDataAttributeRequest(
                    name, model, dataType, description, options, messengerWritable, additionalProperties);
        }
    }

    public static final class Model {
        public static final Model CONTACT = new Model(Value.CONTACT, "contact");

        public static final Model COMPANY = new Model(Value.COMPANY, "company");

        private final Value value;

        private final String string;

        Model(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Model && this.string.equals(((Model) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case CONTACT:
                    return visitor.visitContact();
                case COMPANY:
                    return visitor.visitCompany();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Model valueOf(String value) {
            switch (value) {
                case "contact":
                    return CONTACT;
                case "company":
                    return COMPANY;
                default:
                    return new Model(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            CONTACT,

            COMPANY,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitContact();

            T visitCompany();

            T visitUnknown(String unknownType);
        }
    }

    public static final class DataType {
        public static final DataType STRING = new DataType(Value.STRING, "string");

        public static final DataType FLOAT = new DataType(Value.FLOAT, "float");

        public static final DataType INTEGER = new DataType(Value.INTEGER, "integer");

        public static final DataType DATETIME = new DataType(Value.DATETIME, "datetime");

        public static final DataType BOOLEAN = new DataType(Value.BOOLEAN, "boolean");

        public static final DataType DATE = new DataType(Value.DATE, "date");

        private final Value value;

        private final String string;

        DataType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof DataType && this.string.equals(((DataType) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case STRING:
                    return visitor.visitString();
                case FLOAT:
                    return visitor.visitFloat();
                case INTEGER:
                    return visitor.visitInteger();
                case DATETIME:
                    return visitor.visitDatetime();
                case BOOLEAN:
                    return visitor.visitBoolean();
                case DATE:
                    return visitor.visitDate();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static DataType valueOf(String value) {
            switch (value) {
                case "string":
                    return STRING;
                case "float":
                    return FLOAT;
                case "integer":
                    return INTEGER;
                case "datetime":
                    return DATETIME;
                case "boolean":
                    return BOOLEAN;
                case "date":
                    return DATE;
                default:
                    return new DataType(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            STRING,

            INTEGER,

            FLOAT,

            BOOLEAN,

            DATETIME,

            DATE,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitString();

            T visitInteger();

            T visitFloat();

            T visitBoolean();

            T visitDatetime();

            T visitDate();

            T visitUnknown(String unknownType);
        }
    }
}
