/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.dataattributes.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DataAttribute.Builder.class)
public final class DataAttribute {
    private final Optional<Integer> id;

    private final Optional<Model> model;

    private final String name;

    private final String fullName;

    private final String label;

    private final String description;

    private final DataType dataType;

    private final Optional<List<String>> options;

    private final Optional<Boolean> apiWritable;

    private final Optional<Boolean> messengerWritable;

    private final Optional<Boolean> uiWritable;

    private final Optional<Boolean> custom;

    private final Optional<Boolean> archived;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<String> adminId;

    private final Map<String, Object> additionalProperties;

    private DataAttribute(
            Optional<Integer> id,
            Optional<Model> model,
            String name,
            String fullName,
            String label,
            String description,
            DataType dataType,
            Optional<List<String>> options,
            Optional<Boolean> apiWritable,
            Optional<Boolean> messengerWritable,
            Optional<Boolean> uiWritable,
            Optional<Boolean> custom,
            Optional<Boolean> archived,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<String> adminId,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.model = model;
        this.name = name;
        this.fullName = fullName;
        this.label = label;
        this.description = description;
        this.dataType = dataType;
        this.options = options;
        this.apiWritable = apiWritable;
        this.messengerWritable = messengerWritable;
        this.uiWritable = uiWritable;
        this.custom = custom;
        this.archived = archived;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.adminId = adminId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Value is <code>data_attribute</code>.
     */
    @JsonProperty("type")
    public String getType() {
        return "data_attribute";
    }

    /**
     * @return The unique identifier for the data attribute which is given by Intercom. Only available for custom attributes.
     */
    @JsonProperty("id")
    public Optional<Integer> getId() {
        return id;
    }

    /**
     * @return Value is <code>contact</code> for user/lead attributes and <code>company</code> for company attributes.
     */
    @JsonProperty("model")
    public Optional<Model> getModel() {
        return model;
    }

    /**
     * @return Name of the attribute.
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return Full name of the attribute. Should match the name unless it's a nested attribute. We can split full_name on <code>.</code> to access nested user object values.
     */
    @JsonProperty("full_name")
    public String getFullName() {
        return fullName;
    }

    /**
     * @return Readable name of the attribute (i.e. name you see in the UI)
     */
    @JsonProperty("label")
    public String getLabel() {
        return label;
    }

    /**
     * @return Readable description of the attribute.
     */
    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    /**
     * @return The data type of the attribute.
     */
    @JsonProperty("data_type")
    public DataType getDataType() {
        return dataType;
    }

    /**
     * @return List of predefined options for attribute value.
     */
    @JsonProperty("options")
    public Optional<List<String>> getOptions() {
        return options;
    }

    /**
     * @return Can this attribute be updated through API
     */
    @JsonProperty("api_writable")
    public Optional<Boolean> getApiWritable() {
        return apiWritable;
    }

    /**
     * @return Can this attribute be updated by the Messenger
     */
    @JsonProperty("messenger_writable")
    public Optional<Boolean> getMessengerWritable() {
        return messengerWritable;
    }

    /**
     * @return Can this attribute be updated in the UI
     */
    @JsonProperty("ui_writable")
    public Optional<Boolean> getUiWritable() {
        return uiWritable;
    }

    /**
     * @return Set to true if this is a CDA
     */
    @JsonProperty("custom")
    public Optional<Boolean> getCustom() {
        return custom;
    }

    /**
     * @return Is this attribute archived. (Only applicable to CDAs)
     */
    @JsonProperty("archived")
    public Optional<Boolean> getArchived() {
        return archived;
    }

    /**
     * @return The time the attribute was created as a UTC Unix timestamp
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time the attribute was last updated as a UTC Unix timestamp
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return Teammate who created the attribute. Only applicable to CDAs
     */
    @JsonProperty("admin_id")
    public Optional<String> getAdminId() {
        return adminId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DataAttribute && equalTo((DataAttribute) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataAttribute other) {
        return id.equals(other.id)
                && model.equals(other.model)
                && name.equals(other.name)
                && fullName.equals(other.fullName)
                && label.equals(other.label)
                && description.equals(other.description)
                && dataType.equals(other.dataType)
                && options.equals(other.options)
                && apiWritable.equals(other.apiWritable)
                && messengerWritable.equals(other.messengerWritable)
                && uiWritable.equals(other.uiWritable)
                && custom.equals(other.custom)
                && archived.equals(other.archived)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && adminId.equals(other.adminId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.model,
                this.name,
                this.fullName,
                this.label,
                this.description,
                this.dataType,
                this.options,
                this.apiWritable,
                this.messengerWritable,
                this.uiWritable,
                this.custom,
                this.archived,
                this.createdAt,
                this.updatedAt,
                this.adminId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        /**
         * Name of the attribute.
         */
        FullNameStage name(@NotNull String name);

        Builder from(DataAttribute other);
    }

    public interface FullNameStage {
        /**
         * Full name of the attribute. Should match the name unless it's a nested attribute. We can split full_name on `.` to access nested user object values.
         */
        LabelStage fullName(@NotNull String fullName);
    }

    public interface LabelStage {
        /**
         * Readable name of the attribute (i.e. name you see in the UI)
         */
        DescriptionStage label(@NotNull String label);
    }

    public interface DescriptionStage {
        /**
         * Readable description of the attribute.
         */
        DataTypeStage description(@NotNull String description);
    }

    public interface DataTypeStage {
        /**
         * The data type of the attribute.
         */
        _FinalStage dataType(@NotNull DataType dataType);
    }

    public interface _FinalStage {
        DataAttribute build();

        /**
         * <p>The unique identifier for the data attribute which is given by Intercom. Only available for custom attributes.</p>
         */
        _FinalStage id(Optional<Integer> id);

        _FinalStage id(Integer id);

        /**
         * <p>Value is <code>contact</code> for user/lead attributes and <code>company</code> for company attributes.</p>
         */
        _FinalStage model(Optional<Model> model);

        _FinalStage model(Model model);

        /**
         * <p>List of predefined options for attribute value.</p>
         */
        _FinalStage options(Optional<List<String>> options);

        _FinalStage options(List<String> options);

        /**
         * <p>Can this attribute be updated through API</p>
         */
        _FinalStage apiWritable(Optional<Boolean> apiWritable);

        _FinalStage apiWritable(Boolean apiWritable);

        /**
         * <p>Can this attribute be updated by the Messenger</p>
         */
        _FinalStage messengerWritable(Optional<Boolean> messengerWritable);

        _FinalStage messengerWritable(Boolean messengerWritable);

        /**
         * <p>Can this attribute be updated in the UI</p>
         */
        _FinalStage uiWritable(Optional<Boolean> uiWritable);

        _FinalStage uiWritable(Boolean uiWritable);

        /**
         * <p>Set to true if this is a CDA</p>
         */
        _FinalStage custom(Optional<Boolean> custom);

        _FinalStage custom(Boolean custom);

        /**
         * <p>Is this attribute archived. (Only applicable to CDAs)</p>
         */
        _FinalStage archived(Optional<Boolean> archived);

        _FinalStage archived(Boolean archived);

        /**
         * <p>The time the attribute was created as a UTC Unix timestamp</p>
         */
        _FinalStage createdAt(Optional<Integer> createdAt);

        _FinalStage createdAt(Integer createdAt);

        /**
         * <p>The time the attribute was last updated as a UTC Unix timestamp</p>
         */
        _FinalStage updatedAt(Optional<Integer> updatedAt);

        _FinalStage updatedAt(Integer updatedAt);

        /**
         * <p>Teammate who created the attribute. Only applicable to CDAs</p>
         */
        _FinalStage adminId(Optional<String> adminId);

        _FinalStage adminId(String adminId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements NameStage, FullNameStage, LabelStage, DescriptionStage, DataTypeStage, _FinalStage {
        private String name;

        private String fullName;

        private String label;

        private String description;

        private DataType dataType;

        private Optional<String> adminId = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Boolean> archived = Optional.empty();

        private Optional<Boolean> custom = Optional.empty();

        private Optional<Boolean> uiWritable = Optional.empty();

        private Optional<Boolean> messengerWritable = Optional.empty();

        private Optional<Boolean> apiWritable = Optional.empty();

        private Optional<List<String>> options = Optional.empty();

        private Optional<Model> model = Optional.empty();

        private Optional<Integer> id = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DataAttribute other) {
            id(other.getId());
            model(other.getModel());
            name(other.getName());
            fullName(other.getFullName());
            label(other.getLabel());
            description(other.getDescription());
            dataType(other.getDataType());
            options(other.getOptions());
            apiWritable(other.getApiWritable());
            messengerWritable(other.getMessengerWritable());
            uiWritable(other.getUiWritable());
            custom(other.getCustom());
            archived(other.getArchived());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            adminId(other.getAdminId());
            return this;
        }

        /**
         * Name of the attribute.<p>Name of the attribute.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public FullNameStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * Full name of the attribute. Should match the name unless it's a nested attribute. We can split full_name on `.` to access nested user object values.<p>Full name of the attribute. Should match the name unless it's a nested attribute. We can split full_name on <code>.</code> to access nested user object values.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("full_name")
        public LabelStage fullName(@NotNull String fullName) {
            this.fullName = Objects.requireNonNull(fullName, "fullName must not be null");
            return this;
        }

        /**
         * Readable name of the attribute (i.e. name you see in the UI)<p>Readable name of the attribute (i.e. name you see in the UI)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("label")
        public DescriptionStage label(@NotNull String label) {
            this.label = Objects.requireNonNull(label, "label must not be null");
            return this;
        }

        /**
         * Readable description of the attribute.<p>Readable description of the attribute.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("description")
        public DataTypeStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        /**
         * The data type of the attribute.<p>The data type of the attribute.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("data_type")
        public _FinalStage dataType(@NotNull DataType dataType) {
            this.dataType = Objects.requireNonNull(dataType, "dataType must not be null");
            return this;
        }

        /**
         * <p>Teammate who created the attribute. Only applicable to CDAs</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage adminId(String adminId) {
            this.adminId = Optional.ofNullable(adminId);
            return this;
        }

        /**
         * <p>Teammate who created the attribute. Only applicable to CDAs</p>
         */
        @java.lang.Override
        @JsonSetter(value = "admin_id", nulls = Nulls.SKIP)
        public _FinalStage adminId(Optional<String> adminId) {
            this.adminId = adminId;
            return this;
        }

        /**
         * <p>The time the attribute was last updated as a UTC Unix timestamp</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The time the attribute was last updated as a UTC Unix timestamp</p>
         */
        @java.lang.Override
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * <p>The time the attribute was created as a UTC Unix timestamp</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The time the attribute was created as a UTC Unix timestamp</p>
         */
        @java.lang.Override
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public _FinalStage createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>Is this attribute archived. (Only applicable to CDAs)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage archived(Boolean archived) {
            this.archived = Optional.ofNullable(archived);
            return this;
        }

        /**
         * <p>Is this attribute archived. (Only applicable to CDAs)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "archived", nulls = Nulls.SKIP)
        public _FinalStage archived(Optional<Boolean> archived) {
            this.archived = archived;
            return this;
        }

        /**
         * <p>Set to true if this is a CDA</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage custom(Boolean custom) {
            this.custom = Optional.ofNullable(custom);
            return this;
        }

        /**
         * <p>Set to true if this is a CDA</p>
         */
        @java.lang.Override
        @JsonSetter(value = "custom", nulls = Nulls.SKIP)
        public _FinalStage custom(Optional<Boolean> custom) {
            this.custom = custom;
            return this;
        }

        /**
         * <p>Can this attribute be updated in the UI</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage uiWritable(Boolean uiWritable) {
            this.uiWritable = Optional.ofNullable(uiWritable);
            return this;
        }

        /**
         * <p>Can this attribute be updated in the UI</p>
         */
        @java.lang.Override
        @JsonSetter(value = "ui_writable", nulls = Nulls.SKIP)
        public _FinalStage uiWritable(Optional<Boolean> uiWritable) {
            this.uiWritable = uiWritable;
            return this;
        }

        /**
         * <p>Can this attribute be updated by the Messenger</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage messengerWritable(Boolean messengerWritable) {
            this.messengerWritable = Optional.ofNullable(messengerWritable);
            return this;
        }

        /**
         * <p>Can this attribute be updated by the Messenger</p>
         */
        @java.lang.Override
        @JsonSetter(value = "messenger_writable", nulls = Nulls.SKIP)
        public _FinalStage messengerWritable(Optional<Boolean> messengerWritable) {
            this.messengerWritable = messengerWritable;
            return this;
        }

        /**
         * <p>Can this attribute be updated through API</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage apiWritable(Boolean apiWritable) {
            this.apiWritable = Optional.ofNullable(apiWritable);
            return this;
        }

        /**
         * <p>Can this attribute be updated through API</p>
         */
        @java.lang.Override
        @JsonSetter(value = "api_writable", nulls = Nulls.SKIP)
        public _FinalStage apiWritable(Optional<Boolean> apiWritable) {
            this.apiWritable = apiWritable;
            return this;
        }

        /**
         * <p>List of predefined options for attribute value.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage options(List<String> options) {
            this.options = Optional.ofNullable(options);
            return this;
        }

        /**
         * <p>List of predefined options for attribute value.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "options", nulls = Nulls.SKIP)
        public _FinalStage options(Optional<List<String>> options) {
            this.options = options;
            return this;
        }

        /**
         * <p>Value is <code>contact</code> for user/lead attributes and <code>company</code> for company attributes.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage model(Model model) {
            this.model = Optional.ofNullable(model);
            return this;
        }

        /**
         * <p>Value is <code>contact</code> for user/lead attributes and <code>company</code> for company attributes.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "model", nulls = Nulls.SKIP)
        public _FinalStage model(Optional<Model> model) {
            this.model = model;
            return this;
        }

        /**
         * <p>The unique identifier for the data attribute which is given by Intercom. Only available for custom attributes.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage id(Integer id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The unique identifier for the data attribute which is given by Intercom. Only available for custom attributes.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public _FinalStage id(Optional<Integer> id) {
            this.id = id;
            return this;
        }

        @java.lang.Override
        public DataAttribute build() {
            return new DataAttribute(
                    id,
                    model,
                    name,
                    fullName,
                    label,
                    description,
                    dataType,
                    options,
                    apiWritable,
                    messengerWritable,
                    uiWritable,
                    custom,
                    archived,
                    createdAt,
                    updatedAt,
                    adminId,
                    additionalProperties);
        }
    }

    public static final class Model {
        public static final Model CONTACT = new Model(Value.CONTACT, "contact");

        public static final Model COMPANY = new Model(Value.COMPANY, "company");

        private final Value value;

        private final String string;

        Model(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Model && this.string.equals(((Model) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case CONTACT:
                    return visitor.visitContact();
                case COMPANY:
                    return visitor.visitCompany();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Model valueOf(String value) {
            switch (value) {
                case "contact":
                    return CONTACT;
                case "company":
                    return COMPANY;
                default:
                    return new Model(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            CONTACT,

            COMPANY,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitContact();

            T visitCompany();

            T visitUnknown(String unknownType);
        }
    }

    public static final class DataType {
        public static final DataType STRING = new DataType(Value.STRING, "string");

        public static final DataType FLOAT = new DataType(Value.FLOAT, "float");

        public static final DataType INTEGER = new DataType(Value.INTEGER, "integer");

        public static final DataType BOOLEAN = new DataType(Value.BOOLEAN, "boolean");

        public static final DataType DATE = new DataType(Value.DATE, "date");

        private final Value value;

        private final String string;

        DataType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof DataType && this.string.equals(((DataType) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case STRING:
                    return visitor.visitString();
                case FLOAT:
                    return visitor.visitFloat();
                case INTEGER:
                    return visitor.visitInteger();
                case BOOLEAN:
                    return visitor.visitBoolean();
                case DATE:
                    return visitor.visitDate();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static DataType valueOf(String value) {
            switch (value) {
                case "string":
                    return STRING;
                case "float":
                    return FLOAT;
                case "integer":
                    return INTEGER;
                case "boolean":
                    return BOOLEAN;
                case "date":
                    return DATE;
                default:
                    return new DataType(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            STRING,

            INTEGER,

            FLOAT,

            BOOLEAN,

            DATE,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitString();

            T visitInteger();

            T visitFloat();

            T visitBoolean();

            T visitDate();

            T visitUnknown(String unknownType);
        }
    }
}
