/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.helpcenter.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.GroupTranslatedContent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Collection.Builder.class)
public final class Collection {
    private final String id;

    private final String workspaceId;

    private final String name;

    private final Optional<String> description;

    private final int createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<String> url;

    private final Optional<String> icon;

    private final int order;

    private final String defaultLocale;

    private final Optional<GroupTranslatedContent> translatedContent;

    private final Optional<String> parentId;

    private final Optional<Integer> helpCenterId;

    private final Map<String, Object> additionalProperties;

    private Collection(
            String id,
            String workspaceId,
            String name,
            Optional<String> description,
            int createdAt,
            Optional<Integer> updatedAt,
            Optional<String> url,
            Optional<String> icon,
            int order,
            String defaultLocale,
            Optional<GroupTranslatedContent> translatedContent,
            Optional<String> parentId,
            Optional<Integer> helpCenterId,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.workspaceId = workspaceId;
        this.name = name;
        this.description = description;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.url = url;
        this.icon = icon;
        this.order = order;
        this.defaultLocale = defaultLocale;
        this.translatedContent = translatedContent;
        this.parentId = parentId;
        this.helpCenterId = helpCenterId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the collection which is given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The id of the workspace which the collection belongs to.
     */
    @JsonProperty("workspace_id")
    public String getWorkspaceId() {
        return workspaceId;
    }

    /**
     * @return The name of the collection. For multilingual collections, this will be the name of the default language's content.
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The description of the collection. For multilingual help centers, this will be the description of the collection for the default language.
     */
    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    /**
     * @return The time when the article was created (seconds). For multilingual articles, this will be the timestamp of creation of the default language's content.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time when the article was last updated (seconds). For multilingual articles, this will be the timestamp of last update of the default language's content.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return The URL of the collection. For multilingual help centers, this will be the URL of the collection for the default language.
     */
    @JsonProperty("url")
    public Optional<String> getUrl() {
        return url;
    }

    /**
     * @return The icon of the collection.
     */
    @JsonProperty("icon")
    public Optional<String> getIcon() {
        return icon;
    }

    /**
     * @return The order of the section in relation to others sections within a collection. Values go from <code>0</code> upwards. <code>0</code> is the default if there's no order.
     */
    @JsonProperty("order")
    public int getOrder() {
        return order;
    }

    /**
     * @return The default locale of the help center. This field is only returned for multilingual help centers.
     */
    @JsonProperty("default_locale")
    public String getDefaultLocale() {
        return defaultLocale;
    }

    @JsonProperty("translated_content")
    public Optional<GroupTranslatedContent> getTranslatedContent() {
        return translatedContent;
    }

    /**
     * @return The id of the parent collection. If <code>null</code> then it is the first level collection.
     */
    @JsonProperty("parent_id")
    public Optional<String> getParentId() {
        return parentId;
    }

    /**
     * @return The id of the help center the collection is in.
     */
    @JsonProperty("help_center_id")
    public Optional<Integer> getHelpCenterId() {
        return helpCenterId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Collection && equalTo((Collection) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Collection other) {
        return id.equals(other.id)
                && workspaceId.equals(other.workspaceId)
                && name.equals(other.name)
                && description.equals(other.description)
                && createdAt == other.createdAt
                && updatedAt.equals(other.updatedAt)
                && url.equals(other.url)
                && icon.equals(other.icon)
                && order == other.order
                && defaultLocale.equals(other.defaultLocale)
                && translatedContent.equals(other.translatedContent)
                && parentId.equals(other.parentId)
                && helpCenterId.equals(other.helpCenterId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.workspaceId,
                this.name,
                this.description,
                this.createdAt,
                this.updatedAt,
                this.url,
                this.icon,
                this.order,
                this.defaultLocale,
                this.translatedContent,
                this.parentId,
                this.helpCenterId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The unique identifier for the collection which is given by Intercom.
         */
        WorkspaceIdStage id(@NotNull String id);

        Builder from(Collection other);
    }

    public interface WorkspaceIdStage {
        /**
         * The id of the workspace which the collection belongs to.
         */
        NameStage workspaceId(@NotNull String workspaceId);
    }

    public interface NameStage {
        /**
         * The name of the collection. For multilingual collections, this will be the name of the default language's content.
         */
        CreatedAtStage name(@NotNull String name);
    }

    public interface CreatedAtStage {
        /**
         * The time when the article was created (seconds). For multilingual articles, this will be the timestamp of creation of the default language's content.
         */
        OrderStage createdAt(int createdAt);
    }

    public interface OrderStage {
        /**
         * The order of the section in relation to others sections within a collection. Values go from `0` upwards. `0` is the default if there's no order.
         */
        DefaultLocaleStage order(int order);
    }

    public interface DefaultLocaleStage {
        /**
         * The default locale of the help center. This field is only returned for multilingual help centers.
         */
        _FinalStage defaultLocale(@NotNull String defaultLocale);
    }

    public interface _FinalStage {
        Collection build();

        /**
         * <p>The description of the collection. For multilingual help centers, this will be the description of the collection for the default language.</p>
         */
        _FinalStage description(Optional<String> description);

        _FinalStage description(String description);

        /**
         * <p>The time when the article was last updated (seconds). For multilingual articles, this will be the timestamp of last update of the default language's content.</p>
         */
        _FinalStage updatedAt(Optional<Integer> updatedAt);

        _FinalStage updatedAt(Integer updatedAt);

        /**
         * <p>The URL of the collection. For multilingual help centers, this will be the URL of the collection for the default language.</p>
         */
        _FinalStage url(Optional<String> url);

        _FinalStage url(String url);

        /**
         * <p>The icon of the collection.</p>
         */
        _FinalStage icon(Optional<String> icon);

        _FinalStage icon(String icon);

        _FinalStage translatedContent(Optional<GroupTranslatedContent> translatedContent);

        _FinalStage translatedContent(GroupTranslatedContent translatedContent);

        /**
         * <p>The id of the parent collection. If <code>null</code> then it is the first level collection.</p>
         */
        _FinalStage parentId(Optional<String> parentId);

        _FinalStage parentId(String parentId);

        /**
         * <p>The id of the help center the collection is in.</p>
         */
        _FinalStage helpCenterId(Optional<Integer> helpCenterId);

        _FinalStage helpCenterId(Integer helpCenterId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements IdStage,
                    WorkspaceIdStage,
                    NameStage,
                    CreatedAtStage,
                    OrderStage,
                    DefaultLocaleStage,
                    _FinalStage {
        private String id;

        private String workspaceId;

        private String name;

        private int createdAt;

        private int order;

        private String defaultLocale;

        private Optional<Integer> helpCenterId = Optional.empty();

        private Optional<String> parentId = Optional.empty();

        private Optional<GroupTranslatedContent> translatedContent = Optional.empty();

        private Optional<String> icon = Optional.empty();

        private Optional<String> url = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<String> description = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Collection other) {
            id(other.getId());
            workspaceId(other.getWorkspaceId());
            name(other.getName());
            description(other.getDescription());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            url(other.getUrl());
            icon(other.getIcon());
            order(other.getOrder());
            defaultLocale(other.getDefaultLocale());
            translatedContent(other.getTranslatedContent());
            parentId(other.getParentId());
            helpCenterId(other.getHelpCenterId());
            return this;
        }

        /**
         * The unique identifier for the collection which is given by Intercom.<p>The unique identifier for the collection which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public WorkspaceIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The id of the workspace which the collection belongs to.<p>The id of the workspace which the collection belongs to.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("workspace_id")
        public NameStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        /**
         * The name of the collection. For multilingual collections, this will be the name of the default language's content.<p>The name of the collection. For multilingual collections, this will be the name of the default language's content.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public CreatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * The time when the article was created (seconds). For multilingual articles, this will be the timestamp of creation of the default language's content.<p>The time when the article was created (seconds). For multilingual articles, this will be the timestamp of creation of the default language's content.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public OrderStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * The order of the section in relation to others sections within a collection. Values go from `0` upwards. `0` is the default if there's no order.<p>The order of the section in relation to others sections within a collection. Values go from <code>0</code> upwards. <code>0</code> is the default if there's no order.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("order")
        public DefaultLocaleStage order(int order) {
            this.order = order;
            return this;
        }

        /**
         * The default locale of the help center. This field is only returned for multilingual help centers.<p>The default locale of the help center. This field is only returned for multilingual help centers.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("default_locale")
        public _FinalStage defaultLocale(@NotNull String defaultLocale) {
            this.defaultLocale = Objects.requireNonNull(defaultLocale, "defaultLocale must not be null");
            return this;
        }

        /**
         * <p>The id of the help center the collection is in.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage helpCenterId(Integer helpCenterId) {
            this.helpCenterId = Optional.ofNullable(helpCenterId);
            return this;
        }

        /**
         * <p>The id of the help center the collection is in.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "help_center_id", nulls = Nulls.SKIP)
        public _FinalStage helpCenterId(Optional<Integer> helpCenterId) {
            this.helpCenterId = helpCenterId;
            return this;
        }

        /**
         * <p>The id of the parent collection. If <code>null</code> then it is the first level collection.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage parentId(String parentId) {
            this.parentId = Optional.ofNullable(parentId);
            return this;
        }

        /**
         * <p>The id of the parent collection. If <code>null</code> then it is the first level collection.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "parent_id", nulls = Nulls.SKIP)
        public _FinalStage parentId(Optional<String> parentId) {
            this.parentId = parentId;
            return this;
        }

        @java.lang.Override
        public _FinalStage translatedContent(GroupTranslatedContent translatedContent) {
            this.translatedContent = Optional.ofNullable(translatedContent);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "translated_content", nulls = Nulls.SKIP)
        public _FinalStage translatedContent(Optional<GroupTranslatedContent> translatedContent) {
            this.translatedContent = translatedContent;
            return this;
        }

        /**
         * <p>The icon of the collection.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        /**
         * <p>The icon of the collection.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "icon", nulls = Nulls.SKIP)
        public _FinalStage icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        /**
         * <p>The URL of the collection. For multilingual help centers, this will be the URL of the collection for the default language.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        /**
         * <p>The URL of the collection. For multilingual help centers, this will be the URL of the collection for the default language.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "url", nulls = Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        /**
         * <p>The time when the article was last updated (seconds). For multilingual articles, this will be the timestamp of last update of the default language's content.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The time when the article was last updated (seconds). For multilingual articles, this will be the timestamp of last update of the default language's content.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * <p>The description of the collection. For multilingual help centers, this will be the description of the collection for the default language.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        /**
         * <p>The description of the collection. For multilingual help centers, this will be the description of the collection for the default language.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @java.lang.Override
        public Collection build() {
            return new Collection(
                    id,
                    workspaceId,
                    name,
                    description,
                    createdAt,
                    updatedAt,
                    url,
                    icon,
                    order,
                    defaultLocale,
                    translatedContent,
                    parentId,
                    helpCenterId,
                    additionalProperties);
        }
    }
}
