/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.helpcenters;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.Suppliers;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.helpcenter.types.HelpCenter;
import com.intercom.api.resources.helpcenters.collections.AsyncCollectionsClient;
import com.intercom.api.resources.helpcenters.requests.FindHelpCenterRequest;
import com.intercom.api.resources.helpcenters.requests.ListHelpCentersRequest;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncHelpCentersClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawHelpCentersClient rawClient;

    protected final Supplier<AsyncCollectionsClient> collectionsClient;

    public AsyncHelpCentersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawHelpCentersClient(clientOptions);
        this.collectionsClient = Suppliers.memoize(() -> new AsyncCollectionsClient(clientOptions));
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawHelpCentersClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch the details of a single Help Center by making a GET request to <code>https://api.intercom.io/help_center/help_center/&lt;id&gt;</code>.
     */
    public CompletableFuture<HelpCenter> find(FindHelpCenterRequest request) {
        return this.rawClient.find(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single Help Center by making a GET request to <code>https://api.intercom.io/help_center/help_center/&lt;id&gt;</code>.
     */
    public CompletableFuture<HelpCenter> find(FindHelpCenterRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can list all Help Centers by making a GET request to <code>https://api.intercom.io/help_center/help_centers</code>.
     */
    public CompletableFuture<SyncPagingIterable<HelpCenter>> list() {
        return this.rawClient.list().thenApply(response -> response.body());
    }

    /**
     * You can list all Help Centers by making a GET request to <code>https://api.intercom.io/help_center/help_centers</code>.
     */
    public CompletableFuture<SyncPagingIterable<HelpCenter>> list(ListHelpCentersRequest request) {
        return this.rawClient.list(request).thenApply(response -> response.body());
    }

    /**
     * You can list all Help Centers by making a GET request to <code>https://api.intercom.io/help_center/help_centers</code>.
     */
    public CompletableFuture<SyncPagingIterable<HelpCenter>> list(
            ListHelpCentersRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> response.body());
    }

    public AsyncCollectionsClient collections() {
        return this.collectionsClient.get();
    }
}
