/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.messages;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.messages.types.Message;
import com.intercom.api.types.CreateMessageRequest;
import java.util.concurrent.CompletableFuture;

public class AsyncMessagesClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawMessagesClient rawClient;

    public AsyncMessagesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawMessagesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawMessagesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can create a message that has been initiated by an admin. The conversation can be either an in-app message or an email.
     * <blockquote>
     * <p>🚧 Sending for visitors</p>
     * <p>There can be a short delay between when a contact is created and when a contact becomes available to be messaged through the API. A 404 Not Found error will be returned in this case.</p>
     * </blockquote>
     * <p>This will return the Message model that has been created.</p>
     * <blockquote>
     * <p>🚧 Retrieving Associated Conversations</p>
     * <p>As this is a message, there will be no conversation present until the contact responds. Once they do, you will have to search for a contact's conversations with the id of the message.</p>
     * </blockquote>
     */
    public CompletableFuture<Message> create(CreateMessageRequest request) {
        return this.rawClient.create(request).thenApply(response -> response.body());
    }

    /**
     * You can create a message that has been initiated by an admin. The conversation can be either an in-app message or an email.
     * <blockquote>
     * <p>🚧 Sending for visitors</p>
     * <p>There can be a short delay between when a contact is created and when a contact becomes available to be messaged through the API. A 404 Not Found error will be returned in this case.</p>
     * </blockquote>
     * <p>This will return the Message model that has been created.</p>
     * <blockquote>
     * <p>🚧 Retrieving Associated Conversations</p>
     * <p>As this is a message, there will be no conversation present until the contact responds. Once they do, you will have to search for a contact's conversations with the id of the message.</p>
     * </blockquote>
     */
    public CompletableFuture<Message> create(CreateMessageRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> response.body());
    }
}
