/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.phonecallredirects.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreatePhoneCallRedirectRequest.Builder.class)
public final class CreatePhoneCallRedirectRequest {
    private final String phone;

    private final Optional<Map<String, Object>> customAttributes;

    private final Map<String, Object> additionalProperties;

    private CreatePhoneCallRedirectRequest(
            String phone, Optional<Map<String, Object>> customAttributes, Map<String, Object> additionalProperties) {
        this.phone = phone;
        this.customAttributes = customAttributes;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Phone number in E.164 format, that will receive the SMS to continue the conversation in the Messenger.
     */
    @JsonProperty("phone")
    public String getPhone() {
        return phone;
    }

    @JsonProperty("custom_attributes")
    public Optional<Map<String, Object>> getCustomAttributes() {
        return customAttributes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreatePhoneCallRedirectRequest && equalTo((CreatePhoneCallRedirectRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreatePhoneCallRedirectRequest other) {
        return phone.equals(other.phone) && customAttributes.equals(other.customAttributes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.phone, this.customAttributes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PhoneStage builder() {
        return new Builder();
    }

    public interface PhoneStage {
        /**
         * Phone number in E.164 format, that will receive the SMS to continue the conversation in the Messenger.
         */
        _FinalStage phone(@NotNull String phone);

        Builder from(CreatePhoneCallRedirectRequest other);
    }

    public interface _FinalStage {
        CreatePhoneCallRedirectRequest build();

        _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes);

        _FinalStage customAttributes(Map<String, Object> customAttributes);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PhoneStage, _FinalStage {
        private String phone;

        private Optional<Map<String, Object>> customAttributes = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreatePhoneCallRedirectRequest other) {
            phone(other.getPhone());
            customAttributes(other.getCustomAttributes());
            return this;
        }

        /**
         * Phone number in E.164 format, that will receive the SMS to continue the conversation in the Messenger.<p>Phone number in E.164 format, that will receive the SMS to continue the conversation in the Messenger.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("phone")
        public _FinalStage phone(@NotNull String phone) {
            this.phone = Objects.requireNonNull(phone, "phone must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage customAttributes(Map<String, Object> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "custom_attributes", nulls = Nulls.SKIP)
        public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        @java.lang.Override
        public CreatePhoneCallRedirectRequest build() {
            return new CreatePhoneCallRedirectRequest(phone, customAttributes, additionalProperties);
        }
    }
}
