/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tickettypes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = FindTicketTypeRequest.Builder.class)
public final class FindTicketTypeRequest {
    private final String ticketTypeId;

    private final Map<String, Object> additionalProperties;

    private FindTicketTypeRequest(String ticketTypeId, Map<String, Object> additionalProperties) {
        this.ticketTypeId = ticketTypeId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the ticket type which is given by Intercom.
     */
    @JsonProperty("ticket_type_id")
    public String getTicketTypeId() {
        return ticketTypeId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof FindTicketTypeRequest && equalTo((FindTicketTypeRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FindTicketTypeRequest other) {
        return ticketTypeId.equals(other.ticketTypeId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.ticketTypeId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TicketTypeIdStage builder() {
        return new Builder();
    }

    public interface TicketTypeIdStage {
        /**
         * The unique identifier for the ticket type which is given by Intercom.
         */
        _FinalStage ticketTypeId(@NotNull String ticketTypeId);

        Builder from(FindTicketTypeRequest other);
    }

    public interface _FinalStage {
        FindTicketTypeRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TicketTypeIdStage, _FinalStage {
        private String ticketTypeId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(FindTicketTypeRequest other) {
            ticketTypeId(other.getTicketTypeId());
            return this;
        }

        /**
         * The unique identifier for the ticket type which is given by Intercom.<p>The unique identifier for the ticket type which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("ticket_type_id")
        public _FinalStage ticketTypeId(@NotNull String ticketTypeId) {
            this.ticketTypeId = Objects.requireNonNull(ticketTypeId, "ticketTypeId must not be null");
            return this;
        }

        @java.lang.Override
        public FindTicketTypeRequest build() {
            return new FindTicketTypeRequest(ticketTypeId, additionalProperties);
        }
    }
}
