/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.aicontent.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateExternalPageRequest.Builder.class)
public final class UpdateExternalPageRequest {
    private final String id;

    private final String title;

    private final String html;

    private final String url;

    private final Optional<Boolean> finAvailability;

    private final int sourceId;

    private final Optional<String> externalId;

    private final Map<String, Object> additionalProperties;

    private UpdateExternalPageRequest(
            String id,
            String title,
            String html,
            String url,
            Optional<Boolean> finAvailability,
            int sourceId,
            Optional<String> externalId,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.title = title;
        this.html = html;
        this.url = url;
        this.finAvailability = finAvailability;
        this.sourceId = sourceId;
        this.externalId = externalId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the external page which is given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The title of the external page.
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * @return The body of the external page in HTML.
     */
    @JsonProperty("html")
    public String getHtml() {
        return html;
    }

    /**
     * @return The URL of the external page. This will be used by Fin to link end users to the page it based its answer on.
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    /**
     * @return Whether the external page should be used to answer questions by Fin.
     */
    @JsonProperty("fin_availability")
    public Optional<Boolean> getFinAvailability() {
        return finAvailability;
    }

    /**
     * @return Always en
     */
    @JsonProperty("locale")
    public String getLocale() {
        return "en";
    }

    /**
     * @return The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.
     */
    @JsonProperty("source_id")
    public int getSourceId() {
        return sourceId;
    }

    /**
     * @return The identifier for the external page which was given by the source. Must be unique for the source.
     */
    @JsonProperty("external_id")
    public Optional<String> getExternalId() {
        return externalId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateExternalPageRequest && equalTo((UpdateExternalPageRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateExternalPageRequest other) {
        return id.equals(other.id)
                && title.equals(other.title)
                && html.equals(other.html)
                && url.equals(other.url)
                && finAvailability.equals(other.finAvailability)
                && sourceId == other.sourceId
                && externalId.equals(other.externalId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id, this.title, this.html, this.url, this.finAvailability, this.sourceId, this.externalId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The unique identifier for the external page which is given by Intercom.
         */
        TitleStage id(@NotNull String id);

        Builder from(UpdateExternalPageRequest other);
    }

    public interface TitleStage {
        /**
         * The title of the external page.
         */
        HtmlStage title(@NotNull String title);
    }

    public interface HtmlStage {
        /**
         * The body of the external page in HTML.
         */
        UrlStage html(@NotNull String html);
    }

    public interface UrlStage {
        /**
         * The URL of the external page. This will be used by Fin to link end users to the page it based its answer on.
         */
        SourceIdStage url(@NotNull String url);
    }

    public interface SourceIdStage {
        /**
         * The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.
         */
        _FinalStage sourceId(int sourceId);
    }

    public interface _FinalStage {
        UpdateExternalPageRequest build();

        /**
         * <p>Whether the external page should be used to answer questions by Fin.</p>
         */
        _FinalStage finAvailability(Optional<Boolean> finAvailability);

        _FinalStage finAvailability(Boolean finAvailability);

        /**
         * <p>The identifier for the external page which was given by the source. Must be unique for the source.</p>
         */
        _FinalStage externalId(Optional<String> externalId);

        _FinalStage externalId(String externalId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, TitleStage, HtmlStage, UrlStage, SourceIdStage, _FinalStage {
        private String id;

        private String title;

        private String html;

        private String url;

        private int sourceId;

        private Optional<String> externalId = Optional.empty();

        private Optional<Boolean> finAvailability = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateExternalPageRequest other) {
            id(other.getId());
            title(other.getTitle());
            html(other.getHtml());
            url(other.getUrl());
            finAvailability(other.getFinAvailability());
            sourceId(other.getSourceId());
            externalId(other.getExternalId());
            return this;
        }

        /**
         * The unique identifier for the external page which is given by Intercom.<p>The unique identifier for the external page which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public TitleStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The title of the external page.<p>The title of the external page.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("title")
        public HtmlStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        /**
         * The body of the external page in HTML.<p>The body of the external page in HTML.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("html")
        public UrlStage html(@NotNull String html) {
            this.html = Objects.requireNonNull(html, "html must not be null");
            return this;
        }

        /**
         * The URL of the external page. This will be used by Fin to link end users to the page it based its answer on.<p>The URL of the external page. This will be used by Fin to link end users to the page it based its answer on.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("url")
        public SourceIdStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        /**
         * The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.<p>The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("source_id")
        public _FinalStage sourceId(int sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        /**
         * <p>The identifier for the external page which was given by the source. Must be unique for the source.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        /**
         * <p>The identifier for the external page which was given by the source. Must be unique for the source.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "external_id", nulls = Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        /**
         * <p>Whether the external page should be used to answer questions by Fin.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage finAvailability(Boolean finAvailability) {
            this.finAvailability = Optional.ofNullable(finAvailability);
            return this;
        }

        /**
         * <p>Whether the external page should be used to answer questions by Fin.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "fin_availability", nulls = Nulls.SKIP)
        public _FinalStage finAvailability(Optional<Boolean> finAvailability) {
            this.finAvailability = finAvailability;
            return this;
        }

        @java.lang.Override
        public UpdateExternalPageRequest build() {
            return new UpdateExternalPageRequest(
                    id, title, html, url, finAvailability, sourceId, externalId, additionalProperties);
        }
    }
}
