/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.contacts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = MergeContactsRequest.Builder.class)
public final class MergeContactsRequest {
    private final Optional<String> from;

    private final Optional<String> into;

    private final Map<String, Object> additionalProperties;

    private MergeContactsRequest(
            Optional<String> from, Optional<String> into, Map<String, Object> additionalProperties) {
        this.from = from;
        this.into = into;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the contact to merge away from. Must be a lead.
     */
    @JsonProperty("from")
    public Optional<String> getFrom() {
        return from;
    }

    /**
     * @return The unique identifier for the contact to merge into. Must be a user.
     */
    @JsonProperty("into")
    public Optional<String> getInto() {
        return into;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof MergeContactsRequest && equalTo((MergeContactsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MergeContactsRequest other) {
        return from.equals(other.from) && into.equals(other.into);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.from, this.into);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> from = Optional.empty();

        private Optional<String> into = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(MergeContactsRequest other) {
            from(other.getFrom());
            into(other.getInto());
            return this;
        }

        /**
         * <p>The unique identifier for the contact to merge away from. Must be a lead.</p>
         */
        @JsonSetter(value = "from", nulls = Nulls.SKIP)
        public Builder from(Optional<String> from) {
            this.from = from;
            return this;
        }

        public Builder from(String from) {
            this.from = Optional.ofNullable(from);
            return this;
        }

        /**
         * <p>The unique identifier for the contact to merge into. Must be a user.</p>
         */
        @JsonSetter(value = "into", nulls = Nulls.SKIP)
        public Builder into(Optional<String> into) {
            this.into = into;
            return this;
        }

        public Builder into(String into) {
            this.into = Optional.ofNullable(into);
            return this;
        }

        public MergeContactsRequest build() {
            return new MergeContactsRequest(from, into, additionalProperties);
        }
    }
}
