/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.conversations;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.MediaTypes;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.QueryStringMapper;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.conversations.requests.AttachContactToConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.ConvertConversationToTicketRequest;
import com.intercom.api.resources.unstable.conversations.requests.CreateConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.DeleteConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.DetachContactFromConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.ListConversationsRequest;
import com.intercom.api.resources.unstable.conversations.requests.ManageConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.ReplyConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.RetrieveConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.UpdateConversationRequest;
import com.intercom.api.resources.unstable.conversations.types.Conversation;
import com.intercom.api.resources.unstable.errors.BadRequestError;
import com.intercom.api.resources.unstable.errors.ForbiddenError;
import com.intercom.api.resources.unstable.errors.NotFoundError;
import com.intercom.api.resources.unstable.errors.UnauthorizedError;
import com.intercom.api.resources.unstable.errors.UnprocessableEntityError;
import com.intercom.api.resources.unstable.messages.types.Message;
import com.intercom.api.resources.unstable.tickets.types.Ticket;
import com.intercom.api.resources.unstable.types.ConversationDeleted;
import com.intercom.api.resources.unstable.types.ConversationList;
import com.intercom.api.resources.unstable.types.Error;
import com.intercom.api.resources.unstable.types.RedactConversationRequest;
import com.intercom.api.resources.unstable.types.SearchRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawConversationsClient {
    protected final ClientOptions clientOptions;

    public RawConversationsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    /**
     * You can fetch a list of all conversations.
     * <p>You can optionally request the result page size and the cursor to start after to fetch the result.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>20</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<ConversationList> listConversations() {
        return listConversations(ListConversationsRequest.builder().build());
    }

    /**
     * You can fetch a list of all conversations.
     * <p>You can optionally request the result page size and the cursor to start after to fetch the result.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>20</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<ConversationList> listConversations(ListConversationsRequest request) {
        return listConversations(request, null);
    }

    /**
     * You can fetch a list of all conversations.
     * <p>You can optionally request the result page size and the cursor to start after to fetch the result.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>20</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<ConversationList> listConversations(
            ListConversationsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations");
        if (request.getPerPage().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "per_page", request.getPerPage().get().toString(), false);
        }
        if (request.getStartingAfter().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "starting_after", request.getStartingAfter().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ConversationList.class), response);
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 403:
                        throw new ForbiddenError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new IntercomApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can create a conversation that has been initiated by a contact (ie. user or lead).
     * The conversation can be an in-app message only.
     * <p>{% admonition type=&quot;info&quot; name=&quot;Sending for visitors&quot; %}
     * You can also send a message from a visitor by specifying their <code>user_id</code> or <code>id</code> value in the <code>from</code> field, along with a <code>type</code> field value of <code>contact</code>.
     * This visitor will be automatically converted to a contact with a lead role once the conversation is created.
     * {% /admonition %}</p>
     * <p>This will return the Message model that has been created.</p>
     */
    public IntercomHttpResponse<Message> createConversation(CreateConversationRequest request) {
        return createConversation(request, null);
    }

    /**
     * You can create a conversation that has been initiated by a contact (ie. user or lead).
     * The conversation can be an in-app message only.
     * <p>{% admonition type=&quot;info&quot; name=&quot;Sending for visitors&quot; %}
     * You can also send a message from a visitor by specifying their <code>user_id</code> or <code>id</code> value in the <code>from</code> field, along with a <code>type</code> field value of <code>contact</code>.
     * This visitor will be automatically converted to a contact with a lead role once the conversation is created.
     * {% /admonition %}</p>
     * <p>This will return the Message model that has been created.</p>
     */
    public IntercomHttpResponse<Message> createConversation(
            CreateConversationRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Message.class), response);
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 403:
                        throw new ForbiddenError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new IntercomApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can fetch the details of a single conversation.
     * <p>This will return a single Conversation model with all its conversation parts.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Hard limit of 500 parts&quot; %}
     * The maximum number of conversation parts that can be returned via the API is 500. If you have more than that we will return the 500 most recent conversation parts.
     * {% /admonition %}</p>
     * <p>For AI agent conversation metadata, please note that you need to have the agent enabled in your workspace, which is a <a href="https://www.intercom.com/help/en/articles/8205718-fin-resolutions#h_97f8c2e671">paid feature</a>.</p>
     */
    public IntercomHttpResponse<Conversation> retrieveConversation(RetrieveConversationRequest request) {
        return retrieveConversation(request, null);
    }

    /**
     * You can fetch the details of a single conversation.
     * <p>This will return a single Conversation model with all its conversation parts.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Hard limit of 500 parts&quot; %}
     * The maximum number of conversation parts that can be returned via the API is 500. If you have more than that we will return the 500 most recent conversation parts.
     * {% /admonition %}</p>
     * <p>For AI agent conversation metadata, please note that you need to have the agent enabled in your workspace, which is a <a href="https://www.intercom.com/help/en/articles/8205718-fin-resolutions#h_97f8c2e671">paid feature</a>.</p>
     */
    public IntercomHttpResponse<Conversation> retrieveConversation(
            RetrieveConversationRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(Integer.toString(request.getId()));
        if (request.getDisplayAs().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "display_as", request.getDisplayAs().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("GET", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Conversation.class), response);
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 403:
                        throw new ForbiddenError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new IntercomApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can update an existing conversation.
     * <p>{% admonition type=&quot;info&quot; name=&quot;Replying and other actions&quot; %}
     * If you want to reply to a coveration or take an action such as assign, unassign, open, close or snooze, take a look at the reply and manage endpoints.
     * {% /admonition %}</p>
     * <p>{% admonition type=&quot;info&quot; %}
     * This endpoint handles both <strong>conversation updates</strong> and <strong>custom object associations</strong>.</p>
     * <p>See <em><code>update a conversation with an association to a custom object instance</code></em> in the request/response examples to see the custom object association format.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<Conversation> updateConversation(UpdateConversationRequest request) {
        return updateConversation(request, null);
    }

    /**
     * You can update an existing conversation.
     * <p>{% admonition type=&quot;info&quot; name=&quot;Replying and other actions&quot; %}
     * If you want to reply to a coveration or take an action such as assign, unassign, open, close or snooze, take a look at the reply and manage endpoints.
     * {% /admonition %}</p>
     * <p>{% admonition type=&quot;info&quot; %}
     * This endpoint handles both <strong>conversation updates</strong> and <strong>custom object associations</strong>.</p>
     * <p>See <em><code>update a conversation with an association to a custom object instance</code></em> in the request/response examples to see the custom object association format.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<Conversation> updateConversation(
            UpdateConversationRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(Integer.toString(request.getId()));
        if (request.getDisplayAs().isPresent()) {
            QueryStringMapper.addQueryParameter(
                    httpUrl, "display_as", request.getDisplayAs().get(), false);
        }
        Map<String, Object> properties = new HashMap<>();
        if (request.getRead().isPresent()) {
            properties.put("read", request.getRead());
        }
        if (request.getTitle().isPresent()) {
            properties.put("title", request.getTitle());
        }
        if (request.getCustomAttributes().isPresent()) {
            properties.put("custom_attributes", request.getCustomAttributes());
        }
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(properties), MediaTypes.APPLICATION_JSON);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl.build())
                .method("PUT", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Conversation.class), response);
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 403:
                        throw new ForbiddenError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new IntercomApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can delete a single conversation.
     */
    public IntercomHttpResponse<ConversationDeleted> deleteConversation(DeleteConversationRequest request) {
        return deleteConversation(request, null);
    }

    /**
     * You can delete a single conversation.
     */
    public IntercomHttpResponse<ConversationDeleted> deleteConversation(
            DeleteConversationRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(Integer.toString(request.getId()))
                .build();
        Request.Builder _requestBuilder = new Request.Builder()
                .url(httpUrl)
                .method("DELETE", null)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ConversationDeleted.class),
                        response);
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 403:
                        throw new ForbiddenError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new IntercomApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can search for multiple conversations by the value of their attributes in order to fetch exactly which ones you want.
     * <p>To search for conversations, you need to send a <code>POST</code> request to <code>https://api.intercom.io/conversations/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters in order to search for conversations.
     * {% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>20</code> results per page and maximum is <code>150</code>.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiple's there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Accepted Fields</h3>
     * <p>Most keys listed in the conversation model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foorbar&quot;</code>).
     * The <code>source.body</code> field is unique as the search will not be performed against the entire value, but instead against every element of the value separately. For example, when searching for a conversation with a <code>&quot;I need support&quot;</code> body - the query should contain a <code>=</code> operator with the value <code>&quot;support&quot;</code> for such conversation to be returned. A query with a <code>=</code> operator and a <code>&quot;need support&quot;</code> value will not yield a result.</p>
     * <p>| Field                                     | Type                                                                                                                                                   |
     * | :---------------------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------- |
     * | id                                        | String                                                                                                                                                 |
     * | created_at                                | Date (UNIX timestamp)                                                                                                                                  |
     * | updated_at                                | Date (UNIX timestamp)                                                                                                                                  |
     * | source.type                               | String&lt;br&gt;Accepted fields are <code>conversation</code>, <code>email</code>, <code>facebook</code>, <code>instagram</code>, <code>phone_call</code>, <code>phone_switch</code>, <code>push</code>, <code>sms</code>, <code>twitter</code> and <code>whatsapp</code>. |
     * | source.id                                 | String                                                                                                                                                 |
     * | source.delivered_as                       | String                                                                                                                                                 |
     * | source.subject                            | String                                                                                                                                                 |
     * | source.body                               | String                                                                                                                                                 |
     * | source.author.id                          | String                                                                                                                                                 |
     * | source.author.type                        | String                                                                                                                                                 |
     * | source.author.name                        | String                                                                                                                                                 |
     * | source.author.email                       | String                                                                                                                                                 |
     * | source.url                                | String                                                                                                                                                 |
     * | contact_ids                               | String                                                                                                                                                 |
     * | teammate_ids                              | String                                                                                                                                                 |
     * | admin_assignee_id                         | String                                                                                                                                                 |
     * | team_assignee_id                          | String                                                                                                                                                 |
     * | channel_initiated                         | String                                                                                                                                                 |
     * | open                                      | Boolean                                                                                                                                                |
     * | read                                      | Boolean                                                                                                                                                |
     * | state                                     | String                                                                                                                                                 |
     * | waiting_since                             | Date (UNIX timestamp)                                                                                                                                  |
     * | snoozed_until                             | Date (UNIX timestamp)                                                                                                                                  |
     * | tag_ids                                   | String                                                                                                                                                 |
     * | priority                                  | String                                                                                                                                                 |
     * | statistics.time_to_assignment             | Integer                                                                                                                                                |
     * | statistics.time_to_admin_reply            | Integer                                                                                                                                                |
     * | statistics.time_to_first_close            | Integer                                                                                                                                                |
     * | statistics.time_to_last_close             | Integer                                                                                                                                                |
     * | statistics.median_time_to_reply           | Integer                                                                                                                                                |
     * | statistics.first_contact_reply_at         | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.first_assignment_at            | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.first_admin_reply_at           | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.first_close_at                 | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_assignment_at             | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_assignment_admin_reply_at | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_contact_reply_at          | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_admin_reply_at            | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_close_at                  | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_closed_by_id              | String                                                                                                                                                 |
     * | statistics.count_reopens                  | Integer                                                                                                                                                |
     * | statistics.count_assignments              | Integer                                                                                                                                                |
     * | statistics.count_conversation_parts       | Integer                                                                                                                                                |
     * | conversation_rating.requested_at          | Date (UNIX timestamp)                                                                                                                                  |
     * | conversation_rating.replied_at            | Date (UNIX timestamp)                                                                                                                                  |
     * | conversation_rating.score                 | Integer                                                                                                                                                |
     * | conversation_rating.remark                | String                                                                                                                                                 |
     * | conversation_rating.contact_id            | String                                                                                                                                                 |
     * | conversation_rating.admin_d               | String                                                                                                                                                 |
     * | ai_agent_participated                     | Boolean                                                                                                                                                |
     * | ai_agent.resolution_state                 | String                                                                                                                                                 |
     * | ai_agent.last_answer_type                 | String                                                                                                                                                 |
     * | ai_agent.rating                           | Integer                                                                                                                                                |
     * | ai_agent.rating_remark                    | String                                                                                                                                                 |
     * | ai_agent.source_type                      | String                                                                                                                                                 |
     * | ai_agent.source_title                     | String                                                                                                                                                 |</p>
     * <h3>Accepted Operators</h3>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type  (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                    | Description                                                  |
     * | :------- | :----------------------------- | :----------------------------------------------------------- |
     * | =        | All                            | Equals                                                       |
     * | !=       | All                            | Doesn't Equal                                                |
     * | IN       | All                            | In  Shortcut for <code>OR</code> queries  Values most be in Array       |
     * | NIN      | All                            | Not In  Shortcut for <code>OR !</code> queries  Values must be in Array |
     * | &gt;        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
     * | &lt;       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
     * | ~        | String                         | Contains                                                     |
     * | !~       | String                         | Doesn't Contain                                              |
     * | ^        | String                         | Starts With                                                  |
     * | $        | String                         | Ends With                                                    |</p>
     */
    public IntercomHttpResponse<ConversationList> searchConversations(SearchRequest request) {
        return searchConversations(request, null);
    }

    /**
     * You can search for multiple conversations by the value of their attributes in order to fetch exactly which ones you want.
     * <p>To search for conversations, you need to send a <code>POST</code> request to <code>https://api.intercom.io/conversations/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters in order to search for conversations.
     * {% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>20</code> results per page and maximum is <code>150</code>.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiple's there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Accepted Fields</h3>
     * <p>Most keys listed in the conversation model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foorbar&quot;</code>).
     * The <code>source.body</code> field is unique as the search will not be performed against the entire value, but instead against every element of the value separately. For example, when searching for a conversation with a <code>&quot;I need support&quot;</code> body - the query should contain a <code>=</code> operator with the value <code>&quot;support&quot;</code> for such conversation to be returned. A query with a <code>=</code> operator and a <code>&quot;need support&quot;</code> value will not yield a result.</p>
     * <p>| Field                                     | Type                                                                                                                                                   |
     * | :---------------------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------- |
     * | id                                        | String                                                                                                                                                 |
     * | created_at                                | Date (UNIX timestamp)                                                                                                                                  |
     * | updated_at                                | Date (UNIX timestamp)                                                                                                                                  |
     * | source.type                               | String&lt;br&gt;Accepted fields are <code>conversation</code>, <code>email</code>, <code>facebook</code>, <code>instagram</code>, <code>phone_call</code>, <code>phone_switch</code>, <code>push</code>, <code>sms</code>, <code>twitter</code> and <code>whatsapp</code>. |
     * | source.id                                 | String                                                                                                                                                 |
     * | source.delivered_as                       | String                                                                                                                                                 |
     * | source.subject                            | String                                                                                                                                                 |
     * | source.body                               | String                                                                                                                                                 |
     * | source.author.id                          | String                                                                                                                                                 |
     * | source.author.type                        | String                                                                                                                                                 |
     * | source.author.name                        | String                                                                                                                                                 |
     * | source.author.email                       | String                                                                                                                                                 |
     * | source.url                                | String                                                                                                                                                 |
     * | contact_ids                               | String                                                                                                                                                 |
     * | teammate_ids                              | String                                                                                                                                                 |
     * | admin_assignee_id                         | String                                                                                                                                                 |
     * | team_assignee_id                          | String                                                                                                                                                 |
     * | channel_initiated                         | String                                                                                                                                                 |
     * | open                                      | Boolean                                                                                                                                                |
     * | read                                      | Boolean                                                                                                                                                |
     * | state                                     | String                                                                                                                                                 |
     * | waiting_since                             | Date (UNIX timestamp)                                                                                                                                  |
     * | snoozed_until                             | Date (UNIX timestamp)                                                                                                                                  |
     * | tag_ids                                   | String                                                                                                                                                 |
     * | priority                                  | String                                                                                                                                                 |
     * | statistics.time_to_assignment             | Integer                                                                                                                                                |
     * | statistics.time_to_admin_reply            | Integer                                                                                                                                                |
     * | statistics.time_to_first_close            | Integer                                                                                                                                                |
     * | statistics.time_to_last_close             | Integer                                                                                                                                                |
     * | statistics.median_time_to_reply           | Integer                                                                                                                                                |
     * | statistics.first_contact_reply_at         | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.first_assignment_at            | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.first_admin_reply_at           | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.first_close_at                 | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_assignment_at             | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_assignment_admin_reply_at | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_contact_reply_at          | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_admin_reply_at            | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_close_at                  | Date (UNIX timestamp)                                                                                                                                  |
     * | statistics.last_closed_by_id              | String                                                                                                                                                 |
     * | statistics.count_reopens                  | Integer                                                                                                                                                |
     * | statistics.count_assignments              | Integer                                                                                                                                                |
     * | statistics.count_conversation_parts       | Integer                                                                                                                                                |
     * | conversation_rating.requested_at          | Date (UNIX timestamp)                                                                                                                                  |
     * | conversation_rating.replied_at            | Date (UNIX timestamp)                                                                                                                                  |
     * | conversation_rating.score                 | Integer                                                                                                                                                |
     * | conversation_rating.remark                | String                                                                                                                                                 |
     * | conversation_rating.contact_id            | String                                                                                                                                                 |
     * | conversation_rating.admin_d               | String                                                                                                                                                 |
     * | ai_agent_participated                     | Boolean                                                                                                                                                |
     * | ai_agent.resolution_state                 | String                                                                                                                                                 |
     * | ai_agent.last_answer_type                 | String                                                                                                                                                 |
     * | ai_agent.rating                           | Integer                                                                                                                                                |
     * | ai_agent.rating_remark                    | String                                                                                                                                                 |
     * | ai_agent.source_type                      | String                                                                                                                                                 |
     * | ai_agent.source_title                     | String                                                                                                                                                 |</p>
     * <h3>Accepted Operators</h3>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type  (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                    | Description                                                  |
     * | :------- | :----------------------------- | :----------------------------------------------------------- |
     * | =        | All                            | Equals                                                       |
     * | !=       | All                            | Doesn't Equal                                                |
     * | IN       | All                            | In  Shortcut for <code>OR</code> queries  Values most be in Array       |
     * | NIN      | All                            | Not In  Shortcut for <code>OR !</code> queries  Values must be in Array |
     * | &gt;        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
     * | &lt;       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
     * | ~        | String                         | Contains                                                     |
     * | !~       | String                         | Doesn't Contain                                              |
     * | ^        | String                         | Starts With                                                  |
     * | $        | String                         | Ends With                                                    |</p>
     */
    public IntercomHttpResponse<ConversationList> searchConversations(
            SearchRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations/search")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ConversationList.class), response);
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new IntercomApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can reply to a conversation with a message from an admin or on behalf of a contact, or with a note for admins.
     */
    public IntercomHttpResponse<Conversation> replyConversation(ReplyConversationRequest request) {
        return replyConversation(request, null);
    }

    /**
     * You can reply to a conversation with a message from an admin or on behalf of a contact, or with a note for admins.
     */
    public IntercomHttpResponse<Conversation> replyConversation(
            ReplyConversationRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(request.getId())
                .addPathSegments("reply")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Conversation.class), response);
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 403:
                        throw new ForbiddenError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new IntercomApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * For managing conversations you can:
     * <ul>
     * <li>Close a conversation</li>
     * <li>Snooze a conversation to reopen on a future date</li>
     * <li>Open a conversation which is <code>snoozed</code> or <code>closed</code></li>
     * <li>Assign a conversation to an admin and/or team.</li>
     * </ul>
     */
    public IntercomHttpResponse<Conversation> manageConversation(ManageConversationRequest request) {
        return manageConversation(request, null);
    }

    /**
     * For managing conversations you can:
     * <ul>
     * <li>Close a conversation</li>
     * <li>Snooze a conversation to reopen on a future date</li>
     * <li>Open a conversation which is <code>snoozed</code> or <code>closed</code></li>
     * <li>Assign a conversation to an admin and/or team.</li>
     * </ul>
     */
    public IntercomHttpResponse<Conversation> manageConversation(
            ManageConversationRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(request.getId())
                .addPathSegments("parts")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request.getBody()), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Conversation.class), response);
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 403:
                        throw new ForbiddenError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new IntercomApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can add participants who are contacts to a conversation, on behalf of either another contact or an admin.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Contacts without an email&quot; %}
     * If you add a contact via the email parameter and there is no user/lead found on that workspace with he given email, then we will create a new contact with <code>role</code> set to <code>lead</code>.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<Conversation> attachContactToConversation(AttachContactToConversationRequest request) {
        return attachContactToConversation(request, null);
    }

    /**
     * You can add participants who are contacts to a conversation, on behalf of either another contact or an admin.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Contacts without an email&quot; %}
     * If you add a contact via the email parameter and there is no user/lead found on that workspace with he given email, then we will create a new contact with <code>role</code> set to <code>lead</code>.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<Conversation> attachContactToConversation(
            AttachContactToConversationRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(request.getId())
                .addPathSegments("customers")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Conversation.class), response);
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 403:
                        throw new ForbiddenError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new IntercomApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can add participants who are contacts to a conversation, on behalf of either another contact or an admin.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Contacts without an email&quot; %}
     * If you add a contact via the email parameter and there is no user/lead found on that workspace with he given email, then we will create a new contact with <code>role</code> set to <code>lead</code>.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<Conversation> detachContactFromConversation(
            DetachContactFromConversationRequest request) {
        return detachContactFromConversation(request, null);
    }

    /**
     * You can add participants who are contacts to a conversation, on behalf of either another contact or an admin.
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Contacts without an email&quot; %}
     * If you add a contact via the email parameter and there is no user/lead found on that workspace with he given email, then we will create a new contact with <code>role</code> set to <code>lead</code>.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<Conversation> detachContactFromConversation(
            DetachContactFromConversationRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(request.getConversationId())
                .addPathSegments("customers")
                .addPathSegment(request.getContactId())
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("DELETE", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Conversation.class), response);
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 403:
                        throw new ForbiddenError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                    case 422:
                        throw new UnprocessableEntityError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new IntercomApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can redact a conversation part or the source message of a conversation (as seen in the source object).
     * <p>{% admonition type=&quot;info&quot; name=&quot;Redacting parts and messages&quot; %}
     * If you are redacting a conversation part, it must have a <code>body</code>. If you are redacting a source message, it must have been created by a contact. We will return a <code>conversation_part_not_redactable</code> error if these criteria are not met.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<Conversation> redactConversation(RedactConversationRequest request) {
        return redactConversation(request, null);
    }

    /**
     * You can redact a conversation part or the source message of a conversation (as seen in the source object).
     * <p>{% admonition type=&quot;info&quot; name=&quot;Redacting parts and messages&quot; %}
     * If you are redacting a conversation part, it must have a <code>body</code>. If you are redacting a source message, it must have been created by a contact. We will return a <code>conversation_part_not_redactable</code> error if these criteria are not met.
     * {% /admonition %}</p>
     */
    public IntercomHttpResponse<Conversation> redactConversation(
            RedactConversationRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations/redact")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), Conversation.class), response);
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                switch (response.code()) {
                    case 401:
                        throw new UnauthorizedError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response);
                    case 404:
                        throw new NotFoundError(
                                ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new IntercomApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }

    /**
     * You can convert a conversation to a ticket.
     */
    public IntercomHttpResponse<Optional<Ticket>> convertConversationToTicket(
            ConvertConversationToTicketRequest request) {
        return convertConversationToTicket(request, null);
    }

    /**
     * You can convert a conversation to a ticket.
     */
    public IntercomHttpResponse<Optional<Ticket>> convertConversationToTicket(
            ConvertConversationToTicketRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse(this.clientOptions.environment().getUrl())
                .newBuilder()
                .addPathSegments("conversations")
                .addPathSegment(Integer.toString(request.getId()))
                .addPathSegments("convert")
                .build();
        RequestBody body;
        try {
            body = RequestBody.create(
                    ObjectMappers.JSON_MAPPER.writeValueAsBytes(request), MediaTypes.APPLICATION_JSON);
        } catch (JsonProcessingException e) {
            throw new IntercomException("Failed to serialize request", e);
        }
        Request okhttpRequest = new Request.Builder()
                .url(httpUrl)
                .method("POST", body)
                .headers(Headers.of(clientOptions.headers(requestOptions)))
                .addHeader("Content-Type", "application/json")
                .addHeader("Accept", "application/json")
                .build();
        OkHttpClient client = clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute()) {
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                return new IntercomHttpResponse<>(
                        ObjectMappers.JSON_MAPPER.readValue(
                                responseBody.string(), new TypeReference<Optional<Ticket>>() {}),
                        response);
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            try {
                if (response.code() == 400) {
                    throw new BadRequestError(
                            ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
                }
            } catch (JsonProcessingException ignored) {
                // unable to map error response, throwing generic error
            }
            throw new IntercomApiException(
                    "Error with status code " + response.code(),
                    response.code(),
                    ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class),
                    response);
        } catch (IOException e) {
            throw new IntercomException("Network error executing HTTP request", e);
        }
    }
}
