/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.dataattributes.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DataAttribute.Builder.class)
public final class DataAttribute {
    private final Optional<String> type;

    private final Optional<Integer> id;

    private final Optional<Model> model;

    private final Optional<String> name;

    private final Optional<String> fullName;

    private final Optional<String> label;

    private final Optional<String> description;

    private final Optional<DataType> dataType;

    private final Optional<List<String>> options;

    private final Optional<Boolean> apiWritable;

    private final Optional<Boolean> messengerWritable;

    private final Optional<Boolean> uiWritable;

    private final Optional<Boolean> custom;

    private final Optional<Boolean> archived;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<String> adminId;

    private final Map<String, Object> additionalProperties;

    private DataAttribute(
            Optional<String> type,
            Optional<Integer> id,
            Optional<Model> model,
            Optional<String> name,
            Optional<String> fullName,
            Optional<String> label,
            Optional<String> description,
            Optional<DataType> dataType,
            Optional<List<String>> options,
            Optional<Boolean> apiWritable,
            Optional<Boolean> messengerWritable,
            Optional<Boolean> uiWritable,
            Optional<Boolean> custom,
            Optional<Boolean> archived,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<String> adminId,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.model = model;
        this.name = name;
        this.fullName = fullName;
        this.label = label;
        this.description = description;
        this.dataType = dataType;
        this.options = options;
        this.apiWritable = apiWritable;
        this.messengerWritable = messengerWritable;
        this.uiWritable = uiWritable;
        this.custom = custom;
        this.archived = archived;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.adminId = adminId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Value is <code>data_attribute</code>.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The unique identifier for the data attribute which is given by Intercom. Only available for custom attributes.
     */
    @JsonProperty("id")
    public Optional<Integer> getId() {
        return id;
    }

    /**
     * @return Value is <code>contact</code> for user/lead attributes and <code>company</code> for company attributes.
     */
    @JsonProperty("model")
    public Optional<Model> getModel() {
        return model;
    }

    /**
     * @return Name of the attribute.
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return Full name of the attribute. Should match the name unless it's a nested attribute. We can split full_name on <code>.</code> to access nested user object values.
     */
    @JsonProperty("full_name")
    public Optional<String> getFullName() {
        return fullName;
    }

    /**
     * @return Readable name of the attribute (i.e. name you see in the UI)
     */
    @JsonProperty("label")
    public Optional<String> getLabel() {
        return label;
    }

    /**
     * @return Readable description of the attribute.
     */
    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    /**
     * @return The data type of the attribute.
     */
    @JsonProperty("data_type")
    public Optional<DataType> getDataType() {
        return dataType;
    }

    /**
     * @return List of predefined options for attribute value.
     */
    @JsonProperty("options")
    public Optional<List<String>> getOptions() {
        return options;
    }

    /**
     * @return Can this attribute be updated through API
     */
    @JsonProperty("api_writable")
    public Optional<Boolean> getApiWritable() {
        return apiWritable;
    }

    /**
     * @return Can this attribute be updated by the Messenger
     */
    @JsonProperty("messenger_writable")
    public Optional<Boolean> getMessengerWritable() {
        return messengerWritable;
    }

    /**
     * @return Can this attribute be updated in the UI
     */
    @JsonProperty("ui_writable")
    public Optional<Boolean> getUiWritable() {
        return uiWritable;
    }

    /**
     * @return Set to true if this is a CDA
     */
    @JsonProperty("custom")
    public Optional<Boolean> getCustom() {
        return custom;
    }

    /**
     * @return Is this attribute archived. (Only applicable to CDAs)
     */
    @JsonProperty("archived")
    public Optional<Boolean> getArchived() {
        return archived;
    }

    /**
     * @return The time the attribute was created as a UTC Unix timestamp
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time the attribute was last updated as a UTC Unix timestamp
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return Teammate who created the attribute. Only applicable to CDAs
     */
    @JsonProperty("admin_id")
    public Optional<String> getAdminId() {
        return adminId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DataAttribute && equalTo((DataAttribute) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataAttribute other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && model.equals(other.model)
                && name.equals(other.name)
                && fullName.equals(other.fullName)
                && label.equals(other.label)
                && description.equals(other.description)
                && dataType.equals(other.dataType)
                && options.equals(other.options)
                && apiWritable.equals(other.apiWritable)
                && messengerWritable.equals(other.messengerWritable)
                && uiWritable.equals(other.uiWritable)
                && custom.equals(other.custom)
                && archived.equals(other.archived)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && adminId.equals(other.adminId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.model,
                this.name,
                this.fullName,
                this.label,
                this.description,
                this.dataType,
                this.options,
                this.apiWritable,
                this.messengerWritable,
                this.uiWritable,
                this.custom,
                this.archived,
                this.createdAt,
                this.updatedAt,
                this.adminId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<Integer> id = Optional.empty();

        private Optional<Model> model = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> fullName = Optional.empty();

        private Optional<String> label = Optional.empty();

        private Optional<String> description = Optional.empty();

        private Optional<DataType> dataType = Optional.empty();

        private Optional<List<String>> options = Optional.empty();

        private Optional<Boolean> apiWritable = Optional.empty();

        private Optional<Boolean> messengerWritable = Optional.empty();

        private Optional<Boolean> uiWritable = Optional.empty();

        private Optional<Boolean> custom = Optional.empty();

        private Optional<Boolean> archived = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<String> adminId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(DataAttribute other) {
            type(other.getType());
            id(other.getId());
            model(other.getModel());
            name(other.getName());
            fullName(other.getFullName());
            label(other.getLabel());
            description(other.getDescription());
            dataType(other.getDataType());
            options(other.getOptions());
            apiWritable(other.getApiWritable());
            messengerWritable(other.getMessengerWritable());
            uiWritable(other.getUiWritable());
            custom(other.getCustom());
            archived(other.getArchived());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            adminId(other.getAdminId());
            return this;
        }

        /**
         * <p>Value is <code>data_attribute</code>.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The unique identifier for the data attribute which is given by Intercom. Only available for custom attributes.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<Integer> id) {
            this.id = id;
            return this;
        }

        public Builder id(Integer id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>Value is <code>contact</code> for user/lead attributes and <code>company</code> for company attributes.</p>
         */
        @JsonSetter(value = "model", nulls = Nulls.SKIP)
        public Builder model(Optional<Model> model) {
            this.model = model;
            return this;
        }

        public Builder model(Model model) {
            this.model = Optional.ofNullable(model);
            return this;
        }

        /**
         * <p>Name of the attribute.</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>Full name of the attribute. Should match the name unless it's a nested attribute. We can split full_name on <code>.</code> to access nested user object values.</p>
         */
        @JsonSetter(value = "full_name", nulls = Nulls.SKIP)
        public Builder fullName(Optional<String> fullName) {
            this.fullName = fullName;
            return this;
        }

        public Builder fullName(String fullName) {
            this.fullName = Optional.ofNullable(fullName);
            return this;
        }

        /**
         * <p>Readable name of the attribute (i.e. name you see in the UI)</p>
         */
        @JsonSetter(value = "label", nulls = Nulls.SKIP)
        public Builder label(Optional<String> label) {
            this.label = label;
            return this;
        }

        public Builder label(String label) {
            this.label = Optional.ofNullable(label);
            return this;
        }

        /**
         * <p>Readable description of the attribute.</p>
         */
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        /**
         * <p>The data type of the attribute.</p>
         */
        @JsonSetter(value = "data_type", nulls = Nulls.SKIP)
        public Builder dataType(Optional<DataType> dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder dataType(DataType dataType) {
            this.dataType = Optional.ofNullable(dataType);
            return this;
        }

        /**
         * <p>List of predefined options for attribute value.</p>
         */
        @JsonSetter(value = "options", nulls = Nulls.SKIP)
        public Builder options(Optional<List<String>> options) {
            this.options = options;
            return this;
        }

        public Builder options(List<String> options) {
            this.options = Optional.ofNullable(options);
            return this;
        }

        /**
         * <p>Can this attribute be updated through API</p>
         */
        @JsonSetter(value = "api_writable", nulls = Nulls.SKIP)
        public Builder apiWritable(Optional<Boolean> apiWritable) {
            this.apiWritable = apiWritable;
            return this;
        }

        public Builder apiWritable(Boolean apiWritable) {
            this.apiWritable = Optional.ofNullable(apiWritable);
            return this;
        }

        /**
         * <p>Can this attribute be updated by the Messenger</p>
         */
        @JsonSetter(value = "messenger_writable", nulls = Nulls.SKIP)
        public Builder messengerWritable(Optional<Boolean> messengerWritable) {
            this.messengerWritable = messengerWritable;
            return this;
        }

        public Builder messengerWritable(Boolean messengerWritable) {
            this.messengerWritable = Optional.ofNullable(messengerWritable);
            return this;
        }

        /**
         * <p>Can this attribute be updated in the UI</p>
         */
        @JsonSetter(value = "ui_writable", nulls = Nulls.SKIP)
        public Builder uiWritable(Optional<Boolean> uiWritable) {
            this.uiWritable = uiWritable;
            return this;
        }

        public Builder uiWritable(Boolean uiWritable) {
            this.uiWritable = Optional.ofNullable(uiWritable);
            return this;
        }

        /**
         * <p>Set to true if this is a CDA</p>
         */
        @JsonSetter(value = "custom", nulls = Nulls.SKIP)
        public Builder custom(Optional<Boolean> custom) {
            this.custom = custom;
            return this;
        }

        public Builder custom(Boolean custom) {
            this.custom = Optional.ofNullable(custom);
            return this;
        }

        /**
         * <p>Is this attribute archived. (Only applicable to CDAs)</p>
         */
        @JsonSetter(value = "archived", nulls = Nulls.SKIP)
        public Builder archived(Optional<Boolean> archived) {
            this.archived = archived;
            return this;
        }

        public Builder archived(Boolean archived) {
            this.archived = Optional.ofNullable(archived);
            return this;
        }

        /**
         * <p>The time the attribute was created as a UTC Unix timestamp</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The time the attribute was last updated as a UTC Unix timestamp</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>Teammate who created the attribute. Only applicable to CDAs</p>
         */
        @JsonSetter(value = "admin_id", nulls = Nulls.SKIP)
        public Builder adminId(Optional<String> adminId) {
            this.adminId = adminId;
            return this;
        }

        public Builder adminId(String adminId) {
            this.adminId = Optional.ofNullable(adminId);
            return this;
        }

        public DataAttribute build() {
            return new DataAttribute(
                    type,
                    id,
                    model,
                    name,
                    fullName,
                    label,
                    description,
                    dataType,
                    options,
                    apiWritable,
                    messengerWritable,
                    uiWritable,
                    custom,
                    archived,
                    createdAt,
                    updatedAt,
                    adminId,
                    additionalProperties);
        }
    }

    public static final class DataType {
        public static final DataType STRING = new DataType(Value.STRING, "string");

        public static final DataType FLOAT = new DataType(Value.FLOAT, "float");

        public static final DataType INTEGER = new DataType(Value.INTEGER, "integer");

        public static final DataType BOOLEAN = new DataType(Value.BOOLEAN, "boolean");

        public static final DataType DATE = new DataType(Value.DATE, "date");

        private final Value value;

        private final String string;

        DataType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof DataType && this.string.equals(((DataType) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case STRING:
                    return visitor.visitString();
                case FLOAT:
                    return visitor.visitFloat();
                case INTEGER:
                    return visitor.visitInteger();
                case BOOLEAN:
                    return visitor.visitBoolean();
                case DATE:
                    return visitor.visitDate();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static DataType valueOf(String value) {
            switch (value) {
                case "string":
                    return STRING;
                case "float":
                    return FLOAT;
                case "integer":
                    return INTEGER;
                case "boolean":
                    return BOOLEAN;
                case "date":
                    return DATE;
                default:
                    return new DataType(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            STRING,

            INTEGER,

            FLOAT,

            BOOLEAN,

            DATE,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitString();

            T visitInteger();

            T visitFloat();

            T visitBoolean();

            T visitDate();

            T visitUnknown(String unknownType);
        }
    }

    public static final class Model {
        public static final Model CONTACT = new Model(Value.CONTACT, "contact");

        public static final Model COMPANY = new Model(Value.COMPANY, "company");

        private final Value value;

        private final String string;

        Model(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Model && this.string.equals(((Model) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case CONTACT:
                    return visitor.visitContact();
                case COMPANY:
                    return visitor.visitCompany();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Model valueOf(String value) {
            switch (value) {
                case "contact":
                    return CONTACT;
                case "company":
                    return COMPANY;
                default:
                    return new Model(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            CONTACT,

            COMPANY,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitContact();

            T visitCompany();

            T visitUnknown(String unknownType);
        }
    }
}
