/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.dataevents;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.dataevents.requests.CreateDataEventSummariesRequest;
import com.intercom.api.resources.unstable.dataevents.requests.LisDataEventsRequest;
import com.intercom.api.resources.unstable.types.DataEventSummary;
import java.util.concurrent.CompletableFuture;

public class AsyncDataEventsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawDataEventsClient rawClient;

    public AsyncDataEventsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDataEventsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawDataEventsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * <blockquote>
     * 🚧
     * <p>Please note that you can only 'list' events that are less than 90 days old. Event counts and summaries will still include your events older than 90 days but you cannot 'list' these events individually if they are older than 90 days</p>
     * </blockquote>
     * <p>The events belonging to a customer can be listed by sending a GET request to <code>https://api.intercom.io/events</code> with a user or lead identifier along with a <code>type</code> parameter. The identifier parameter can be one of <code>user_id</code>, <code>email</code> or <code>intercom_user_id</code>. The <code>type</code> parameter value must be <code>user</code>.</p>
     * <ul>
     * <li><code>https://api.intercom.io/events?type=user&amp;user_id={user_id}</code></li>
     * <li><code>https://api.intercom.io/events?type=user&amp;email={email}</code></li>
     * <li><code>https://api.intercom.io/events?type=user&amp;intercom_user_id={id}</code> (this call can be used to list leads)</li>
     * </ul>
     * <p>The <code>email</code> parameter value should be <a href="http://en.wikipedia.org/wiki/Percent-encoding">url encoded</a> when sending.</p>
     * <p>You can optionally define the result page size as well with the <code>per_page</code> parameter.</p>
     */
    public CompletableFuture<DataEventSummary> lisDataEvents(LisDataEventsRequest request) {
        return this.rawClient.lisDataEvents(request).thenApply(response -> response.body());
    }

    /**
     * <blockquote>
     * 🚧
     * <p>Please note that you can only 'list' events that are less than 90 days old. Event counts and summaries will still include your events older than 90 days but you cannot 'list' these events individually if they are older than 90 days</p>
     * </blockquote>
     * <p>The events belonging to a customer can be listed by sending a GET request to <code>https://api.intercom.io/events</code> with a user or lead identifier along with a <code>type</code> parameter. The identifier parameter can be one of <code>user_id</code>, <code>email</code> or <code>intercom_user_id</code>. The <code>type</code> parameter value must be <code>user</code>.</p>
     * <ul>
     * <li><code>https://api.intercom.io/events?type=user&amp;user_id={user_id}</code></li>
     * <li><code>https://api.intercom.io/events?type=user&amp;email={email}</code></li>
     * <li><code>https://api.intercom.io/events?type=user&amp;intercom_user_id={id}</code> (this call can be used to list leads)</li>
     * </ul>
     * <p>The <code>email</code> parameter value should be <a href="http://en.wikipedia.org/wiki/Percent-encoding">url encoded</a> when sending.</p>
     * <p>You can optionally define the result page size as well with the <code>per_page</code> parameter.</p>
     */
    public CompletableFuture<DataEventSummary> lisDataEvents(
            LisDataEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.lisDataEvents(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You will need an Access Token that has write permissions to send Events. Once you have a key you can submit events via POST to the Events resource, which is located at https://api.intercom.io/events, or you can send events using one of the client libraries. When working with the HTTP API directly a client should send the event with a <code>Content-Type</code> of <code>application/json</code>.
     * <p>When using the JavaScript API, <a href="http://docs.intercom.io/configuring-Intercom/tracking-user-events-in-your-app">adding the code to your app</a> makes the Events API available. Once added, you can submit an event using the <code>trackEvent</code> method. This will associate the event with the Lead or currently logged-in user or logged-out visitor/lead and send it to Intercom. The final parameter is a map that can be used to send optional metadata about the event.</p>
     * <p>With the Ruby client you pass a hash describing the event to <code>Intercom::Event.create</code>, or call the <code>track_user</code> method directly on the current user object (e.g. <code>user.track_event</code>).</p>
     * <p><strong>NB: For the JSON object types, please note that we do not currently support nested JSON structure.</strong></p>
     * <p>| Type            | Description                                                                                                                                                                                                     | Example                                                                           |
     * | :-------------- | :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :-------------------------------------------------------------------------------- |
     * | String          | The value is a JSON String                                                                                                                                                                                      | <code>&quot;source&quot;:&quot;desktop&quot;</code>                                                              |
     * | Number          | The value is a JSON Number                                                                                                                                                                                      | <code>&quot;load&quot;: 3.67</code>                                                                    |
     * | Date            | The key ends with the String <code>_date</code> and the value is a <a href="http://en.wikipedia.org/wiki/Unix_time">Unix timestamp</a>, assumed to be in the <a href="http://en.wikipedia.org/wiki/Coordinated_Universal_Time">UTC</a> timezone. | <code>&quot;contact_date&quot;: 1392036272</code>                                                      |
     * | Link            | The value is a HTTP or HTTPS URI.                                                                                                                                                                               | <code>&quot;article&quot;: &quot;https://example.org/ab1de.html&quot;</code>                                     |
     * | Rich Link       | The value is a JSON object that contains <code>url</code> and <code>value</code> keys.                                                                                                                                                | <code>&quot;article&quot;: {&quot;url&quot;: &quot;https://example.org/ab1de.html&quot;, &quot;value&quot;:&quot;the dude abides&quot;}</code> |
     * | Monetary Amount | The value is a JSON object that contains <code>amount</code> and <code>currency</code> keys. The <code>amount</code> key is a positive integer representing the amount in cents. The price in the example to the right denotes €349.99.          | <code>&quot;price&quot;: {&quot;amount&quot;: 34999, &quot;currency&quot;: &quot;eur&quot;}</code>                                   |</p>
     * <p><strong>Lead Events</strong></p>
     * <p>When submitting events for Leads, you will need to specify the Lead's <code>id</code>.</p>
     * <p><strong>Metadata behaviour</strong></p>
     * <ul>
     * <li>We currently limit the number of tracked metadata keys to 10 per event. Once the quota is reached, we ignore any further keys we receive. The first 10 metadata keys are determined by the order in which they are sent in with the event.</li>
     * <li>It is not possible to change the metadata keys once the event has been sent. A new event will need to be created with the new keys and you can archive the old one.</li>
     * <li>There might be up to 24 hrs delay when you send a new metadata for an existing event.</li>
     * </ul>
     * <p><strong>Event de-duplication</strong></p>
     * <p>The API may detect and ignore duplicate events. Each event is uniquely identified as a combination of the following data - the Workspace identifier, the Contact external identifier, the Data Event name and the Data Event created time. As a result, it is <strong>strongly recommended</strong> to send a second granularity Unix timestamp in the <code>created_at</code> field.</p>
     * <p>Duplicated events are responded to using the normal <code>202 Accepted</code> code - an error is not thrown, however repeat requests will be counted against any rate limit that is in place.</p>
     * <h3>HTTP API Responses</h3>
     * <ul>
     * <li>Successful responses to submitted events return <code>202 Accepted</code> with an empty body.</li>
     * <li>Unauthorised access will be rejected with a <code>401 Unauthorized</code> or <code>403 Forbidden</code> response code.</li>
     * <li>Events sent about users that cannot be found will return a <code>404 Not Found</code>.</li>
     * <li>Event lists containing duplicate events will have those duplicates ignored.</li>
     * <li>Server errors will return a <code>500</code> response code and may contain an error message in the body.</li>
     * </ul>
     */
    public CompletableFuture<Void> createDataEvent(Object request) {
        return this.rawClient.createDataEvent(request).thenApply(response -> response.body());
    }

    /**
     * You will need an Access Token that has write permissions to send Events. Once you have a key you can submit events via POST to the Events resource, which is located at https://api.intercom.io/events, or you can send events using one of the client libraries. When working with the HTTP API directly a client should send the event with a <code>Content-Type</code> of <code>application/json</code>.
     * <p>When using the JavaScript API, <a href="http://docs.intercom.io/configuring-Intercom/tracking-user-events-in-your-app">adding the code to your app</a> makes the Events API available. Once added, you can submit an event using the <code>trackEvent</code> method. This will associate the event with the Lead or currently logged-in user or logged-out visitor/lead and send it to Intercom. The final parameter is a map that can be used to send optional metadata about the event.</p>
     * <p>With the Ruby client you pass a hash describing the event to <code>Intercom::Event.create</code>, or call the <code>track_user</code> method directly on the current user object (e.g. <code>user.track_event</code>).</p>
     * <p><strong>NB: For the JSON object types, please note that we do not currently support nested JSON structure.</strong></p>
     * <p>| Type            | Description                                                                                                                                                                                                     | Example                                                                           |
     * | :-------------- | :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :-------------------------------------------------------------------------------- |
     * | String          | The value is a JSON String                                                                                                                                                                                      | <code>&quot;source&quot;:&quot;desktop&quot;</code>                                                              |
     * | Number          | The value is a JSON Number                                                                                                                                                                                      | <code>&quot;load&quot;: 3.67</code>                                                                    |
     * | Date            | The key ends with the String <code>_date</code> and the value is a <a href="http://en.wikipedia.org/wiki/Unix_time">Unix timestamp</a>, assumed to be in the <a href="http://en.wikipedia.org/wiki/Coordinated_Universal_Time">UTC</a> timezone. | <code>&quot;contact_date&quot;: 1392036272</code>                                                      |
     * | Link            | The value is a HTTP or HTTPS URI.                                                                                                                                                                               | <code>&quot;article&quot;: &quot;https://example.org/ab1de.html&quot;</code>                                     |
     * | Rich Link       | The value is a JSON object that contains <code>url</code> and <code>value</code> keys.                                                                                                                                                | <code>&quot;article&quot;: {&quot;url&quot;: &quot;https://example.org/ab1de.html&quot;, &quot;value&quot;:&quot;the dude abides&quot;}</code> |
     * | Monetary Amount | The value is a JSON object that contains <code>amount</code> and <code>currency</code> keys. The <code>amount</code> key is a positive integer representing the amount in cents. The price in the example to the right denotes €349.99.          | <code>&quot;price&quot;: {&quot;amount&quot;: 34999, &quot;currency&quot;: &quot;eur&quot;}</code>                                   |</p>
     * <p><strong>Lead Events</strong></p>
     * <p>When submitting events for Leads, you will need to specify the Lead's <code>id</code>.</p>
     * <p><strong>Metadata behaviour</strong></p>
     * <ul>
     * <li>We currently limit the number of tracked metadata keys to 10 per event. Once the quota is reached, we ignore any further keys we receive. The first 10 metadata keys are determined by the order in which they are sent in with the event.</li>
     * <li>It is not possible to change the metadata keys once the event has been sent. A new event will need to be created with the new keys and you can archive the old one.</li>
     * <li>There might be up to 24 hrs delay when you send a new metadata for an existing event.</li>
     * </ul>
     * <p><strong>Event de-duplication</strong></p>
     * <p>The API may detect and ignore duplicate events. Each event is uniquely identified as a combination of the following data - the Workspace identifier, the Contact external identifier, the Data Event name and the Data Event created time. As a result, it is <strong>strongly recommended</strong> to send a second granularity Unix timestamp in the <code>created_at</code> field.</p>
     * <p>Duplicated events are responded to using the normal <code>202 Accepted</code> code - an error is not thrown, however repeat requests will be counted against any rate limit that is in place.</p>
     * <h3>HTTP API Responses</h3>
     * <ul>
     * <li>Successful responses to submitted events return <code>202 Accepted</code> with an empty body.</li>
     * <li>Unauthorised access will be rejected with a <code>401 Unauthorized</code> or <code>403 Forbidden</code> response code.</li>
     * <li>Events sent about users that cannot be found will return a <code>404 Not Found</code>.</li>
     * <li>Event lists containing duplicate events will have those duplicates ignored.</li>
     * <li>Server errors will return a <code>500</code> response code and may contain an error message in the body.</li>
     * </ul>
     */
    public CompletableFuture<Void> createDataEvent(Object request, RequestOptions requestOptions) {
        return this.rawClient.createDataEvent(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Create event summaries for a user. Event summaries are used to track the number of times an event has occurred, the first time it occurred and the last time it occurred.
     */
    public CompletableFuture<Void> dataEventSummaries() {
        return this.rawClient.dataEventSummaries().thenApply(response -> response.body());
    }

    /**
     * Create event summaries for a user. Event summaries are used to track the number of times an event has occurred, the first time it occurred and the last time it occurred.
     */
    public CompletableFuture<Void> dataEventSummaries(CreateDataEventSummariesRequest request) {
        return this.rawClient.dataEventSummaries(request).thenApply(response -> response.body());
    }

    /**
     * Create event summaries for a user. Event summaries are used to track the number of times an event has occurred, the first time it occurred and the last time it occurred.
     */
    public CompletableFuture<Void> dataEventSummaries(
            CreateDataEventSummariesRequest request, RequestOptions requestOptions) {
        return this.rawClient.dataEventSummaries(request, requestOptions).thenApply(response -> response.body());
    }
}
