/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.helpcenter.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.GroupTranslatedContent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateCollectionRequest.Builder.class)
public final class CreateCollectionRequest {
    private final String name;

    private final Optional<String> description;

    private final Optional<GroupTranslatedContent> translatedContent;

    private final Optional<String> parentId;

    private final Optional<Integer> helpCenterId;

    private final Map<String, Object> additionalProperties;

    private CreateCollectionRequest(
            String name,
            Optional<String> description,
            Optional<GroupTranslatedContent> translatedContent,
            Optional<String> parentId,
            Optional<Integer> helpCenterId,
            Map<String, Object> additionalProperties) {
        this.name = name;
        this.description = description;
        this.translatedContent = translatedContent;
        this.parentId = parentId;
        this.helpCenterId = helpCenterId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The name of the collection. For multilingual collections, this will be the name of the default language's content.
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The description of the collection. For multilingual collections, this will be the description of the default language's content.
     */
    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    @JsonProperty("translated_content")
    public Optional<GroupTranslatedContent> getTranslatedContent() {
        return translatedContent;
    }

    /**
     * @return The id of the parent collection. If <code>null</code> then it will be created as the first level collection.
     */
    @JsonProperty("parent_id")
    public Optional<String> getParentId() {
        return parentId;
    }

    /**
     * @return The id of the help center where the collection will be created. If <code>null</code> then it will be created in the default help center.
     */
    @JsonProperty("help_center_id")
    public Optional<Integer> getHelpCenterId() {
        return helpCenterId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateCollectionRequest && equalTo((CreateCollectionRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCollectionRequest other) {
        return name.equals(other.name)
                && description.equals(other.description)
                && translatedContent.equals(other.translatedContent)
                && parentId.equals(other.parentId)
                && helpCenterId.equals(other.helpCenterId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.name, this.description, this.translatedContent, this.parentId, this.helpCenterId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        /**
         * The name of the collection. For multilingual collections, this will be the name of the default language's content.
         */
        _FinalStage name(@NotNull String name);

        Builder from(CreateCollectionRequest other);
    }

    public interface _FinalStage {
        CreateCollectionRequest build();

        /**
         * <p>The description of the collection. For multilingual collections, this will be the description of the default language's content.</p>
         */
        _FinalStage description(Optional<String> description);

        _FinalStage description(String description);

        _FinalStage translatedContent(Optional<GroupTranslatedContent> translatedContent);

        _FinalStage translatedContent(GroupTranslatedContent translatedContent);

        /**
         * <p>The id of the parent collection. If <code>null</code> then it will be created as the first level collection.</p>
         */
        _FinalStage parentId(Optional<String> parentId);

        _FinalStage parentId(String parentId);

        /**
         * <p>The id of the help center where the collection will be created. If <code>null</code> then it will be created in the default help center.</p>
         */
        _FinalStage helpCenterId(Optional<Integer> helpCenterId);

        _FinalStage helpCenterId(Integer helpCenterId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NameStage, _FinalStage {
        private String name;

        private Optional<Integer> helpCenterId = Optional.empty();

        private Optional<String> parentId = Optional.empty();

        private Optional<GroupTranslatedContent> translatedContent = Optional.empty();

        private Optional<String> description = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateCollectionRequest other) {
            name(other.getName());
            description(other.getDescription());
            translatedContent(other.getTranslatedContent());
            parentId(other.getParentId());
            helpCenterId(other.getHelpCenterId());
            return this;
        }

        /**
         * The name of the collection. For multilingual collections, this will be the name of the default language's content.<p>The name of the collection. For multilingual collections, this will be the name of the default language's content.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * <p>The id of the help center where the collection will be created. If <code>null</code> then it will be created in the default help center.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage helpCenterId(Integer helpCenterId) {
            this.helpCenterId = Optional.ofNullable(helpCenterId);
            return this;
        }

        /**
         * <p>The id of the help center where the collection will be created. If <code>null</code> then it will be created in the default help center.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "help_center_id", nulls = Nulls.SKIP)
        public _FinalStage helpCenterId(Optional<Integer> helpCenterId) {
            this.helpCenterId = helpCenterId;
            return this;
        }

        /**
         * <p>The id of the parent collection. If <code>null</code> then it will be created as the first level collection.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage parentId(String parentId) {
            this.parentId = Optional.ofNullable(parentId);
            return this;
        }

        /**
         * <p>The id of the parent collection. If <code>null</code> then it will be created as the first level collection.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "parent_id", nulls = Nulls.SKIP)
        public _FinalStage parentId(Optional<String> parentId) {
            this.parentId = parentId;
            return this;
        }

        @java.lang.Override
        public _FinalStage translatedContent(GroupTranslatedContent translatedContent) {
            this.translatedContent = Optional.ofNullable(translatedContent);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "translated_content", nulls = Nulls.SKIP)
        public _FinalStage translatedContent(Optional<GroupTranslatedContent> translatedContent) {
            this.translatedContent = translatedContent;
            return this;
        }

        /**
         * <p>The description of the collection. For multilingual collections, this will be the description of the default language's content.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        /**
         * <p>The description of the collection. For multilingual collections, this will be the description of the default language's content.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @java.lang.Override
        public CreateCollectionRequest build() {
            return new CreateCollectionRequest(
                    name, description, translatedContent, parentId, helpCenterId, additionalProperties);
        }
    }
}
