/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.jobs;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.jobs.requests.JobsStatusRequest;
import com.intercom.api.resources.unstable.jobs.types.Jobs;
import java.util.concurrent.CompletableFuture;

public class AsyncJobsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawJobsClient rawClient;

    public AsyncJobsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawJobsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawJobsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * Retrieve the status of job execution.
     */
    public CompletableFuture<Jobs> status(JobsStatusRequest request) {
        return this.rawClient.status(request).thenApply(response -> response.body());
    }

    /**
     * Retrieve the status of job execution.
     */
    public CompletableFuture<Jobs> status(JobsStatusRequest request, RequestOptions requestOptions) {
        return this.rawClient.status(request, requestOptions).thenApply(response -> response.body());
    }
}
