/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.news;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.news.requests.DeleteNewsItemRequest;
import com.intercom.api.resources.unstable.news.requests.ListLiveNewsfeedItemsRequest;
import com.intercom.api.resources.unstable.news.requests.RetrieveNewsItemRequest;
import com.intercom.api.resources.unstable.news.requests.RetrieveNewsfeedRequest;
import com.intercom.api.resources.unstable.news.requests.UpdateNewsItemRequest;
import com.intercom.api.resources.unstable.news.types.NewsItem;
import com.intercom.api.resources.unstable.news.types.Newsfeed;
import com.intercom.api.resources.unstable.types.DeletedObject;
import com.intercom.api.resources.unstable.types.NewsItemRequest;
import com.intercom.api.resources.unstable.types.PaginatedResponse;

public class NewsClient {
    protected final ClientOptions clientOptions;

    private final RawNewsClient rawClient;

    public NewsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawNewsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawNewsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of all news items
     */
    public PaginatedResponse listNewsItems() {
        return this.rawClient.listNewsItems().body();
    }

    /**
     * You can fetch a list of all news items
     */
    public PaginatedResponse listNewsItems(RequestOptions requestOptions) {
        return this.rawClient.listNewsItems(requestOptions).body();
    }

    /**
     * You can create a news item
     */
    public NewsItem createNewsItem(NewsItemRequest request) {
        return this.rawClient.createNewsItem(request).body();
    }

    /**
     * You can create a news item
     */
    public NewsItem createNewsItem(NewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.createNewsItem(request, requestOptions).body();
    }

    /**
     * You can fetch the details of a single news item.
     */
    public NewsItem retrieveNewsItem(RetrieveNewsItemRequest request) {
        return this.rawClient.retrieveNewsItem(request).body();
    }

    /**
     * You can fetch the details of a single news item.
     */
    public NewsItem retrieveNewsItem(RetrieveNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveNewsItem(request, requestOptions).body();
    }

    public NewsItem updateNewsItem(UpdateNewsItemRequest request) {
        return this.rawClient.updateNewsItem(request).body();
    }

    public NewsItem updateNewsItem(UpdateNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateNewsItem(request, requestOptions).body();
    }

    /**
     * You can delete a single news item.
     */
    public DeletedObject deleteNewsItem(DeleteNewsItemRequest request) {
        return this.rawClient.deleteNewsItem(request).body();
    }

    /**
     * You can delete a single news item.
     */
    public DeletedObject deleteNewsItem(DeleteNewsItemRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteNewsItem(request, requestOptions).body();
    }

    /**
     * You can fetch a list of all news items that are live on a given newsfeed
     */
    public PaginatedResponse listLiveNewsfeedItems(ListLiveNewsfeedItemsRequest request) {
        return this.rawClient.listLiveNewsfeedItems(request).body();
    }

    /**
     * You can fetch a list of all news items that are live on a given newsfeed
     */
    public PaginatedResponse listLiveNewsfeedItems(
            ListLiveNewsfeedItemsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listLiveNewsfeedItems(request, requestOptions).body();
    }

    /**
     * You can fetch a list of all newsfeeds
     */
    public PaginatedResponse listNewsfeeds() {
        return this.rawClient.listNewsfeeds().body();
    }

    /**
     * You can fetch a list of all newsfeeds
     */
    public PaginatedResponse listNewsfeeds(RequestOptions requestOptions) {
        return this.rawClient.listNewsfeeds(requestOptions).body();
    }

    /**
     * You can fetch the details of a single newsfeed
     */
    public Newsfeed retrieveNewsfeed(RetrieveNewsfeedRequest request) {
        return this.rawClient.retrieveNewsfeed(request).body();
    }

    /**
     * You can fetch the details of a single newsfeed
     */
    public Newsfeed retrieveNewsfeed(RetrieveNewsfeedRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveNewsfeed(request, requestOptions).body();
    }
}
