/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.notes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateNoteRequest.Builder.class)
public final class CreateNoteRequest {
    private final int id;

    private final String body;

    private final Optional<String> contactId;

    private final Optional<String> adminId;

    private final Map<String, Object> additionalProperties;

    private CreateNoteRequest(
            int id,
            String body,
            Optional<String> contactId,
            Optional<String> adminId,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.body = body;
        this.contactId = contactId;
        this.adminId = adminId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier of a given contact.
     */
    @JsonProperty("id")
    public int getId() {
        return id;
    }

    /**
     * @return The text of the note.
     */
    @JsonProperty("body")
    public String getBody() {
        return body;
    }

    /**
     * @return The unique identifier of a given contact.
     */
    @JsonProperty("contact_id")
    public Optional<String> getContactId() {
        return contactId;
    }

    /**
     * @return The unique identifier of a given admin.
     */
    @JsonProperty("admin_id")
    public Optional<String> getAdminId() {
        return adminId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateNoteRequest && equalTo((CreateNoteRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateNoteRequest other) {
        return id == other.id
                && body.equals(other.body)
                && contactId.equals(other.contactId)
                && adminId.equals(other.adminId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.body, this.contactId, this.adminId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The unique identifier of a given contact.
         */
        BodyStage id(int id);

        Builder from(CreateNoteRequest other);
    }

    public interface BodyStage {
        /**
         * The text of the note.
         */
        _FinalStage body(@NotNull String body);
    }

    public interface _FinalStage {
        CreateNoteRequest build();

        /**
         * <p>The unique identifier of a given contact.</p>
         */
        _FinalStage contactId(Optional<String> contactId);

        _FinalStage contactId(String contactId);

        /**
         * <p>The unique identifier of a given admin.</p>
         */
        _FinalStage adminId(Optional<String> adminId);

        _FinalStage adminId(String adminId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, BodyStage, _FinalStage {
        private int id;

        private String body;

        private Optional<String> adminId = Optional.empty();

        private Optional<String> contactId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateNoteRequest other) {
            id(other.getId());
            body(other.getBody());
            contactId(other.getContactId());
            adminId(other.getAdminId());
            return this;
        }

        /**
         * The unique identifier of a given contact.<p>The unique identifier of a given contact.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public BodyStage id(int id) {
            this.id = id;
            return this;
        }

        /**
         * The text of the note.<p>The text of the note.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        /**
         * <p>The unique identifier of a given admin.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage adminId(String adminId) {
            this.adminId = Optional.ofNullable(adminId);
            return this;
        }

        /**
         * <p>The unique identifier of a given admin.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "admin_id", nulls = Nulls.SKIP)
        public _FinalStage adminId(Optional<String> adminId) {
            this.adminId = adminId;
            return this;
        }

        /**
         * <p>The unique identifier of a given contact.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage contactId(String contactId) {
            this.contactId = Optional.ofNullable(contactId);
            return this;
        }

        /**
         * <p>The unique identifier of a given contact.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "contact_id", nulls = Nulls.SKIP)
        public _FinalStage contactId(Optional<String> contactId) {
            this.contactId = contactId;
            return this;
        }

        @java.lang.Override
        public CreateNoteRequest build() {
            return new CreateNoteRequest(id, body, contactId, adminId, additionalProperties);
        }
    }
}
