/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.tickettypes;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.tickets.types.TicketType;
import com.intercom.api.resources.unstable.tickettypes.requests.GetTicketTypeRequest;
import com.intercom.api.resources.unstable.types.TicketTypeList;
import java.util.Optional;

public class TicketTypesClient {
    protected final ClientOptions clientOptions;

    private final RawTicketTypesClient rawClient;

    public TicketTypesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawTicketTypesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawTicketTypesClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can get a list of all ticket types for a workspace.
     */
    public TicketTypeList listTicketTypes() {
        return this.rawClient.listTicketTypes().body();
    }

    /**
     * You can get a list of all ticket types for a workspace.
     */
    public TicketTypeList listTicketTypes(RequestOptions requestOptions) {
        return this.rawClient.listTicketTypes(requestOptions).body();
    }

    /**
     * You can create a new ticket type.
     * <blockquote>
     * <p>📘 Creating ticket types.</p>
     * <p>Every ticket type will be created with two default attributes: <em>default_title</em> and <em>default_description</em>.
     * For the <code>icon</code> propery, use an emoji from <a href="https://twemoji-cheatsheet.vercel.app/">Twemoji Cheatsheet</a></p>
     * </blockquote>
     */
    public Optional<TicketType> createTicketType(Object request) {
        return this.rawClient.createTicketType(request).body();
    }

    /**
     * You can create a new ticket type.
     * <blockquote>
     * <p>📘 Creating ticket types.</p>
     * <p>Every ticket type will be created with two default attributes: <em>default_title</em> and <em>default_description</em>.
     * For the <code>icon</code> propery, use an emoji from <a href="https://twemoji-cheatsheet.vercel.app/">Twemoji Cheatsheet</a></p>
     * </blockquote>
     */
    public Optional<TicketType> createTicketType(Object request, RequestOptions requestOptions) {
        return this.rawClient.createTicketType(request, requestOptions).body();
    }

    /**
     * You can fetch the details of a single ticket type.
     */
    public Optional<TicketType> getTicketType(GetTicketTypeRequest request) {
        return this.rawClient.getTicketType(request).body();
    }

    /**
     * You can fetch the details of a single ticket type.
     */
    public Optional<TicketType> getTicketType(GetTicketTypeRequest request, RequestOptions requestOptions) {
        return this.rawClient.getTicketType(request, requestOptions).body();
    }
}
