/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AdminPriorityLevel.Builder.class)
public final class AdminPriorityLevel {
    private final Optional<List<Integer>> primaryAdminIds;

    private final Optional<List<Integer>> secondaryAdminIds;

    private final Map<String, Object> additionalProperties;

    private AdminPriorityLevel(
            Optional<List<Integer>> primaryAdminIds,
            Optional<List<Integer>> secondaryAdminIds,
            Map<String, Object> additionalProperties) {
        this.primaryAdminIds = primaryAdminIds;
        this.secondaryAdminIds = secondaryAdminIds;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The primary admin ids for the team
     */
    @JsonProperty("primary_admin_ids")
    public Optional<List<Integer>> getPrimaryAdminIds() {
        return primaryAdminIds;
    }

    /**
     * @return The secondary admin ids for the team
     */
    @JsonProperty("secondary_admin_ids")
    public Optional<List<Integer>> getSecondaryAdminIds() {
        return secondaryAdminIds;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AdminPriorityLevel && equalTo((AdminPriorityLevel) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AdminPriorityLevel other) {
        return primaryAdminIds.equals(other.primaryAdminIds) && secondaryAdminIds.equals(other.secondaryAdminIds);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.primaryAdminIds, this.secondaryAdminIds);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<Integer>> primaryAdminIds = Optional.empty();

        private Optional<List<Integer>> secondaryAdminIds = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(AdminPriorityLevel other) {
            primaryAdminIds(other.getPrimaryAdminIds());
            secondaryAdminIds(other.getSecondaryAdminIds());
            return this;
        }

        /**
         * <p>The primary admin ids for the team</p>
         */
        @JsonSetter(value = "primary_admin_ids", nulls = Nulls.SKIP)
        public Builder primaryAdminIds(Optional<List<Integer>> primaryAdminIds) {
            this.primaryAdminIds = primaryAdminIds;
            return this;
        }

        public Builder primaryAdminIds(List<Integer> primaryAdminIds) {
            this.primaryAdminIds = Optional.ofNullable(primaryAdminIds);
            return this;
        }

        /**
         * <p>The secondary admin ids for the team</p>
         */
        @JsonSetter(value = "secondary_admin_ids", nulls = Nulls.SKIP)
        public Builder secondaryAdminIds(Optional<List<Integer>> secondaryAdminIds) {
            this.secondaryAdminIds = secondaryAdminIds;
            return this;
        }

        public Builder secondaryAdminIds(List<Integer> secondaryAdminIds) {
            this.secondaryAdminIds = Optional.ofNullable(secondaryAdminIds);
            return this;
        }

        public AdminPriorityLevel build() {
            return new AdminPriorityLevel(primaryAdminIds, secondaryAdminIds, additionalProperties);
        }
    }
}
