/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PartAttachment.Builder.class)
public final class PartAttachment {
    private final Optional<String> type;

    private final Optional<String> name;

    private final Optional<String> url;

    private final Optional<String> contentType;

    private final Optional<Integer> filesize;

    private final Optional<Integer> width;

    private final Optional<Integer> height;

    private final Map<String, Object> additionalProperties;

    private PartAttachment(
            Optional<String> type,
            Optional<String> name,
            Optional<String> url,
            Optional<String> contentType,
            Optional<Integer> filesize,
            Optional<Integer> width,
            Optional<Integer> height,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.name = name;
        this.url = url;
        this.contentType = contentType;
        this.filesize = filesize;
        this.width = width;
        this.height = height;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of attachment
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The name of the attachment
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The URL of the attachment
     */
    @JsonProperty("url")
    public Optional<String> getUrl() {
        return url;
    }

    /**
     * @return The content type of the attachment
     */
    @JsonProperty("content_type")
    public Optional<String> getContentType() {
        return contentType;
    }

    /**
     * @return The size of the attachment
     */
    @JsonProperty("filesize")
    public Optional<Integer> getFilesize() {
        return filesize;
    }

    /**
     * @return The width of the attachment
     */
    @JsonProperty("width")
    public Optional<Integer> getWidth() {
        return width;
    }

    /**
     * @return The height of the attachment
     */
    @JsonProperty("height")
    public Optional<Integer> getHeight() {
        return height;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PartAttachment && equalTo((PartAttachment) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PartAttachment other) {
        return type.equals(other.type)
                && name.equals(other.name)
                && url.equals(other.url)
                && contentType.equals(other.contentType)
                && filesize.equals(other.filesize)
                && width.equals(other.width)
                && height.equals(other.height);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.name, this.url, this.contentType, this.filesize, this.width, this.height);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> url = Optional.empty();

        private Optional<String> contentType = Optional.empty();

        private Optional<Integer> filesize = Optional.empty();

        private Optional<Integer> width = Optional.empty();

        private Optional<Integer> height = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(PartAttachment other) {
            type(other.getType());
            name(other.getName());
            url(other.getUrl());
            contentType(other.getContentType());
            filesize(other.getFilesize());
            width(other.getWidth());
            height(other.getHeight());
            return this;
        }

        /**
         * <p>The type of attachment</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The name of the attachment</p>
         */
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The URL of the attachment</p>
         */
        @JsonSetter(value = "url", nulls = Nulls.SKIP)
        public Builder url(Optional<String> url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        /**
         * <p>The content type of the attachment</p>
         */
        @JsonSetter(value = "content_type", nulls = Nulls.SKIP)
        public Builder contentType(Optional<String> contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = Optional.ofNullable(contentType);
            return this;
        }

        /**
         * <p>The size of the attachment</p>
         */
        @JsonSetter(value = "filesize", nulls = Nulls.SKIP)
        public Builder filesize(Optional<Integer> filesize) {
            this.filesize = filesize;
            return this;
        }

        public Builder filesize(Integer filesize) {
            this.filesize = Optional.ofNullable(filesize);
            return this;
        }

        /**
         * <p>The width of the attachment</p>
         */
        @JsonSetter(value = "width", nulls = Nulls.SKIP)
        public Builder width(Optional<Integer> width) {
            this.width = width;
            return this;
        }

        public Builder width(Integer width) {
            this.width = Optional.ofNullable(width);
            return this;
        }

        /**
         * <p>The height of the attachment</p>
         */
        @JsonSetter(value = "height", nulls = Nulls.SKIP)
        public Builder height(Optional<Integer> height) {
            this.height = height;
            return this;
        }

        public Builder height(Integer height) {
            this.height = Optional.ofNullable(height);
            return this;
        }

        public PartAttachment build() {
            return new PartAttachment(type, name, url, contentType, filesize, width, height, additionalProperties);
        }
    }
}
