/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.visitors.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConvertVisitorRequest.Builder.class)
public final class ConvertVisitorRequest {
    private final String type;

    private final Object user;

    private final Object visitor;

    private final Map<String, Object> additionalProperties;

    private ConvertVisitorRequest(String type, Object user, Object visitor, Map<String, Object> additionalProperties) {
        this.type = type;
        this.user = user;
        this.visitor = visitor;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Represents the role of the Contact model. Accepts <code>lead</code> or <code>user</code>.
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    @JsonProperty("user")
    public Object getUser() {
        return user;
    }

    @JsonProperty("visitor")
    public Object getVisitor() {
        return visitor;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConvertVisitorRequest && equalTo((ConvertVisitorRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConvertVisitorRequest other) {
        return type.equals(other.type) && user.equals(other.user) && visitor.equals(other.visitor);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.user, this.visitor);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * Represents the role of the Contact model. Accepts `lead` or `user`.
         */
        UserStage type(@NotNull String type);

        Builder from(ConvertVisitorRequest other);
    }

    public interface UserStage {
        VisitorStage user(Object user);
    }

    public interface VisitorStage {
        _FinalStage visitor(Object visitor);
    }

    public interface _FinalStage {
        ConvertVisitorRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, UserStage, VisitorStage, _FinalStage {
        private String type;

        private Object user;

        private Object visitor;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ConvertVisitorRequest other) {
            type(other.getType());
            user(other.getUser());
            visitor(other.getVisitor());
            return this;
        }

        /**
         * Represents the role of the Contact model. Accepts `lead` or `user`.<p>Represents the role of the Contact model. Accepts <code>lead</code> or <code>user</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public UserStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("user")
        public VisitorStage user(Object user) {
            this.user = user;
            return this;
        }

        @java.lang.Override
        @JsonSetter("visitor")
        public _FinalStage visitor(Object visitor) {
            this.visitor = visitor;
            return this;
        }

        @java.lang.Override
        public ConvertVisitorRequest build() {
            return new ConvertVisitorRequest(type, user, visitor, additionalProperties);
        }
    }
}
