/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.visitors.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = FindVisitorRequest.Builder.class)
public final class FindVisitorRequest {
    private final String userId;

    private final Map<String, Object> additionalProperties;

    private FindVisitorRequest(String userId, Map<String, Object> additionalProperties) {
        this.userId = userId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The user_id of the Visitor you want to retrieve.
     */
    @JsonProperty("user_id")
    public String getUserId() {
        return userId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof FindVisitorRequest && equalTo((FindVisitorRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FindVisitorRequest other) {
        return userId.equals(other.userId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.userId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UserIdStage builder() {
        return new Builder();
    }

    public interface UserIdStage {
        /**
         * The user_id of the Visitor you want to retrieve.
         */
        _FinalStage userId(@NotNull String userId);

        Builder from(FindVisitorRequest other);
    }

    public interface _FinalStage {
        FindVisitorRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements UserIdStage, _FinalStage {
        private String userId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(FindVisitorRequest other) {
            userId(other.getUserId());
            return this;
        }

        /**
         * The user_id of the Visitor you want to retrieve.<p>The user_id of the Visitor you want to retrieve.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("user_id")
        public _FinalStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @java.lang.Override
        public FindVisitorRequest build() {
            return new FindVisitorRequest(userId, additionalProperties);
        }
    }
}
