/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.admins.types.Admin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AdminList.Builder.class)
public final class AdminList {
    private final List<Admin> admins;

    private final Map<String, Object> additionalProperties;

    private AdminList(List<Admin> admins, Map<String, Object> additionalProperties) {
        this.admins = admins;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return String representing the object's type. Always has the value <code>admin.list</code>.
     */
    @JsonProperty("type")
    public String getType() {
        return "admin.list";
    }

    /**
     * @return A list of admins associated with a given workspace.
     */
    @JsonProperty("admins")
    public List<Admin> getAdmins() {
        return admins;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AdminList && equalTo((AdminList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AdminList other) {
        return admins.equals(other.admins);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.admins);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<Admin> admins = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(AdminList other) {
            admins(other.getAdmins());
            return this;
        }

        /**
         * <p>A list of admins associated with a given workspace.</p>
         */
        @JsonSetter(value = "admins", nulls = Nulls.SKIP)
        public Builder admins(List<Admin> admins) {
            this.admins.clear();
            this.admins.addAll(admins);
            return this;
        }

        public Builder addAdmins(Admin admins) {
            this.admins.add(admins);
            return this;
        }

        public Builder addAllAdmins(List<Admin> admins) {
            this.admins.addAll(admins);
            return this;
        }

        public AdminList build() {
            return new AdminList(admins, additionalProperties);
        }
    }
}
