/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.articles.types.ArticleListItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ArticleList.Builder.class)
public final class ArticleList {
    private final Optional<Object> pages;

    private final int totalCount;

    private final List<ArticleListItem> data;

    private final Map<String, Object> additionalProperties;

    private ArticleList(
            Optional<Object> pages,
            int totalCount,
            List<ArticleListItem> data,
            Map<String, Object> additionalProperties) {
        this.pages = pages;
        this.totalCount = totalCount;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object - <code>list</code>.
     */
    @JsonProperty("type")
    public String getType() {
        return "list";
    }

    @JsonProperty("pages")
    public Optional<Object> getPages() {
        return pages;
    }

    /**
     * @return A count of the total number of articles.
     */
    @JsonProperty("total_count")
    public int getTotalCount() {
        return totalCount;
    }

    /**
     * @return An array of Article objects
     */
    @JsonProperty("data")
    public List<ArticleListItem> getData() {
        return data;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ArticleList && equalTo((ArticleList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ArticleList other) {
        return pages.equals(other.pages) && totalCount == other.totalCount && data.equals(other.data);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.pages, this.totalCount, this.data);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    public interface TotalCountStage {
        /**
         * A count of the total number of articles.
         */
        _FinalStage totalCount(int totalCount);

        Builder from(ArticleList other);
    }

    public interface _FinalStage {
        ArticleList build();

        _FinalStage pages(Optional<Object> pages);

        _FinalStage pages(Object pages);

        /**
         * <p>An array of Article objects</p>
         */
        _FinalStage data(List<ArticleListItem> data);

        _FinalStage addData(ArticleListItem data);

        _FinalStage addAllData(List<ArticleListItem> data);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TotalCountStage, _FinalStage {
        private int totalCount;

        private List<ArticleListItem> data = new ArrayList<>();

        private Optional<Object> pages = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ArticleList other) {
            pages(other.getPages());
            totalCount(other.getTotalCount());
            data(other.getData());
            return this;
        }

        /**
         * A count of the total number of articles.<p>A count of the total number of articles.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        /**
         * <p>An array of Article objects</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllData(List<ArticleListItem> data) {
            this.data.addAll(data);
            return this;
        }

        /**
         * <p>An array of Article objects</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addData(ArticleListItem data) {
            this.data.add(data);
            return this;
        }

        /**
         * <p>An array of Article objects</p>
         */
        @java.lang.Override
        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public _FinalStage data(List<ArticleListItem> data) {
            this.data.clear();
            this.data.addAll(data);
            return this;
        }

        @java.lang.Override
        public _FinalStage pages(Object pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public _FinalStage pages(Optional<Object> pages) {
            this.pages = pages;
            return this;
        }

        @java.lang.Override
        public ArticleList build() {
            return new ArticleList(pages, totalCount, data, additionalProperties);
        }
    }
}
