/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.companies.types.Company;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ContactAttachedCompanies.Builder.class)
public final class ContactAttachedCompanies {
    private final List<Company> companies;

    private final int totalCount;

    private final Optional<PagesLink> pages;

    private final Map<String, Object> additionalProperties;

    private ContactAttachedCompanies(
            List<Company> companies,
            int totalCount,
            Optional<PagesLink> pages,
            Map<String, Object> additionalProperties) {
        this.companies = companies;
        this.totalCount = totalCount;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object
     */
    @JsonProperty("type")
    public String getType() {
        return "list";
    }

    /**
     * @return An array containing Company Objects
     */
    @JsonProperty("companies")
    public List<Company> getCompanies() {
        return companies;
    }

    /**
     * @return The total number of companies associated to this contact
     */
    @JsonProperty("total_count")
    public int getTotalCount() {
        return totalCount;
    }

    @JsonProperty("pages")
    public Optional<PagesLink> getPages() {
        return pages;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ContactAttachedCompanies && equalTo((ContactAttachedCompanies) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactAttachedCompanies other) {
        return companies.equals(other.companies) && totalCount == other.totalCount && pages.equals(other.pages);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.companies, this.totalCount, this.pages);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    public interface TotalCountStage {
        /**
         * The total number of companies associated to this contact
         */
        _FinalStage totalCount(int totalCount);

        Builder from(ContactAttachedCompanies other);
    }

    public interface _FinalStage {
        ContactAttachedCompanies build();

        /**
         * <p>An array containing Company Objects</p>
         */
        _FinalStage companies(List<Company> companies);

        _FinalStage addCompanies(Company companies);

        _FinalStage addAllCompanies(List<Company> companies);

        _FinalStage pages(Optional<PagesLink> pages);

        _FinalStage pages(PagesLink pages);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TotalCountStage, _FinalStage {
        private int totalCount;

        private Optional<PagesLink> pages = Optional.empty();

        private List<Company> companies = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ContactAttachedCompanies other) {
            companies(other.getCompanies());
            totalCount(other.getTotalCount());
            pages(other.getPages());
            return this;
        }

        /**
         * The total number of companies associated to this contact<p>The total number of companies associated to this contact</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage pages(PagesLink pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public _FinalStage pages(Optional<PagesLink> pages) {
            this.pages = pages;
            return this;
        }

        /**
         * <p>An array containing Company Objects</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllCompanies(List<Company> companies) {
            this.companies.addAll(companies);
            return this;
        }

        /**
         * <p>An array containing Company Objects</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addCompanies(Company companies) {
            this.companies.add(companies);
            return this;
        }

        /**
         * <p>An array containing Company Objects</p>
         */
        @java.lang.Override
        @JsonSetter(value = "companies", nulls = Nulls.SKIP)
        public _FinalStage companies(List<Company> companies) {
            this.companies.clear();
            this.companies.addAll(companies);
            return this;
        }

        @java.lang.Override
        public ContactAttachedCompanies build() {
            return new ContactAttachedCompanies(companies, totalCount, pages, additionalProperties);
        }
    }
}
