/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Context.Builder.class)
public final class Context {
    private final Optional<Integer> conversationId;

    private final Optional<Location> location;

    private final Optional<String> locale;

    private final Optional<String> messengerActionColour;

    private final Optional<String> messengerBackgroundColour;

    private final Optional<String> referrer;

    private final Map<String, Object> additionalProperties;

    private Context(
            Optional<Integer> conversationId,
            Optional<Location> location,
            Optional<String> locale,
            Optional<String> messengerActionColour,
            Optional<String> messengerBackgroundColour,
            Optional<String> referrer,
            Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.location = location;
        this.locale = locale;
        this.messengerActionColour = messengerActionColour;
        this.messengerBackgroundColour = messengerBackgroundColour;
        this.referrer = referrer;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The id of the conversation where the app is added or being used.
     */
    @JsonProperty("conversation_id")
    public Optional<Integer> getConversationId() {
        return conversationId;
    }

    /**
     * @return Where the app is added or the action took place. Can be either 'conversation', 'home', 'message', or 'operator'.
     */
    @JsonProperty("location")
    public Optional<Location> getLocation() {
        return location;
    }

    /**
     * @return The default end-user language of the Messenger. Use to localise Messenger App content.
     */
    @JsonProperty("locale")
    public Optional<String> getLocale() {
        return locale;
    }

    /**
     * @return The messengers action colour. Use in Sheets and Icons to make a Messenger App experience feel part of the host Messenger.
     */
    @JsonProperty("messenger_action_colour")
    public Optional<String> getMessengerActionColour() {
        return messengerActionColour;
    }

    /**
     * @return The messengers background colour. Use in Sheets and Icons to make a Messenger App experience feel part of the host Messenger.
     */
    @JsonProperty("messenger_background_colour")
    public Optional<String> getMessengerBackgroundColour() {
        return messengerBackgroundColour;
    }

    /**
     * @return The current page URL where the app is being used.
     */
    @JsonProperty("referrer")
    public Optional<String> getReferrer() {
        return referrer;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Context && equalTo((Context) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Context other) {
        return conversationId.equals(other.conversationId)
                && location.equals(other.location)
                && locale.equals(other.locale)
                && messengerActionColour.equals(other.messengerActionColour)
                && messengerBackgroundColour.equals(other.messengerBackgroundColour)
                && referrer.equals(other.referrer);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.conversationId,
                this.location,
                this.locale,
                this.messengerActionColour,
                this.messengerBackgroundColour,
                this.referrer);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Integer> conversationId = Optional.empty();

        private Optional<Location> location = Optional.empty();

        private Optional<String> locale = Optional.empty();

        private Optional<String> messengerActionColour = Optional.empty();

        private Optional<String> messengerBackgroundColour = Optional.empty();

        private Optional<String> referrer = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(Context other) {
            conversationId(other.getConversationId());
            location(other.getLocation());
            locale(other.getLocale());
            messengerActionColour(other.getMessengerActionColour());
            messengerBackgroundColour(other.getMessengerBackgroundColour());
            referrer(other.getReferrer());
            return this;
        }

        /**
         * <p>The id of the conversation where the app is added or being used.</p>
         */
        @JsonSetter(value = "conversation_id", nulls = Nulls.SKIP)
        public Builder conversationId(Optional<Integer> conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public Builder conversationId(Integer conversationId) {
            this.conversationId = Optional.ofNullable(conversationId);
            return this;
        }

        /**
         * <p>Where the app is added or the action took place. Can be either 'conversation', 'home', 'message', or 'operator'.</p>
         */
        @JsonSetter(value = "location", nulls = Nulls.SKIP)
        public Builder location(Optional<Location> location) {
            this.location = location;
            return this;
        }

        public Builder location(Location location) {
            this.location = Optional.ofNullable(location);
            return this;
        }

        /**
         * <p>The default end-user language of the Messenger. Use to localise Messenger App content.</p>
         */
        @JsonSetter(value = "locale", nulls = Nulls.SKIP)
        public Builder locale(Optional<String> locale) {
            this.locale = locale;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = Optional.ofNullable(locale);
            return this;
        }

        /**
         * <p>The messengers action colour. Use in Sheets and Icons to make a Messenger App experience feel part of the host Messenger.</p>
         */
        @JsonSetter(value = "messenger_action_colour", nulls = Nulls.SKIP)
        public Builder messengerActionColour(Optional<String> messengerActionColour) {
            this.messengerActionColour = messengerActionColour;
            return this;
        }

        public Builder messengerActionColour(String messengerActionColour) {
            this.messengerActionColour = Optional.ofNullable(messengerActionColour);
            return this;
        }

        /**
         * <p>The messengers background colour. Use in Sheets and Icons to make a Messenger App experience feel part of the host Messenger.</p>
         */
        @JsonSetter(value = "messenger_background_colour", nulls = Nulls.SKIP)
        public Builder messengerBackgroundColour(Optional<String> messengerBackgroundColour) {
            this.messengerBackgroundColour = messengerBackgroundColour;
            return this;
        }

        public Builder messengerBackgroundColour(String messengerBackgroundColour) {
            this.messengerBackgroundColour = Optional.ofNullable(messengerBackgroundColour);
            return this;
        }

        /**
         * <p>The current page URL where the app is being used.</p>
         */
        @JsonSetter(value = "referrer", nulls = Nulls.SKIP)
        public Builder referrer(Optional<String> referrer) {
            this.referrer = referrer;
            return this;
        }

        public Builder referrer(String referrer) {
            this.referrer = Optional.ofNullable(referrer);
            return this;
        }

        public Context build() {
            return new Context(
                    conversationId,
                    location,
                    locale,
                    messengerActionColour,
                    messengerBackgroundColour,
                    referrer,
                    additionalProperties);
        }
    }

    public static final class Location {
        public static final Location OPERATOR = new Location(Value.OPERATOR, "operator");

        public static final Location MESSAGE = new Location(Value.MESSAGE, "message");

        public static final Location HOME = new Location(Value.HOME, "home");

        public static final Location CONVERSATION = new Location(Value.CONVERSATION, "conversation");

        private final Value value;

        private final String string;

        Location(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Location && this.string.equals(((Location) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case OPERATOR:
                    return visitor.visitOperator();
                case MESSAGE:
                    return visitor.visitMessage();
                case HOME:
                    return visitor.visitHome();
                case CONVERSATION:
                    return visitor.visitConversation();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Location valueOf(String value) {
            switch (value) {
                case "operator":
                    return OPERATOR;
                case "message":
                    return MESSAGE;
                case "home":
                    return HOME;
                case "conversation":
                    return CONVERSATION;
                default:
                    return new Location(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            CONVERSATION,

            HOME,

            MESSAGE,

            OPERATOR,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitConversation();

            T visitHome();

            T visitMessage();

            T visitOperator();

            T visitUnknown(String unknownType);
        }
    }
}
