/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationAttachmentFiles.Builder.class)
public final class ConversationAttachmentFiles {
    private final String contentType;

    private final String data;

    private final String name;

    private final Map<String, Object> additionalProperties;

    private ConversationAttachmentFiles(
            String contentType, String data, String name, Map<String, Object> additionalProperties) {
        this.contentType = contentType;
        this.data = data;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The content type of the file
     */
    @JsonProperty("content_type")
    public String getContentType() {
        return contentType;
    }

    /**
     * @return The base64 encoded file data.
     */
    @JsonProperty("data")
    public String getData() {
        return data;
    }

    /**
     * @return The name of the file.
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationAttachmentFiles && equalTo((ConversationAttachmentFiles) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationAttachmentFiles other) {
        return contentType.equals(other.contentType) && data.equals(other.data) && name.equals(other.name);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.contentType, this.data, this.name);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContentTypeStage builder() {
        return new Builder();
    }

    public interface ContentTypeStage {
        /**
         * The content type of the file
         */
        DataStage contentType(@NotNull String contentType);

        Builder from(ConversationAttachmentFiles other);
    }

    public interface DataStage {
        /**
         * The base64 encoded file data.
         */
        NameStage data(@NotNull String data);
    }

    public interface NameStage {
        /**
         * The name of the file.
         */
        _FinalStage name(@NotNull String name);
    }

    public interface _FinalStage {
        ConversationAttachmentFiles build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ContentTypeStage, DataStage, NameStage, _FinalStage {
        private String contentType;

        private String data;

        private String name;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ConversationAttachmentFiles other) {
            contentType(other.getContentType());
            data(other.getData());
            name(other.getName());
            return this;
        }

        /**
         * The content type of the file<p>The content type of the file</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("content_type")
        public DataStage contentType(@NotNull String contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType must not be null");
            return this;
        }

        /**
         * The base64 encoded file data.<p>The base64 encoded file data.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("data")
        public NameStage data(@NotNull String data) {
            this.data = Objects.requireNonNull(data, "data must not be null");
            return this;
        }

        /**
         * The name of the file.<p>The name of the file.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        public ConversationAttachmentFiles build() {
            return new ConversationAttachmentFiles(contentType, data, name, additionalProperties);
        }
    }
}
