/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationPart.Builder.class)
public final class ConversationPart {
    private final String id;

    private final String partType;

    private final Optional<String> body;

    private final int createdAt;

    private final Optional<Integer> updatedAt;

    private final int notifiedAt;

    private final Optional<Reference> assignedTo;

    private final ConversationPartAuthor author;

    private final Optional<List<PartAttachment>> attachments;

    private final Optional<String> externalId;

    private final boolean redacted;

    private final Map<String, Object> additionalProperties;

    private ConversationPart(
            String id,
            String partType,
            Optional<String> body,
            int createdAt,
            Optional<Integer> updatedAt,
            int notifiedAt,
            Optional<Reference> assignedTo,
            ConversationPartAuthor author,
            Optional<List<PartAttachment>> attachments,
            Optional<String> externalId,
            boolean redacted,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.partType = partType;
        this.body = body;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.notifiedAt = notifiedAt;
        this.assignedTo = assignedTo;
        this.author = author;
        this.attachments = attachments;
        this.externalId = externalId;
        this.redacted = redacted;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always conversation_part
     */
    @JsonProperty("type")
    public String getType() {
        return "conversation_part";
    }

    /**
     * @return The id representing the conversation part.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The type of conversation part.
     */
    @JsonProperty("part_type")
    public String getPartType() {
        return partType;
    }

    /**
     * @return The message body, which may contain HTML. For Twitter, this will show a generic message regarding why the body is obscured.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    /**
     * @return The time the conversation part was created.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The last time the conversation part was updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return The time the user was notified with the conversation part.
     */
    @JsonProperty("notified_at")
    public int getNotifiedAt() {
        return notifiedAt;
    }

    /**
     * @return The id of the admin that was assigned the conversation by this conversation_part (null if there has been no change in assignment.)
     */
    @JsonProperty("assigned_to")
    public Optional<Reference> getAssignedTo() {
        return assignedTo;
    }

    @JsonProperty("author")
    public ConversationPartAuthor getAuthor() {
        return author;
    }

    /**
     * @return A list of attachments for the part.
     */
    @JsonProperty("attachments")
    public Optional<List<PartAttachment>> getAttachments() {
        return attachments;
    }

    /**
     * @return The external id of the conversation part
     */
    @JsonProperty("external_id")
    public Optional<String> getExternalId() {
        return externalId;
    }

    /**
     * @return Whether or not the conversation part has been redacted.
     */
    @JsonProperty("redacted")
    public boolean getRedacted() {
        return redacted;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationPart && equalTo((ConversationPart) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationPart other) {
        return id.equals(other.id)
                && partType.equals(other.partType)
                && body.equals(other.body)
                && createdAt == other.createdAt
                && updatedAt.equals(other.updatedAt)
                && notifiedAt == other.notifiedAt
                && assignedTo.equals(other.assignedTo)
                && author.equals(other.author)
                && attachments.equals(other.attachments)
                && externalId.equals(other.externalId)
                && redacted == other.redacted;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.partType,
                this.body,
                this.createdAt,
                this.updatedAt,
                this.notifiedAt,
                this.assignedTo,
                this.author,
                this.attachments,
                this.externalId,
                this.redacted);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The id representing the conversation part.
         */
        PartTypeStage id(@NotNull String id);

        Builder from(ConversationPart other);
    }

    public interface PartTypeStage {
        /**
         * The type of conversation part.
         */
        CreatedAtStage partType(@NotNull String partType);
    }

    public interface CreatedAtStage {
        /**
         * The time the conversation part was created.
         */
        NotifiedAtStage createdAt(int createdAt);
    }

    public interface NotifiedAtStage {
        /**
         * The time the user was notified with the conversation part.
         */
        AuthorStage notifiedAt(int notifiedAt);
    }

    public interface AuthorStage {
        RedactedStage author(@NotNull ConversationPartAuthor author);
    }

    public interface RedactedStage {
        /**
         * Whether or not the conversation part has been redacted.
         */
        _FinalStage redacted(boolean redacted);
    }

    public interface _FinalStage {
        ConversationPart build();

        /**
         * <p>The message body, which may contain HTML. For Twitter, this will show a generic message regarding why the body is obscured.</p>
         */
        _FinalStage body(Optional<String> body);

        _FinalStage body(String body);

        /**
         * <p>The last time the conversation part was updated.</p>
         */
        _FinalStage updatedAt(Optional<Integer> updatedAt);

        _FinalStage updatedAt(Integer updatedAt);

        /**
         * <p>The id of the admin that was assigned the conversation by this conversation_part (null if there has been no change in assignment.)</p>
         */
        _FinalStage assignedTo(Optional<Reference> assignedTo);

        _FinalStage assignedTo(Reference assignedTo);

        /**
         * <p>A list of attachments for the part.</p>
         */
        _FinalStage attachments(Optional<List<PartAttachment>> attachments);

        _FinalStage attachments(List<PartAttachment> attachments);

        /**
         * <p>The external id of the conversation part</p>
         */
        _FinalStage externalId(Optional<String> externalId);

        _FinalStage externalId(String externalId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements IdStage,
                    PartTypeStage,
                    CreatedAtStage,
                    NotifiedAtStage,
                    AuthorStage,
                    RedactedStage,
                    _FinalStage {
        private String id;

        private String partType;

        private int createdAt;

        private int notifiedAt;

        private ConversationPartAuthor author;

        private boolean redacted;

        private Optional<String> externalId = Optional.empty();

        private Optional<List<PartAttachment>> attachments = Optional.empty();

        private Optional<Reference> assignedTo = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<String> body = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ConversationPart other) {
            id(other.getId());
            partType(other.getPartType());
            body(other.getBody());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            notifiedAt(other.getNotifiedAt());
            assignedTo(other.getAssignedTo());
            author(other.getAuthor());
            attachments(other.getAttachments());
            externalId(other.getExternalId());
            redacted(other.getRedacted());
            return this;
        }

        /**
         * The id representing the conversation part.<p>The id representing the conversation part.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public PartTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The type of conversation part.<p>The type of conversation part.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("part_type")
        public CreatedAtStage partType(@NotNull String partType) {
            this.partType = Objects.requireNonNull(partType, "partType must not be null");
            return this;
        }

        /**
         * The time the conversation part was created.<p>The time the conversation part was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public NotifiedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * The time the user was notified with the conversation part.<p>The time the user was notified with the conversation part.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("notified_at")
        public AuthorStage notifiedAt(int notifiedAt) {
            this.notifiedAt = notifiedAt;
            return this;
        }

        @java.lang.Override
        @JsonSetter("author")
        public RedactedStage author(@NotNull ConversationPartAuthor author) {
            this.author = Objects.requireNonNull(author, "author must not be null");
            return this;
        }

        /**
         * Whether or not the conversation part has been redacted.<p>Whether or not the conversation part has been redacted.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("redacted")
        public _FinalStage redacted(boolean redacted) {
            this.redacted = redacted;
            return this;
        }

        /**
         * <p>The external id of the conversation part</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        /**
         * <p>The external id of the conversation part</p>
         */
        @java.lang.Override
        @JsonSetter(value = "external_id", nulls = Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        /**
         * <p>A list of attachments for the part.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage attachments(List<PartAttachment> attachments) {
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        /**
         * <p>A list of attachments for the part.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "attachments", nulls = Nulls.SKIP)
        public _FinalStage attachments(Optional<List<PartAttachment>> attachments) {
            this.attachments = attachments;
            return this;
        }

        /**
         * <p>The id of the admin that was assigned the conversation by this conversation_part (null if there has been no change in assignment.)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage assignedTo(Reference assignedTo) {
            this.assignedTo = Optional.ofNullable(assignedTo);
            return this;
        }

        /**
         * <p>The id of the admin that was assigned the conversation by this conversation_part (null if there has been no change in assignment.)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "assigned_to", nulls = Nulls.SKIP)
        public _FinalStage assignedTo(Optional<Reference> assignedTo) {
            this.assignedTo = assignedTo;
            return this;
        }

        /**
         * <p>The last time the conversation part was updated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The last time the conversation part was updated.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * <p>The message body, which may contain HTML. For Twitter, this will show a generic message regarding why the body is obscured.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>The message body, which may contain HTML. For Twitter, this will show a generic message regarding why the body is obscured.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @java.lang.Override
        public ConversationPart build() {
            return new ConversationPart(
                    id,
                    partType,
                    body,
                    createdAt,
                    updatedAt,
                    notifiedAt,
                    assignedTo,
                    author,
                    attachments,
                    externalId,
                    redacted,
                    additionalProperties);
        }
    }
}
