/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationRating.Builder.class)
public final class ConversationRating {
    private final int rating;

    private final String remark;

    private final int createdAt;

    private final ContactReference contact;

    private final Reference teammate;

    private final Map<String, Object> additionalProperties;

    private ConversationRating(
            int rating,
            String remark,
            int createdAt,
            ContactReference contact,
            Reference teammate,
            Map<String, Object> additionalProperties) {
        this.rating = rating;
        this.remark = remark;
        this.createdAt = createdAt;
        this.contact = contact;
        this.teammate = teammate;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The rating, between 1 and 5, for the conversation.
     */
    @JsonProperty("rating")
    public int getRating() {
        return rating;
    }

    /**
     * @return An optional field to add a remark to correspond to the number rating
     */
    @JsonProperty("remark")
    public String getRemark() {
        return remark;
    }

    /**
     * @return The time the rating was requested in the conversation being rated.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("contact")
    public ContactReference getContact() {
        return contact;
    }

    @JsonProperty("teammate")
    public Reference getTeammate() {
        return teammate;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationRating && equalTo((ConversationRating) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationRating other) {
        return rating == other.rating
                && remark.equals(other.remark)
                && createdAt == other.createdAt
                && contact.equals(other.contact)
                && teammate.equals(other.teammate);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.rating, this.remark, this.createdAt, this.contact, this.teammate);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RatingStage builder() {
        return new Builder();
    }

    public interface RatingStage {
        /**
         * The rating, between 1 and 5, for the conversation.
         */
        RemarkStage rating(int rating);

        Builder from(ConversationRating other);
    }

    public interface RemarkStage {
        /**
         * An optional field to add a remark to correspond to the number rating
         */
        CreatedAtStage remark(@NotNull String remark);
    }

    public interface CreatedAtStage {
        /**
         * The time the rating was requested in the conversation being rated.
         */
        ContactStage createdAt(int createdAt);
    }

    public interface ContactStage {
        TeammateStage contact(@NotNull ContactReference contact);
    }

    public interface TeammateStage {
        _FinalStage teammate(@NotNull Reference teammate);
    }

    public interface _FinalStage {
        ConversationRating build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements RatingStage, RemarkStage, CreatedAtStage, ContactStage, TeammateStage, _FinalStage {
        private int rating;

        private String remark;

        private int createdAt;

        private ContactReference contact;

        private Reference teammate;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ConversationRating other) {
            rating(other.getRating());
            remark(other.getRemark());
            createdAt(other.getCreatedAt());
            contact(other.getContact());
            teammate(other.getTeammate());
            return this;
        }

        /**
         * The rating, between 1 and 5, for the conversation.<p>The rating, between 1 and 5, for the conversation.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("rating")
        public RemarkStage rating(int rating) {
            this.rating = rating;
            return this;
        }

        /**
         * An optional field to add a remark to correspond to the number rating<p>An optional field to add a remark to correspond to the number rating</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("remark")
        public CreatedAtStage remark(@NotNull String remark) {
            this.remark = Objects.requireNonNull(remark, "remark must not be null");
            return this;
        }

        /**
         * The time the rating was requested in the conversation being rated.<p>The time the rating was requested in the conversation being rated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public ContactStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @java.lang.Override
        @JsonSetter("contact")
        public TeammateStage contact(@NotNull ContactReference contact) {
            this.contact = Objects.requireNonNull(contact, "contact must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("teammate")
        public _FinalStage teammate(@NotNull Reference teammate) {
            this.teammate = Objects.requireNonNull(teammate, "teammate must not be null");
            return this;
        }

        @java.lang.Override
        public ConversationRating build() {
            return new ConversationRating(rating, remark, createdAt, contact, teammate, additionalProperties);
        }
    }
}
