/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public final class CreateMessageRequest {
    private final Value value;

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    private CreateMessageRequest(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return value.visit(visitor);
    }

    public static CreateMessageRequest email(Email value) {
        return new CreateMessageRequest(new EmailValue(value));
    }

    public static CreateMessageRequest inapp(Inapp value) {
        return new CreateMessageRequest(new InappValue(value));
    }

    public boolean isEmail() {
        return value instanceof EmailValue;
    }

    public boolean isInapp() {
        return value instanceof InappValue;
    }

    public boolean _isUnknown() {
        return value instanceof _UnknownValue;
    }

    public Optional<Email> getEmail() {
        if (isEmail()) {
            return Optional.of(((EmailValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<Inapp> getInapp() {
        if (isInapp()) {
            return Optional.of(((InappValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (_isUnknown()) {
            return Optional.of(((_UnknownValue) value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    public interface Visitor<T> {
        T visitEmail(Email email);

        T visitInapp(Inapp inapp);

        T _visitUnknown(Object unknownType);
    }

    @JsonTypeInfo(
            use = JsonTypeInfo.Id.NAME,
            property = "message_type",
            visible = true,
            defaultImpl = _UnknownValue.class)
    @JsonSubTypes({@JsonSubTypes.Type(EmailValue.class), @JsonSubTypes.Type(InappValue.class)})
    @JsonIgnoreProperties(ignoreUnknown = true)
    private interface Value {
        <T> T visit(Visitor<T> visitor);
    }

    @JsonTypeName("email")
    @JsonIgnoreProperties("message_type")
    private static final class EmailValue implements Value {
        @JsonUnwrapped
        private Email value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private EmailValue() {}

        private EmailValue(Email value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitEmail(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof EmailValue && equalTo((EmailValue) other);
        }

        private boolean equalTo(EmailValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "CreateMessageRequest{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("inapp")
    @JsonIgnoreProperties("message_type")
    private static final class InappValue implements Value {
        @JsonUnwrapped
        private Inapp value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private InappValue() {}

        private InappValue(Inapp value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitInapp(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof InappValue && equalTo((InappValue) other);
        }

        private boolean equalTo(InappValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "CreateMessageRequest{" + "value: " + value + "}";
        }
    }

    @JsonIgnoreProperties("message_type")
    private static final class _UnknownValue implements Value {
        private String type;

        @JsonValue
        private Object value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty("value") Object value) {}

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof _UnknownValue && equalTo((_UnknownValue) other);
        }

        private boolean equalTo(_UnknownValue other) {
            return type.equals(other.type) && value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        @java.lang.Override
        public String toString() {
            return "CreateMessageRequest{" + "type: " + type + ", value: " + value + "}";
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Email.Builder.class)
    public static final class Email {
        private final String subject;

        private final String body;

        private final String template;

        private final From from;

        private final To to;

        private final Optional<Integer> createdAt;

        private final Optional<Boolean> createConversationWithoutContactReply;

        private final Map<String, Object> additionalProperties;

        private Email(
                String subject,
                String body,
                String template,
                From from,
                To to,
                Optional<Integer> createdAt,
                Optional<Boolean> createConversationWithoutContactReply,
                Map<String, Object> additionalProperties) {
            this.subject = subject;
            this.body = body;
            this.template = template;
            this.from = from;
            this.to = to;
            this.createdAt = createdAt;
            this.createConversationWithoutContactReply = createConversationWithoutContactReply;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The title of the email.
         */
        @JsonProperty("subject")
        public String getSubject() {
            return subject;
        }

        /**
         * @return The content of the message. HTML and plaintext are supported.
         */
        @JsonProperty("body")
        public String getBody() {
            return body;
        }

        /**
         * @return The style of the outgoing message. Possible values <code>plain</code> or <code>personal</code>.
         */
        @JsonProperty("template")
        public String getTemplate() {
            return template;
        }

        /**
         * @return The sender of the message. If not provided, the default sender will be used.
         */
        @JsonProperty("from")
        public From getFrom() {
            return from;
        }

        /**
         * @return The sender of the message. If not provided, the default sender will be used.
         */
        @JsonProperty("to")
        public To getTo() {
            return to;
        }

        /**
         * @return The time the message was created. If not provided, the current time will be used.
         */
        @JsonProperty("created_at")
        public Optional<Integer> getCreatedAt() {
            return createdAt;
        }

        /**
         * @return Whether a conversation should be opened in the inbox for the message without the contact replying. Defaults to false if not provided.
         */
        @JsonProperty("create_conversation_without_contact_reply")
        public Optional<Boolean> getCreateConversationWithoutContactReply() {
            return createConversationWithoutContactReply;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Email && equalTo((Email) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Email other) {
            return subject.equals(other.subject)
                    && body.equals(other.body)
                    && template.equals(other.template)
                    && from.equals(other.from)
                    && to.equals(other.to)
                    && createdAt.equals(other.createdAt)
                    && createConversationWithoutContactReply.equals(other.createConversationWithoutContactReply);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(
                    this.subject,
                    this.body,
                    this.template,
                    this.from,
                    this.to,
                    this.createdAt,
                    this.createConversationWithoutContactReply);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static SubjectStage builder() {
            return new Builder();
        }

        public interface SubjectStage {
            /**
             * The title of the email.
             */
            BodyStage subject(@NotNull String subject);

            Builder from(Email other);
        }

        public interface BodyStage {
            /**
             * The content of the message. HTML and plaintext are supported.
             */
            TemplateStage body(@NotNull String body);
        }

        public interface TemplateStage {
            /**
             * The style of the outgoing message. Possible values `plain` or `personal`.
             */
            FromStage template(@NotNull String template);
        }

        public interface FromStage {
            /**
             * The sender of the message. If not provided, the default sender will be used.
             */
            ToStage from(@NotNull From from);
        }

        public interface ToStage {
            /**
             * The sender of the message. If not provided, the default sender will be used.
             */
            _FinalStage to(@NotNull To to);
        }

        public interface _FinalStage {
            Email build();

            /**
             * <p>The time the message was created. If not provided, the current time will be used.</p>
             */
            _FinalStage createdAt(Optional<Integer> createdAt);

            _FinalStage createdAt(Integer createdAt);

            /**
             * <p>Whether a conversation should be opened in the inbox for the message without the contact replying. Defaults to false if not provided.</p>
             */
            _FinalStage createConversationWithoutContactReply(Optional<Boolean> createConversationWithoutContactReply);

            _FinalStage createConversationWithoutContactReply(Boolean createConversationWithoutContactReply);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder
                implements SubjectStage, BodyStage, TemplateStage, FromStage, ToStage, _FinalStage {
            private String subject;

            private String body;

            private String template;

            private From from;

            private To to;

            private Optional<Boolean> createConversationWithoutContactReply = Optional.empty();

            private Optional<Integer> createdAt = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(Email other) {
                subject(other.getSubject());
                body(other.getBody());
                template(other.getTemplate());
                from(other.getFrom());
                to(other.getTo());
                createdAt(other.getCreatedAt());
                createConversationWithoutContactReply(other.getCreateConversationWithoutContactReply());
                return this;
            }

            /**
             * The title of the email.<p>The title of the email.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("subject")
            public BodyStage subject(@NotNull String subject) {
                this.subject = Objects.requireNonNull(subject, "subject must not be null");
                return this;
            }

            /**
             * The content of the message. HTML and plaintext are supported.<p>The content of the message. HTML and plaintext are supported.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("body")
            public TemplateStage body(@NotNull String body) {
                this.body = Objects.requireNonNull(body, "body must not be null");
                return this;
            }

            /**
             * The style of the outgoing message. Possible values `plain` or `personal`.<p>The style of the outgoing message. Possible values <code>plain</code> or <code>personal</code>.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("template")
            public FromStage template(@NotNull String template) {
                this.template = Objects.requireNonNull(template, "template must not be null");
                return this;
            }

            /**
             * The sender of the message. If not provided, the default sender will be used.<p>The sender of the message. If not provided, the default sender will be used.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("from")
            public ToStage from(@NotNull From from) {
                this.from = Objects.requireNonNull(from, "from must not be null");
                return this;
            }

            /**
             * The sender of the message. If not provided, the default sender will be used.<p>The sender of the message. If not provided, the default sender will be used.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("to")
            public _FinalStage to(@NotNull To to) {
                this.to = Objects.requireNonNull(to, "to must not be null");
                return this;
            }

            /**
             * <p>Whether a conversation should be opened in the inbox for the message without the contact replying. Defaults to false if not provided.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage createConversationWithoutContactReply(Boolean createConversationWithoutContactReply) {
                this.createConversationWithoutContactReply = Optional.ofNullable(createConversationWithoutContactReply);
                return this;
            }

            /**
             * <p>Whether a conversation should be opened in the inbox for the message without the contact replying. Defaults to false if not provided.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "create_conversation_without_contact_reply", nulls = Nulls.SKIP)
            public _FinalStage createConversationWithoutContactReply(
                    Optional<Boolean> createConversationWithoutContactReply) {
                this.createConversationWithoutContactReply = createConversationWithoutContactReply;
                return this;
            }

            /**
             * <p>The time the message was created. If not provided, the current time will be used.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage createdAt(Integer createdAt) {
                this.createdAt = Optional.ofNullable(createdAt);
                return this;
            }

            /**
             * <p>The time the message was created. If not provided, the current time will be used.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
            public _FinalStage createdAt(Optional<Integer> createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @java.lang.Override
            public Email build() {
                return new Email(
                        subject,
                        body,
                        template,
                        from,
                        to,
                        createdAt,
                        createConversationWithoutContactReply,
                        additionalProperties);
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = From.Builder.class)
        public static final class From {
            private final int id;

            private final Map<String, Object> additionalProperties;

            private From(int id, Map<String, Object> additionalProperties) {
                this.id = id;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return Always <code>admin</code>.
             */
            @JsonProperty("type")
            public String getType() {
                return "admin";
            }

            /**
             * @return The identifier for the admin which is given by Intercom.
             */
            @JsonProperty("id")
            public int getId() {
                return id;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof From && equalTo((From) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(From other) {
                return id == other.id;
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.id);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static IdStage builder() {
                return new Builder();
            }

            public interface IdStage {
                /**
                 * The identifier for the admin which is given by Intercom.
                 */
                _FinalStage id(int id);

                Builder from(From other);
            }

            public interface _FinalStage {
                From build();
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder implements IdStage, _FinalStage {
                private int id;

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                @java.lang.Override
                public Builder from(From other) {
                    id(other.getId());
                    return this;
                }

                /**
                 * The identifier for the admin which is given by Intercom.<p>The identifier for the admin which is given by Intercom.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("id")
                public _FinalStage id(int id) {
                    this.id = id;
                    return this;
                }

                @java.lang.Override
                public From build() {
                    return new From(id, additionalProperties);
                }
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = To.Builder.class)
        public static final class To {
            private final Type type;

            private final String id;

            private final Map<String, Object> additionalProperties;

            private To(Type type, String id, Map<String, Object> additionalProperties) {
                this.type = type;
                this.id = id;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return The role associated to the contact - <code>user</code> or <code>lead</code>.
             */
            @JsonProperty("type")
            public Type getType() {
                return type;
            }

            /**
             * @return The identifier for the contact which is given by Intercom.
             */
            @JsonProperty("id")
            public String getId() {
                return id;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof To && equalTo((To) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(To other) {
                return type.equals(other.type) && id.equals(other.id);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.type, this.id);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static TypeStage builder() {
                return new Builder();
            }

            public interface TypeStage {
                /**
                 * The role associated to the contact - `user` or `lead`.
                 */
                IdStage type(@NotNull Type type);

                Builder from(To other);
            }

            public interface IdStage {
                /**
                 * The identifier for the contact which is given by Intercom.
                 */
                _FinalStage id(@NotNull String id);
            }

            public interface _FinalStage {
                To build();
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder implements TypeStage, IdStage, _FinalStage {
                private Type type;

                private String id;

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                @java.lang.Override
                public Builder from(To other) {
                    type(other.getType());
                    id(other.getId());
                    return this;
                }

                /**
                 * The role associated to the contact - `user` or `lead`.<p>The role associated to the contact - <code>user</code> or <code>lead</code>.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("type")
                public IdStage type(@NotNull Type type) {
                    this.type = Objects.requireNonNull(type, "type must not be null");
                    return this;
                }

                /**
                 * The identifier for the contact which is given by Intercom.<p>The identifier for the contact which is given by Intercom.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("id")
                public _FinalStage id(@NotNull String id) {
                    this.id = Objects.requireNonNull(id, "id must not be null");
                    return this;
                }

                @java.lang.Override
                public To build() {
                    return new To(type, id, additionalProperties);
                }
            }

            public static final class Type {
                public static final Type USER = new Type(Value.USER, "user");

                public static final Type LEAD = new Type(Value.LEAD, "lead");

                private final Value value;

                private final String string;

                Type(Value value, String string) {
                    this.value = value;
                    this.string = string;
                }

                public Value getEnumValue() {
                    return value;
                }

                @java.lang.Override
                @JsonValue
                public String toString() {
                    return this.string;
                }

                @java.lang.Override
                public boolean equals(Object other) {
                    return (this == other) || (other instanceof Type && this.string.equals(((Type) other).string));
                }

                @java.lang.Override
                public int hashCode() {
                    return this.string.hashCode();
                }

                public <T> T visit(Visitor<T> visitor) {
                    switch (value) {
                        case USER:
                            return visitor.visitUser();
                        case LEAD:
                            return visitor.visitLead();
                        case UNKNOWN:
                        default:
                            return visitor.visitUnknown(string);
                    }
                }

                @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
                public static Type valueOf(String value) {
                    switch (value) {
                        case "user":
                            return USER;
                        case "lead":
                            return LEAD;
                        default:
                            return new Type(Value.UNKNOWN, value);
                    }
                }

                public enum Value {
                    USER,

                    LEAD,

                    UNKNOWN
                }

                public interface Visitor<T> {
                    T visitUser();

                    T visitLead();

                    T visitUnknown(String unknownType);
                }
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = Inapp.Builder.class)
    public static final class Inapp {
        private final Optional<String> subject;

        private final String body;

        private final Optional<String> template;

        private final From from;

        private final To to;

        private final Optional<Integer> createdAt;

        private final Optional<Boolean> createConversationWithoutContactReply;

        private final Map<String, Object> additionalProperties;

        private Inapp(
                Optional<String> subject,
                String body,
                Optional<String> template,
                From from,
                To to,
                Optional<Integer> createdAt,
                Optional<Boolean> createConversationWithoutContactReply,
                Map<String, Object> additionalProperties) {
            this.subject = subject;
            this.body = body;
            this.template = template;
            this.from = from;
            this.to = to;
            this.createdAt = createdAt;
            this.createConversationWithoutContactReply = createConversationWithoutContactReply;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The title of the email.
         */
        @JsonProperty("subject")
        public Optional<String> getSubject() {
            return subject;
        }

        /**
         * @return The content of the message. HTML and plaintext are supported.
         */
        @JsonProperty("body")
        public String getBody() {
            return body;
        }

        /**
         * @return The style of the outgoing message. Possible values <code>plain</code> or <code>personal</code>.
         */
        @JsonProperty("template")
        public Optional<String> getTemplate() {
            return template;
        }

        /**
         * @return The sender of the message. If not provided, the default sender will be used.
         */
        @JsonProperty("from")
        public From getFrom() {
            return from;
        }

        /**
         * @return The sender of the message. If not provided, the default sender will be used.
         */
        @JsonProperty("to")
        public To getTo() {
            return to;
        }

        /**
         * @return The time the message was created. If not provided, the current time will be used.
         */
        @JsonProperty("created_at")
        public Optional<Integer> getCreatedAt() {
            return createdAt;
        }

        /**
         * @return Whether a conversation should be opened in the inbox for the message without the contact replying. Defaults to false if not provided.
         */
        @JsonProperty("create_conversation_without_contact_reply")
        public Optional<Boolean> getCreateConversationWithoutContactReply() {
            return createConversationWithoutContactReply;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Inapp && equalTo((Inapp) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Inapp other) {
            return subject.equals(other.subject)
                    && body.equals(other.body)
                    && template.equals(other.template)
                    && from.equals(other.from)
                    && to.equals(other.to)
                    && createdAt.equals(other.createdAt)
                    && createConversationWithoutContactReply.equals(other.createConversationWithoutContactReply);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(
                    this.subject,
                    this.body,
                    this.template,
                    this.from,
                    this.to,
                    this.createdAt,
                    this.createConversationWithoutContactReply);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static BodyStage builder() {
            return new Builder();
        }

        public interface BodyStage {
            /**
             * The content of the message. HTML and plaintext are supported.
             */
            FromStage body(@NotNull String body);

            Builder from(Inapp other);
        }

        public interface FromStage {
            /**
             * The sender of the message. If not provided, the default sender will be used.
             */
            ToStage from(@NotNull From from);
        }

        public interface ToStage {
            /**
             * The sender of the message. If not provided, the default sender will be used.
             */
            _FinalStage to(@NotNull To to);
        }

        public interface _FinalStage {
            Inapp build();

            /**
             * <p>The title of the email.</p>
             */
            _FinalStage subject(Optional<String> subject);

            _FinalStage subject(String subject);

            /**
             * <p>The style of the outgoing message. Possible values <code>plain</code> or <code>personal</code>.</p>
             */
            _FinalStage template(Optional<String> template);

            _FinalStage template(String template);

            /**
             * <p>The time the message was created. If not provided, the current time will be used.</p>
             */
            _FinalStage createdAt(Optional<Integer> createdAt);

            _FinalStage createdAt(Integer createdAt);

            /**
             * <p>Whether a conversation should be opened in the inbox for the message without the contact replying. Defaults to false if not provided.</p>
             */
            _FinalStage createConversationWithoutContactReply(Optional<Boolean> createConversationWithoutContactReply);

            _FinalStage createConversationWithoutContactReply(Boolean createConversationWithoutContactReply);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements BodyStage, FromStage, ToStage, _FinalStage {
            private String body;

            private From from;

            private To to;

            private Optional<Boolean> createConversationWithoutContactReply = Optional.empty();

            private Optional<Integer> createdAt = Optional.empty();

            private Optional<String> template = Optional.empty();

            private Optional<String> subject = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(Inapp other) {
                subject(other.getSubject());
                body(other.getBody());
                template(other.getTemplate());
                from(other.getFrom());
                to(other.getTo());
                createdAt(other.getCreatedAt());
                createConversationWithoutContactReply(other.getCreateConversationWithoutContactReply());
                return this;
            }

            /**
             * The content of the message. HTML and plaintext are supported.<p>The content of the message. HTML and plaintext are supported.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("body")
            public FromStage body(@NotNull String body) {
                this.body = Objects.requireNonNull(body, "body must not be null");
                return this;
            }

            /**
             * The sender of the message. If not provided, the default sender will be used.<p>The sender of the message. If not provided, the default sender will be used.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("from")
            public ToStage from(@NotNull From from) {
                this.from = Objects.requireNonNull(from, "from must not be null");
                return this;
            }

            /**
             * The sender of the message. If not provided, the default sender will be used.<p>The sender of the message. If not provided, the default sender will be used.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("to")
            public _FinalStage to(@NotNull To to) {
                this.to = Objects.requireNonNull(to, "to must not be null");
                return this;
            }

            /**
             * <p>Whether a conversation should be opened in the inbox for the message without the contact replying. Defaults to false if not provided.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage createConversationWithoutContactReply(Boolean createConversationWithoutContactReply) {
                this.createConversationWithoutContactReply = Optional.ofNullable(createConversationWithoutContactReply);
                return this;
            }

            /**
             * <p>Whether a conversation should be opened in the inbox for the message without the contact replying. Defaults to false if not provided.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "create_conversation_without_contact_reply", nulls = Nulls.SKIP)
            public _FinalStage createConversationWithoutContactReply(
                    Optional<Boolean> createConversationWithoutContactReply) {
                this.createConversationWithoutContactReply = createConversationWithoutContactReply;
                return this;
            }

            /**
             * <p>The time the message was created. If not provided, the current time will be used.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage createdAt(Integer createdAt) {
                this.createdAt = Optional.ofNullable(createdAt);
                return this;
            }

            /**
             * <p>The time the message was created. If not provided, the current time will be used.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
            public _FinalStage createdAt(Optional<Integer> createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            /**
             * <p>The style of the outgoing message. Possible values <code>plain</code> or <code>personal</code>.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage template(String template) {
                this.template = Optional.ofNullable(template);
                return this;
            }

            /**
             * <p>The style of the outgoing message. Possible values <code>plain</code> or <code>personal</code>.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "template", nulls = Nulls.SKIP)
            public _FinalStage template(Optional<String> template) {
                this.template = template;
                return this;
            }

            /**
             * <p>The title of the email.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage subject(String subject) {
                this.subject = Optional.ofNullable(subject);
                return this;
            }

            /**
             * <p>The title of the email.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "subject", nulls = Nulls.SKIP)
            public _FinalStage subject(Optional<String> subject) {
                this.subject = subject;
                return this;
            }

            @java.lang.Override
            public Inapp build() {
                return new Inapp(
                        subject,
                        body,
                        template,
                        from,
                        to,
                        createdAt,
                        createConversationWithoutContactReply,
                        additionalProperties);
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = From.Builder.class)
        public static final class From {
            private final int id;

            private final Map<String, Object> additionalProperties;

            private From(int id, Map<String, Object> additionalProperties) {
                this.id = id;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return Always <code>admin</code>.
             */
            @JsonProperty("type")
            public String getType() {
                return "admin";
            }

            /**
             * @return The identifier for the admin which is given by Intercom.
             */
            @JsonProperty("id")
            public int getId() {
                return id;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof From && equalTo((From) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(From other) {
                return id == other.id;
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.id);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static IdStage builder() {
                return new Builder();
            }

            public interface IdStage {
                /**
                 * The identifier for the admin which is given by Intercom.
                 */
                _FinalStage id(int id);

                Builder from(From other);
            }

            public interface _FinalStage {
                From build();
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder implements IdStage, _FinalStage {
                private int id;

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                @java.lang.Override
                public Builder from(From other) {
                    id(other.getId());
                    return this;
                }

                /**
                 * The identifier for the admin which is given by Intercom.<p>The identifier for the admin which is given by Intercom.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("id")
                public _FinalStage id(int id) {
                    this.id = id;
                    return this;
                }

                @java.lang.Override
                public From build() {
                    return new From(id, additionalProperties);
                }
            }
        }

        @JsonInclude(JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder = To.Builder.class)
        public static final class To {
            private final Type type;

            private final String id;

            private final Map<String, Object> additionalProperties;

            private To(Type type, String id, Map<String, Object> additionalProperties) {
                this.type = type;
                this.id = id;
                this.additionalProperties = additionalProperties;
            }

            /**
             * @return The role associated to the contact - <code>user</code> or <code>lead</code>.
             */
            @JsonProperty("type")
            public Type getType() {
                return type;
            }

            /**
             * @return The identifier for the contact which is given by Intercom.
             */
            @JsonProperty("id")
            public String getId() {
                return id;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                if (this == other) return true;
                return other instanceof To && equalTo((To) other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(To other) {
                return type.equals(other.type) && id.equals(other.id);
            }

            @java.lang.Override
            public int hashCode() {
                return Objects.hash(this.type, this.id);
            }

            @java.lang.Override
            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static TypeStage builder() {
                return new Builder();
            }

            public interface TypeStage {
                /**
                 * The role associated to the contact - `user` or `lead`.
                 */
                IdStage type(@NotNull Type type);

                Builder from(To other);
            }

            public interface IdStage {
                /**
                 * The identifier for the contact which is given by Intercom.
                 */
                _FinalStage id(@NotNull String id);
            }

            public interface _FinalStage {
                To build();
            }

            @JsonIgnoreProperties(ignoreUnknown = true)
            public static final class Builder implements TypeStage, IdStage, _FinalStage {
                private Type type;

                private String id;

                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<>();

                private Builder() {}

                @java.lang.Override
                public Builder from(To other) {
                    type(other.getType());
                    id(other.getId());
                    return this;
                }

                /**
                 * The role associated to the contact - `user` or `lead`.<p>The role associated to the contact - <code>user</code> or <code>lead</code>.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("type")
                public IdStage type(@NotNull Type type) {
                    this.type = Objects.requireNonNull(type, "type must not be null");
                    return this;
                }

                /**
                 * The identifier for the contact which is given by Intercom.<p>The identifier for the contact which is given by Intercom.</p>
                 * @return Reference to {@code this} so that method calls can be chained together.
                 */
                @java.lang.Override
                @JsonSetter("id")
                public _FinalStage id(@NotNull String id) {
                    this.id = Objects.requireNonNull(id, "id must not be null");
                    return this;
                }

                @java.lang.Override
                public To build() {
                    return new To(type, id, additionalProperties);
                }
            }

            public static final class Type {
                public static final Type USER = new Type(Value.USER, "user");

                public static final Type LEAD = new Type(Value.LEAD, "lead");

                private final Value value;

                private final String string;

                Type(Value value, String string) {
                    this.value = value;
                    this.string = string;
                }

                public Value getEnumValue() {
                    return value;
                }

                @java.lang.Override
                @JsonValue
                public String toString() {
                    return this.string;
                }

                @java.lang.Override
                public boolean equals(Object other) {
                    return (this == other) || (other instanceof Type && this.string.equals(((Type) other).string));
                }

                @java.lang.Override
                public int hashCode() {
                    return this.string.hashCode();
                }

                public <T> T visit(Visitor<T> visitor) {
                    switch (value) {
                        case USER:
                            return visitor.visitUser();
                        case LEAD:
                            return visitor.visitLead();
                        case UNKNOWN:
                        default:
                            return visitor.visitUnknown(string);
                    }
                }

                @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
                public static Type valueOf(String value) {
                    switch (value) {
                        case "user":
                            return USER;
                        case "lead":
                            return LEAD;
                        default:
                            return new Type(Value.UNKNOWN, value);
                    }
                }

                public enum Value {
                    USER,

                    LEAD,

                    UNKNOWN
                }

                public interface Visitor<T> {
                    T visitUser();

                    T visitLead();

                    T visitUnknown(String unknownType);
                }
            }
        }
    }
}
