/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DataExportCsv.Builder.class)
public final class DataExportCsv {
    private final String userId;

    private final Optional<String> userExternalId;

    private final String companyId;

    private final String email;

    private final String name;

    private final String rulesetId;

    private final String contentId;

    private final String contentType;

    private final String contentTitle;

    private final Optional<String> rulesetVersionId;

    private final Optional<String> receiptId;

    private final Optional<Integer> receivedAt;

    private final Optional<String> seriesId;

    private final Optional<String> seriesTitle;

    private final Optional<String> nodeId;

    private final Optional<Integer> firstReply;

    private final Optional<Integer> firstCompletion;

    private final Optional<Integer> firstSeriesCompletion;

    private final Optional<Integer> firstSeriesDisengagement;

    private final Optional<Integer> firstSeriesExit;

    private final Optional<Integer> firstGoalSuccess;

    private final Optional<Integer> firstOpen;

    private final Optional<Integer> firstClick;

    private final Optional<Integer> firstDismisall;

    private final Optional<Integer> firstUnsubscribe;

    private final Optional<Integer> firstHardBounce;

    private final Map<String, Object> additionalProperties;

    private DataExportCsv(
            String userId,
            Optional<String> userExternalId,
            String companyId,
            String email,
            String name,
            String rulesetId,
            String contentId,
            String contentType,
            String contentTitle,
            Optional<String> rulesetVersionId,
            Optional<String> receiptId,
            Optional<Integer> receivedAt,
            Optional<String> seriesId,
            Optional<String> seriesTitle,
            Optional<String> nodeId,
            Optional<Integer> firstReply,
            Optional<Integer> firstCompletion,
            Optional<Integer> firstSeriesCompletion,
            Optional<Integer> firstSeriesDisengagement,
            Optional<Integer> firstSeriesExit,
            Optional<Integer> firstGoalSuccess,
            Optional<Integer> firstOpen,
            Optional<Integer> firstClick,
            Optional<Integer> firstDismisall,
            Optional<Integer> firstUnsubscribe,
            Optional<Integer> firstHardBounce,
            Map<String, Object> additionalProperties) {
        this.userId = userId;
        this.userExternalId = userExternalId;
        this.companyId = companyId;
        this.email = email;
        this.name = name;
        this.rulesetId = rulesetId;
        this.contentId = contentId;
        this.contentType = contentType;
        this.contentTitle = contentTitle;
        this.rulesetVersionId = rulesetVersionId;
        this.receiptId = receiptId;
        this.receivedAt = receivedAt;
        this.seriesId = seriesId;
        this.seriesTitle = seriesTitle;
        this.nodeId = nodeId;
        this.firstReply = firstReply;
        this.firstCompletion = firstCompletion;
        this.firstSeriesCompletion = firstSeriesCompletion;
        this.firstSeriesDisengagement = firstSeriesDisengagement;
        this.firstSeriesExit = firstSeriesExit;
        this.firstGoalSuccess = firstGoalSuccess;
        this.firstOpen = firstOpen;
        this.firstClick = firstClick;
        this.firstDismisall = firstDismisall;
        this.firstUnsubscribe = firstUnsubscribe;
        this.firstHardBounce = firstHardBounce;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The user_id of the user who was sent the message.
     */
    @JsonProperty("user_id")
    public String getUserId() {
        return userId;
    }

    /**
     * @return The external_user_id of the user who was sent the message
     */
    @JsonProperty("user_external_id")
    public Optional<String> getUserExternalId() {
        return userExternalId;
    }

    /**
     * @return The company ID of the user in relation to the message that was sent. Will return -1 if no company is present.
     */
    @JsonProperty("company_id")
    public String getCompanyId() {
        return companyId;
    }

    /**
     * @return The users email who was sent the message.
     */
    @JsonProperty("email")
    public String getEmail() {
        return email;
    }

    /**
     * @return The full name of the user receiving the message
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The id of the message.
     */
    @JsonProperty("ruleset_id")
    public String getRulesetId() {
        return rulesetId;
    }

    /**
     * @return The specific content that was received. In an A/B test each version has its own Content ID.
     */
    @JsonProperty("content_id")
    public String getContentId() {
        return contentId;
    }

    /**
     * @return Email, Chat, Post etc.
     */
    @JsonProperty("content_type")
    public String getContentType() {
        return contentType;
    }

    /**
     * @return The title of the content you see in your Intercom workspace.
     */
    @JsonProperty("content_title")
    public String getContentTitle() {
        return contentTitle;
    }

    /**
     * @return As you edit content we record new versions. This ID can help you determine which version of a piece of content that was received.
     */
    @JsonProperty("ruleset_version_id")
    public Optional<String> getRulesetVersionId() {
        return rulesetVersionId;
    }

    /**
     * @return ID for this receipt. Will be included with any related stats in other files to identify this specific delivery of a message.
     */
    @JsonProperty("receipt_id")
    public Optional<String> getReceiptId() {
        return receiptId;
    }

    /**
     * @return Timestamp for when the receipt was recorded.
     */
    @JsonProperty("received_at")
    public Optional<Integer> getReceivedAt() {
        return receivedAt;
    }

    /**
     * @return The id of the series that this content is part of. Will return -1 if not part of a series.
     */
    @JsonProperty("series_id")
    public Optional<String> getSeriesId() {
        return seriesId;
    }

    /**
     * @return The title of the series that this content is part of.
     */
    @JsonProperty("series_title")
    public Optional<String> getSeriesTitle() {
        return seriesTitle;
    }

    /**
     * @return The id of the series node that this ruleset is associated with. Each block in a series has a corresponding node_id.
     */
    @JsonProperty("node_id")
    public Optional<String> getNodeId() {
        return nodeId;
    }

    /**
     * @return The first time a user replied to this message if the content was able to receive replies.
     */
    @JsonProperty("first_reply")
    public Optional<Integer> getFirstReply() {
        return firstReply;
    }

    /**
     * @return The first time a user completed this message if the content was able to be completed e.g. Tours, Surveys.
     */
    @JsonProperty("first_completion")
    public Optional<Integer> getFirstCompletion() {
        return firstCompletion;
    }

    /**
     * @return The first time the series this message was a part of was completed by the user.
     */
    @JsonProperty("first_series_completion")
    public Optional<Integer> getFirstSeriesCompletion() {
        return firstSeriesCompletion;
    }

    /**
     * @return The first time the series this message was a part of was disengaged by the user.
     */
    @JsonProperty("first_series_disengagement")
    public Optional<Integer> getFirstSeriesDisengagement() {
        return firstSeriesDisengagement;
    }

    /**
     * @return The first time the series this message was a part of was exited by the user.
     */
    @JsonProperty("first_series_exit")
    public Optional<Integer> getFirstSeriesExit() {
        return firstSeriesExit;
    }

    /**
     * @return The first time the user met this messages associated goal if one exists.
     */
    @JsonProperty("first_goal_success")
    public Optional<Integer> getFirstGoalSuccess() {
        return firstGoalSuccess;
    }

    /**
     * @return The first time the user opened this message.
     */
    @JsonProperty("first_open")
    public Optional<Integer> getFirstOpen() {
        return firstOpen;
    }

    /**
     * @return The first time the series the user clicked on a link within this message.
     */
    @JsonProperty("first_click")
    public Optional<Integer> getFirstClick() {
        return firstClick;
    }

    /**
     * @return The first time the series the user dismissed this message.
     */
    @JsonProperty("first_dismisall")
    public Optional<Integer> getFirstDismisall() {
        return firstDismisall;
    }

    /**
     * @return The first time the user unsubscribed from this message.
     */
    @JsonProperty("first_unsubscribe")
    public Optional<Integer> getFirstUnsubscribe() {
        return firstUnsubscribe;
    }

    /**
     * @return The first time this message hard bounced for this user
     */
    @JsonProperty("first_hard_bounce")
    public Optional<Integer> getFirstHardBounce() {
        return firstHardBounce;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DataExportCsv && equalTo((DataExportCsv) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataExportCsv other) {
        return userId.equals(other.userId)
                && userExternalId.equals(other.userExternalId)
                && companyId.equals(other.companyId)
                && email.equals(other.email)
                && name.equals(other.name)
                && rulesetId.equals(other.rulesetId)
                && contentId.equals(other.contentId)
                && contentType.equals(other.contentType)
                && contentTitle.equals(other.contentTitle)
                && rulesetVersionId.equals(other.rulesetVersionId)
                && receiptId.equals(other.receiptId)
                && receivedAt.equals(other.receivedAt)
                && seriesId.equals(other.seriesId)
                && seriesTitle.equals(other.seriesTitle)
                && nodeId.equals(other.nodeId)
                && firstReply.equals(other.firstReply)
                && firstCompletion.equals(other.firstCompletion)
                && firstSeriesCompletion.equals(other.firstSeriesCompletion)
                && firstSeriesDisengagement.equals(other.firstSeriesDisengagement)
                && firstSeriesExit.equals(other.firstSeriesExit)
                && firstGoalSuccess.equals(other.firstGoalSuccess)
                && firstOpen.equals(other.firstOpen)
                && firstClick.equals(other.firstClick)
                && firstDismisall.equals(other.firstDismisall)
                && firstUnsubscribe.equals(other.firstUnsubscribe)
                && firstHardBounce.equals(other.firstHardBounce);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.userId,
                this.userExternalId,
                this.companyId,
                this.email,
                this.name,
                this.rulesetId,
                this.contentId,
                this.contentType,
                this.contentTitle,
                this.rulesetVersionId,
                this.receiptId,
                this.receivedAt,
                this.seriesId,
                this.seriesTitle,
                this.nodeId,
                this.firstReply,
                this.firstCompletion,
                this.firstSeriesCompletion,
                this.firstSeriesDisengagement,
                this.firstSeriesExit,
                this.firstGoalSuccess,
                this.firstOpen,
                this.firstClick,
                this.firstDismisall,
                this.firstUnsubscribe,
                this.firstHardBounce);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UserIdStage builder() {
        return new Builder();
    }

    public interface UserIdStage {
        /**
         * The user_id of the user who was sent the message.
         */
        CompanyIdStage userId(@NotNull String userId);

        Builder from(DataExportCsv other);
    }

    public interface CompanyIdStage {
        /**
         * The company ID of the user in relation to the message that was sent. Will return -1 if no company is present.
         */
        EmailStage companyId(@NotNull String companyId);
    }

    public interface EmailStage {
        /**
         * The users email who was sent the message.
         */
        NameStage email(@NotNull String email);
    }

    public interface NameStage {
        /**
         * The full name of the user receiving the message
         */
        RulesetIdStage name(@NotNull String name);
    }

    public interface RulesetIdStage {
        /**
         * The id of the message.
         */
        ContentIdStage rulesetId(@NotNull String rulesetId);
    }

    public interface ContentIdStage {
        /**
         * The specific content that was received. In an A/B test each version has its own Content ID.
         */
        ContentTypeStage contentId(@NotNull String contentId);
    }

    public interface ContentTypeStage {
        /**
         * Email, Chat, Post etc.
         */
        ContentTitleStage contentType(@NotNull String contentType);
    }

    public interface ContentTitleStage {
        /**
         * The title of the content you see in your Intercom workspace.
         */
        _FinalStage contentTitle(@NotNull String contentTitle);
    }

    public interface _FinalStage {
        DataExportCsv build();

        /**
         * <p>The external_user_id of the user who was sent the message</p>
         */
        _FinalStage userExternalId(Optional<String> userExternalId);

        _FinalStage userExternalId(String userExternalId);

        /**
         * <p>As you edit content we record new versions. This ID can help you determine which version of a piece of content that was received.</p>
         */
        _FinalStage rulesetVersionId(Optional<String> rulesetVersionId);

        _FinalStage rulesetVersionId(String rulesetVersionId);

        /**
         * <p>ID for this receipt. Will be included with any related stats in other files to identify this specific delivery of a message.</p>
         */
        _FinalStage receiptId(Optional<String> receiptId);

        _FinalStage receiptId(String receiptId);

        /**
         * <p>Timestamp for when the receipt was recorded.</p>
         */
        _FinalStage receivedAt(Optional<Integer> receivedAt);

        _FinalStage receivedAt(Integer receivedAt);

        /**
         * <p>The id of the series that this content is part of. Will return -1 if not part of a series.</p>
         */
        _FinalStage seriesId(Optional<String> seriesId);

        _FinalStage seriesId(String seriesId);

        /**
         * <p>The title of the series that this content is part of.</p>
         */
        _FinalStage seriesTitle(Optional<String> seriesTitle);

        _FinalStage seriesTitle(String seriesTitle);

        /**
         * <p>The id of the series node that this ruleset is associated with. Each block in a series has a corresponding node_id.</p>
         */
        _FinalStage nodeId(Optional<String> nodeId);

        _FinalStage nodeId(String nodeId);

        /**
         * <p>The first time a user replied to this message if the content was able to receive replies.</p>
         */
        _FinalStage firstReply(Optional<Integer> firstReply);

        _FinalStage firstReply(Integer firstReply);

        /**
         * <p>The first time a user completed this message if the content was able to be completed e.g. Tours, Surveys.</p>
         */
        _FinalStage firstCompletion(Optional<Integer> firstCompletion);

        _FinalStage firstCompletion(Integer firstCompletion);

        /**
         * <p>The first time the series this message was a part of was completed by the user.</p>
         */
        _FinalStage firstSeriesCompletion(Optional<Integer> firstSeriesCompletion);

        _FinalStage firstSeriesCompletion(Integer firstSeriesCompletion);

        /**
         * <p>The first time the series this message was a part of was disengaged by the user.</p>
         */
        _FinalStage firstSeriesDisengagement(Optional<Integer> firstSeriesDisengagement);

        _FinalStage firstSeriesDisengagement(Integer firstSeriesDisengagement);

        /**
         * <p>The first time the series this message was a part of was exited by the user.</p>
         */
        _FinalStage firstSeriesExit(Optional<Integer> firstSeriesExit);

        _FinalStage firstSeriesExit(Integer firstSeriesExit);

        /**
         * <p>The first time the user met this messages associated goal if one exists.</p>
         */
        _FinalStage firstGoalSuccess(Optional<Integer> firstGoalSuccess);

        _FinalStage firstGoalSuccess(Integer firstGoalSuccess);

        /**
         * <p>The first time the user opened this message.</p>
         */
        _FinalStage firstOpen(Optional<Integer> firstOpen);

        _FinalStage firstOpen(Integer firstOpen);

        /**
         * <p>The first time the series the user clicked on a link within this message.</p>
         */
        _FinalStage firstClick(Optional<Integer> firstClick);

        _FinalStage firstClick(Integer firstClick);

        /**
         * <p>The first time the series the user dismissed this message.</p>
         */
        _FinalStage firstDismisall(Optional<Integer> firstDismisall);

        _FinalStage firstDismisall(Integer firstDismisall);

        /**
         * <p>The first time the user unsubscribed from this message.</p>
         */
        _FinalStage firstUnsubscribe(Optional<Integer> firstUnsubscribe);

        _FinalStage firstUnsubscribe(Integer firstUnsubscribe);

        /**
         * <p>The first time this message hard bounced for this user</p>
         */
        _FinalStage firstHardBounce(Optional<Integer> firstHardBounce);

        _FinalStage firstHardBounce(Integer firstHardBounce);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements UserIdStage,
                    CompanyIdStage,
                    EmailStage,
                    NameStage,
                    RulesetIdStage,
                    ContentIdStage,
                    ContentTypeStage,
                    ContentTitleStage,
                    _FinalStage {
        private String userId;

        private String companyId;

        private String email;

        private String name;

        private String rulesetId;

        private String contentId;

        private String contentType;

        private String contentTitle;

        private Optional<Integer> firstHardBounce = Optional.empty();

        private Optional<Integer> firstUnsubscribe = Optional.empty();

        private Optional<Integer> firstDismisall = Optional.empty();

        private Optional<Integer> firstClick = Optional.empty();

        private Optional<Integer> firstOpen = Optional.empty();

        private Optional<Integer> firstGoalSuccess = Optional.empty();

        private Optional<Integer> firstSeriesExit = Optional.empty();

        private Optional<Integer> firstSeriesDisengagement = Optional.empty();

        private Optional<Integer> firstSeriesCompletion = Optional.empty();

        private Optional<Integer> firstCompletion = Optional.empty();

        private Optional<Integer> firstReply = Optional.empty();

        private Optional<String> nodeId = Optional.empty();

        private Optional<String> seriesTitle = Optional.empty();

        private Optional<String> seriesId = Optional.empty();

        private Optional<Integer> receivedAt = Optional.empty();

        private Optional<String> receiptId = Optional.empty();

        private Optional<String> rulesetVersionId = Optional.empty();

        private Optional<String> userExternalId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DataExportCsv other) {
            userId(other.getUserId());
            userExternalId(other.getUserExternalId());
            companyId(other.getCompanyId());
            email(other.getEmail());
            name(other.getName());
            rulesetId(other.getRulesetId());
            contentId(other.getContentId());
            contentType(other.getContentType());
            contentTitle(other.getContentTitle());
            rulesetVersionId(other.getRulesetVersionId());
            receiptId(other.getReceiptId());
            receivedAt(other.getReceivedAt());
            seriesId(other.getSeriesId());
            seriesTitle(other.getSeriesTitle());
            nodeId(other.getNodeId());
            firstReply(other.getFirstReply());
            firstCompletion(other.getFirstCompletion());
            firstSeriesCompletion(other.getFirstSeriesCompletion());
            firstSeriesDisengagement(other.getFirstSeriesDisengagement());
            firstSeriesExit(other.getFirstSeriesExit());
            firstGoalSuccess(other.getFirstGoalSuccess());
            firstOpen(other.getFirstOpen());
            firstClick(other.getFirstClick());
            firstDismisall(other.getFirstDismisall());
            firstUnsubscribe(other.getFirstUnsubscribe());
            firstHardBounce(other.getFirstHardBounce());
            return this;
        }

        /**
         * The user_id of the user who was sent the message.<p>The user_id of the user who was sent the message.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("user_id")
        public CompanyIdStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        /**
         * The company ID of the user in relation to the message that was sent. Will return -1 if no company is present.<p>The company ID of the user in relation to the message that was sent. Will return -1 if no company is present.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("company_id")
        public EmailStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        /**
         * The users email who was sent the message.<p>The users email who was sent the message.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("email")
        public NameStage email(@NotNull String email) {
            this.email = Objects.requireNonNull(email, "email must not be null");
            return this;
        }

        /**
         * The full name of the user receiving the message<p>The full name of the user receiving the message</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public RulesetIdStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * The id of the message.<p>The id of the message.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("ruleset_id")
        public ContentIdStage rulesetId(@NotNull String rulesetId) {
            this.rulesetId = Objects.requireNonNull(rulesetId, "rulesetId must not be null");
            return this;
        }

        /**
         * The specific content that was received. In an A/B test each version has its own Content ID.<p>The specific content that was received. In an A/B test each version has its own Content ID.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("content_id")
        public ContentTypeStage contentId(@NotNull String contentId) {
            this.contentId = Objects.requireNonNull(contentId, "contentId must not be null");
            return this;
        }

        /**
         * Email, Chat, Post etc.<p>Email, Chat, Post etc.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("content_type")
        public ContentTitleStage contentType(@NotNull String contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType must not be null");
            return this;
        }

        /**
         * The title of the content you see in your Intercom workspace.<p>The title of the content you see in your Intercom workspace.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("content_title")
        public _FinalStage contentTitle(@NotNull String contentTitle) {
            this.contentTitle = Objects.requireNonNull(contentTitle, "contentTitle must not be null");
            return this;
        }

        /**
         * <p>The first time this message hard bounced for this user</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage firstHardBounce(Integer firstHardBounce) {
            this.firstHardBounce = Optional.ofNullable(firstHardBounce);
            return this;
        }

        /**
         * <p>The first time this message hard bounced for this user</p>
         */
        @java.lang.Override
        @JsonSetter(value = "first_hard_bounce", nulls = Nulls.SKIP)
        public _FinalStage firstHardBounce(Optional<Integer> firstHardBounce) {
            this.firstHardBounce = firstHardBounce;
            return this;
        }

        /**
         * <p>The first time the user unsubscribed from this message.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage firstUnsubscribe(Integer firstUnsubscribe) {
            this.firstUnsubscribe = Optional.ofNullable(firstUnsubscribe);
            return this;
        }

        /**
         * <p>The first time the user unsubscribed from this message.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "first_unsubscribe", nulls = Nulls.SKIP)
        public _FinalStage firstUnsubscribe(Optional<Integer> firstUnsubscribe) {
            this.firstUnsubscribe = firstUnsubscribe;
            return this;
        }

        /**
         * <p>The first time the series the user dismissed this message.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage firstDismisall(Integer firstDismisall) {
            this.firstDismisall = Optional.ofNullable(firstDismisall);
            return this;
        }

        /**
         * <p>The first time the series the user dismissed this message.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "first_dismisall", nulls = Nulls.SKIP)
        public _FinalStage firstDismisall(Optional<Integer> firstDismisall) {
            this.firstDismisall = firstDismisall;
            return this;
        }

        /**
         * <p>The first time the series the user clicked on a link within this message.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage firstClick(Integer firstClick) {
            this.firstClick = Optional.ofNullable(firstClick);
            return this;
        }

        /**
         * <p>The first time the series the user clicked on a link within this message.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "first_click", nulls = Nulls.SKIP)
        public _FinalStage firstClick(Optional<Integer> firstClick) {
            this.firstClick = firstClick;
            return this;
        }

        /**
         * <p>The first time the user opened this message.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage firstOpen(Integer firstOpen) {
            this.firstOpen = Optional.ofNullable(firstOpen);
            return this;
        }

        /**
         * <p>The first time the user opened this message.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "first_open", nulls = Nulls.SKIP)
        public _FinalStage firstOpen(Optional<Integer> firstOpen) {
            this.firstOpen = firstOpen;
            return this;
        }

        /**
         * <p>The first time the user met this messages associated goal if one exists.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage firstGoalSuccess(Integer firstGoalSuccess) {
            this.firstGoalSuccess = Optional.ofNullable(firstGoalSuccess);
            return this;
        }

        /**
         * <p>The first time the user met this messages associated goal if one exists.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "first_goal_success", nulls = Nulls.SKIP)
        public _FinalStage firstGoalSuccess(Optional<Integer> firstGoalSuccess) {
            this.firstGoalSuccess = firstGoalSuccess;
            return this;
        }

        /**
         * <p>The first time the series this message was a part of was exited by the user.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage firstSeriesExit(Integer firstSeriesExit) {
            this.firstSeriesExit = Optional.ofNullable(firstSeriesExit);
            return this;
        }

        /**
         * <p>The first time the series this message was a part of was exited by the user.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "first_series_exit", nulls = Nulls.SKIP)
        public _FinalStage firstSeriesExit(Optional<Integer> firstSeriesExit) {
            this.firstSeriesExit = firstSeriesExit;
            return this;
        }

        /**
         * <p>The first time the series this message was a part of was disengaged by the user.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage firstSeriesDisengagement(Integer firstSeriesDisengagement) {
            this.firstSeriesDisengagement = Optional.ofNullable(firstSeriesDisengagement);
            return this;
        }

        /**
         * <p>The first time the series this message was a part of was disengaged by the user.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "first_series_disengagement", nulls = Nulls.SKIP)
        public _FinalStage firstSeriesDisengagement(Optional<Integer> firstSeriesDisengagement) {
            this.firstSeriesDisengagement = firstSeriesDisengagement;
            return this;
        }

        /**
         * <p>The first time the series this message was a part of was completed by the user.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage firstSeriesCompletion(Integer firstSeriesCompletion) {
            this.firstSeriesCompletion = Optional.ofNullable(firstSeriesCompletion);
            return this;
        }

        /**
         * <p>The first time the series this message was a part of was completed by the user.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "first_series_completion", nulls = Nulls.SKIP)
        public _FinalStage firstSeriesCompletion(Optional<Integer> firstSeriesCompletion) {
            this.firstSeriesCompletion = firstSeriesCompletion;
            return this;
        }

        /**
         * <p>The first time a user completed this message if the content was able to be completed e.g. Tours, Surveys.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage firstCompletion(Integer firstCompletion) {
            this.firstCompletion = Optional.ofNullable(firstCompletion);
            return this;
        }

        /**
         * <p>The first time a user completed this message if the content was able to be completed e.g. Tours, Surveys.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "first_completion", nulls = Nulls.SKIP)
        public _FinalStage firstCompletion(Optional<Integer> firstCompletion) {
            this.firstCompletion = firstCompletion;
            return this;
        }

        /**
         * <p>The first time a user replied to this message if the content was able to receive replies.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage firstReply(Integer firstReply) {
            this.firstReply = Optional.ofNullable(firstReply);
            return this;
        }

        /**
         * <p>The first time a user replied to this message if the content was able to receive replies.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "first_reply", nulls = Nulls.SKIP)
        public _FinalStage firstReply(Optional<Integer> firstReply) {
            this.firstReply = firstReply;
            return this;
        }

        /**
         * <p>The id of the series node that this ruleset is associated with. Each block in a series has a corresponding node_id.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage nodeId(String nodeId) {
            this.nodeId = Optional.ofNullable(nodeId);
            return this;
        }

        /**
         * <p>The id of the series node that this ruleset is associated with. Each block in a series has a corresponding node_id.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "node_id", nulls = Nulls.SKIP)
        public _FinalStage nodeId(Optional<String> nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        /**
         * <p>The title of the series that this content is part of.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage seriesTitle(String seriesTitle) {
            this.seriesTitle = Optional.ofNullable(seriesTitle);
            return this;
        }

        /**
         * <p>The title of the series that this content is part of.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "series_title", nulls = Nulls.SKIP)
        public _FinalStage seriesTitle(Optional<String> seriesTitle) {
            this.seriesTitle = seriesTitle;
            return this;
        }

        /**
         * <p>The id of the series that this content is part of. Will return -1 if not part of a series.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage seriesId(String seriesId) {
            this.seriesId = Optional.ofNullable(seriesId);
            return this;
        }

        /**
         * <p>The id of the series that this content is part of. Will return -1 if not part of a series.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "series_id", nulls = Nulls.SKIP)
        public _FinalStage seriesId(Optional<String> seriesId) {
            this.seriesId = seriesId;
            return this;
        }

        /**
         * <p>Timestamp for when the receipt was recorded.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage receivedAt(Integer receivedAt) {
            this.receivedAt = Optional.ofNullable(receivedAt);
            return this;
        }

        /**
         * <p>Timestamp for when the receipt was recorded.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "received_at", nulls = Nulls.SKIP)
        public _FinalStage receivedAt(Optional<Integer> receivedAt) {
            this.receivedAt = receivedAt;
            return this;
        }

        /**
         * <p>ID for this receipt. Will be included with any related stats in other files to identify this specific delivery of a message.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage receiptId(String receiptId) {
            this.receiptId = Optional.ofNullable(receiptId);
            return this;
        }

        /**
         * <p>ID for this receipt. Will be included with any related stats in other files to identify this specific delivery of a message.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "receipt_id", nulls = Nulls.SKIP)
        public _FinalStage receiptId(Optional<String> receiptId) {
            this.receiptId = receiptId;
            return this;
        }

        /**
         * <p>As you edit content we record new versions. This ID can help you determine which version of a piece of content that was received.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage rulesetVersionId(String rulesetVersionId) {
            this.rulesetVersionId = Optional.ofNullable(rulesetVersionId);
            return this;
        }

        /**
         * <p>As you edit content we record new versions. This ID can help you determine which version of a piece of content that was received.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "ruleset_version_id", nulls = Nulls.SKIP)
        public _FinalStage rulesetVersionId(Optional<String> rulesetVersionId) {
            this.rulesetVersionId = rulesetVersionId;
            return this;
        }

        /**
         * <p>The external_user_id of the user who was sent the message</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage userExternalId(String userExternalId) {
            this.userExternalId = Optional.ofNullable(userExternalId);
            return this;
        }

        /**
         * <p>The external_user_id of the user who was sent the message</p>
         */
        @java.lang.Override
        @JsonSetter(value = "user_external_id", nulls = Nulls.SKIP)
        public _FinalStage userExternalId(Optional<String> userExternalId) {
            this.userExternalId = userExternalId;
            return this;
        }

        @java.lang.Override
        public DataExportCsv build() {
            return new DataExportCsv(
                    userId,
                    userExternalId,
                    companyId,
                    email,
                    name,
                    rulesetId,
                    contentId,
                    contentType,
                    contentTitle,
                    rulesetVersionId,
                    receiptId,
                    receivedAt,
                    seriesId,
                    seriesTitle,
                    nodeId,
                    firstReply,
                    firstCompletion,
                    firstSeriesCompletion,
                    firstSeriesDisengagement,
                    firstSeriesExit,
                    firstGoalSuccess,
                    firstOpen,
                    firstClick,
                    firstDismisall,
                    firstUnsubscribe,
                    firstHardBounce,
                    additionalProperties);
        }
    }
}
