/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DeletedCompanyObject.Builder.class)
public final class DeletedCompanyObject {
    private final String id;

    private final boolean deleted;

    private final Map<String, Object> additionalProperties;

    private DeletedCompanyObject(String id, boolean deleted, Map<String, Object> additionalProperties) {
        this.id = id;
        this.deleted = deleted;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the company which is given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The type of object which was deleted. - <code>company</code>
     */
    @JsonProperty("object")
    public String getObject() {
        return "company";
    }

    /**
     * @return Whether the company was deleted successfully or not.
     */
    @JsonProperty("deleted")
    public boolean getDeleted() {
        return deleted;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DeletedCompanyObject && equalTo((DeletedCompanyObject) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeletedCompanyObject other) {
        return id.equals(other.id) && deleted == other.deleted;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.deleted);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The unique identifier for the company which is given by Intercom.
         */
        DeletedStage id(@NotNull String id);

        Builder from(DeletedCompanyObject other);
    }

    public interface DeletedStage {
        /**
         * Whether the company was deleted successfully or not.
         */
        _FinalStage deleted(boolean deleted);
    }

    public interface _FinalStage {
        DeletedCompanyObject build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, DeletedStage, _FinalStage {
        private String id;

        private boolean deleted;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DeletedCompanyObject other) {
            id(other.getId());
            deleted(other.getDeleted());
            return this;
        }

        /**
         * The unique identifier for the company which is given by Intercom.<p>The unique identifier for the company which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public DeletedStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * Whether the company was deleted successfully or not.<p>Whether the company was deleted successfully or not.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("deleted")
        public _FinalStage deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        @java.lang.Override
        public DeletedCompanyObject build() {
            return new DeletedCompanyObject(id, deleted, additionalProperties);
        }
    }
}
