/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DropdownOption.Builder.class)
public final class DropdownOption {
    private final String id;

    private final String text;

    private final Optional<Boolean> disabled;

    private final Map<String, Object> additionalProperties;

    private DropdownOption(
            String id, String text, Optional<Boolean> disabled, Map<String, Object> additionalProperties) {
        this.id = id;
        this.text = text;
        this.disabled = disabled;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of component you are rendering.
     */
    @JsonProperty("type")
    public String getType() {
        return "option";
    }

    /**
     * @return A unique identifier for the option.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The text shown within this option.
     */
    @JsonProperty("text")
    public String getText() {
        return text;
    }

    /**
     * @return Styles the option and prevents the action. Default is false.
     */
    @JsonProperty("disabled")
    public Optional<Boolean> getDisabled() {
        return disabled;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DropdownOption && equalTo((DropdownOption) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DropdownOption other) {
        return id.equals(other.id) && text.equals(other.text) && disabled.equals(other.disabled);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.text, this.disabled);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * A unique identifier for the option.
         */
        TextStage id(@NotNull String id);

        Builder from(DropdownOption other);
    }

    public interface TextStage {
        /**
         * The text shown within this option.
         */
        _FinalStage text(@NotNull String text);
    }

    public interface _FinalStage {
        DropdownOption build();

        /**
         * <p>Styles the option and prevents the action. Default is false.</p>
         */
        _FinalStage disabled(Optional<Boolean> disabled);

        _FinalStage disabled(Boolean disabled);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, TextStage, _FinalStage {
        private String id;

        private String text;

        private Optional<Boolean> disabled = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DropdownOption other) {
            id(other.getId());
            text(other.getText());
            disabled(other.getDisabled());
            return this;
        }

        /**
         * A unique identifier for the option.<p>A unique identifier for the option.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public TextStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The text shown within this option.<p>The text shown within this option.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("text")
        public _FinalStage text(@NotNull String text) {
            this.text = Objects.requireNonNull(text, "text must not be null");
            return this;
        }

        /**
         * <p>Styles the option and prevents the action. Default is false.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage disabled(Boolean disabled) {
            this.disabled = Optional.ofNullable(disabled);
            return this;
        }

        /**
         * <p>Styles the option and prevents the action. Default is false.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "disabled", nulls = Nulls.SKIP)
        public _FinalStage disabled(Optional<Boolean> disabled) {
            this.disabled = disabled;
            return this;
        }

        @java.lang.Override
        public DropdownOption build() {
            return new DropdownOption(id, text, disabled, additionalProperties);
        }
    }
}
