/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = InputComponent.Builder.class)
public final class InputComponent {
    private final String id;

    private final Optional<String> label;

    private final Optional<String> placeholder;

    private final Optional<String> value;

    private final Optional<ActionComponent> action;

    private final Optional<SaveState> saveState;

    private final Optional<Boolean> disabled;

    private final Map<String, Object> additionalProperties;

    private InputComponent(
            String id,
            Optional<String> label,
            Optional<String> placeholder,
            Optional<String> value,
            Optional<ActionComponent> action,
            Optional<SaveState> saveState,
            Optional<Boolean> disabled,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.label = label;
        this.placeholder = placeholder;
        this.value = value;
        this.action = action;
        this.saveState = saveState;
        this.disabled = disabled;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return A unique identifier for the component.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The text shown above the input.
     */
    @JsonProperty("label")
    public Optional<String> getLabel() {
        return label;
    }

    /**
     * @return An example value shown inside the component when it's empty.
     */
    @JsonProperty("placeholder")
    public Optional<String> getPlaceholder() {
        return placeholder;
    }

    /**
     * @return An entered value which is already inside the component.
     */
    @JsonProperty("value")
    public Optional<String> getValue() {
        return value;
    }

    /**
     * @return This can be a Submit Action, URL Action, or Sheets Action.
     */
    @JsonProperty("action")
    public Optional<ActionComponent> getAction() {
        return action;
    }

    /**
     * @return Styles the input. Default is <code>unsaved</code>. Prevent action with <code>saved</code>.
     */
    @JsonProperty("save_state")
    public Optional<SaveState> getSaveState() {
        return saveState;
    }

    /**
     * @return Styles the input and prevents the action. Default is false. Will be overridden if save_state is saved.
     */
    @JsonProperty("disabled")
    public Optional<Boolean> getDisabled() {
        return disabled;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof InputComponent && equalTo((InputComponent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InputComponent other) {
        return id.equals(other.id)
                && label.equals(other.label)
                && placeholder.equals(other.placeholder)
                && value.equals(other.value)
                && action.equals(other.action)
                && saveState.equals(other.saveState)
                && disabled.equals(other.disabled);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id, this.label, this.placeholder, this.value, this.action, this.saveState, this.disabled);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * A unique identifier for the component.
         */
        _FinalStage id(@NotNull String id);

        Builder from(InputComponent other);
    }

    public interface _FinalStage {
        InputComponent build();

        /**
         * <p>The text shown above the input.</p>
         */
        _FinalStage label(Optional<String> label);

        _FinalStage label(String label);

        /**
         * <p>An example value shown inside the component when it's empty.</p>
         */
        _FinalStage placeholder(Optional<String> placeholder);

        _FinalStage placeholder(String placeholder);

        /**
         * <p>An entered value which is already inside the component.</p>
         */
        _FinalStage value(Optional<String> value);

        _FinalStage value(String value);

        /**
         * <p>This can be a Submit Action, URL Action, or Sheets Action.</p>
         */
        _FinalStage action(Optional<ActionComponent> action);

        _FinalStage action(ActionComponent action);

        /**
         * <p>Styles the input. Default is <code>unsaved</code>. Prevent action with <code>saved</code>.</p>
         */
        _FinalStage saveState(Optional<SaveState> saveState);

        _FinalStage saveState(SaveState saveState);

        /**
         * <p>Styles the input and prevents the action. Default is false. Will be overridden if save_state is saved.</p>
         */
        _FinalStage disabled(Optional<Boolean> disabled);

        _FinalStage disabled(Boolean disabled);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, _FinalStage {
        private String id;

        private Optional<Boolean> disabled = Optional.empty();

        private Optional<SaveState> saveState = Optional.empty();

        private Optional<ActionComponent> action = Optional.empty();

        private Optional<String> value = Optional.empty();

        private Optional<String> placeholder = Optional.empty();

        private Optional<String> label = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(InputComponent other) {
            id(other.getId());
            label(other.getLabel());
            placeholder(other.getPlaceholder());
            value(other.getValue());
            action(other.getAction());
            saveState(other.getSaveState());
            disabled(other.getDisabled());
            return this;
        }

        /**
         * A unique identifier for the component.<p>A unique identifier for the component.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>Styles the input and prevents the action. Default is false. Will be overridden if save_state is saved.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage disabled(Boolean disabled) {
            this.disabled = Optional.ofNullable(disabled);
            return this;
        }

        /**
         * <p>Styles the input and prevents the action. Default is false. Will be overridden if save_state is saved.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "disabled", nulls = Nulls.SKIP)
        public _FinalStage disabled(Optional<Boolean> disabled) {
            this.disabled = disabled;
            return this;
        }

        /**
         * <p>Styles the input. Default is <code>unsaved</code>. Prevent action with <code>saved</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage saveState(SaveState saveState) {
            this.saveState = Optional.ofNullable(saveState);
            return this;
        }

        /**
         * <p>Styles the input. Default is <code>unsaved</code>. Prevent action with <code>saved</code>.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "save_state", nulls = Nulls.SKIP)
        public _FinalStage saveState(Optional<SaveState> saveState) {
            this.saveState = saveState;
            return this;
        }

        /**
         * <p>This can be a Submit Action, URL Action, or Sheets Action.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage action(ActionComponent action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        /**
         * <p>This can be a Submit Action, URL Action, or Sheets Action.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "action", nulls = Nulls.SKIP)
        public _FinalStage action(Optional<ActionComponent> action) {
            this.action = action;
            return this;
        }

        /**
         * <p>An entered value which is already inside the component.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage value(String value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        /**
         * <p>An entered value which is already inside the component.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "value", nulls = Nulls.SKIP)
        public _FinalStage value(Optional<String> value) {
            this.value = value;
            return this;
        }

        /**
         * <p>An example value shown inside the component when it's empty.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage placeholder(String placeholder) {
            this.placeholder = Optional.ofNullable(placeholder);
            return this;
        }

        /**
         * <p>An example value shown inside the component when it's empty.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "placeholder", nulls = Nulls.SKIP)
        public _FinalStage placeholder(Optional<String> placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        /**
         * <p>The text shown above the input.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage label(String label) {
            this.label = Optional.ofNullable(label);
            return this;
        }

        /**
         * <p>The text shown above the input.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "label", nulls = Nulls.SKIP)
        public _FinalStage label(Optional<String> label) {
            this.label = label;
            return this;
        }

        @java.lang.Override
        public InputComponent build() {
            return new InputComponent(id, label, placeholder, value, action, saveState, disabled, additionalProperties);
        }
    }

    public static final class SaveState {
        public static final SaveState SAVED = new SaveState(Value.SAVED, "saved");

        public static final SaveState UNSAVED = new SaveState(Value.UNSAVED, "unsaved");

        public static final SaveState FAILED = new SaveState(Value.FAILED, "failed");

        private final Value value;

        private final String string;

        SaveState(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof SaveState && this.string.equals(((SaveState) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case SAVED:
                    return visitor.visitSaved();
                case UNSAVED:
                    return visitor.visitUnsaved();
                case FAILED:
                    return visitor.visitFailed();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static SaveState valueOf(String value) {
            switch (value) {
                case "saved":
                    return SAVED;
                case "unsaved":
                    return UNSAVED;
                case "failed":
                    return FAILED;
                default:
                    return new SaveState(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            UNSAVED,

            SAVED,

            FAILED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitUnsaved();

            T visitSaved();

            T visitFailed();

            T visitUnknown(String unknownType);
        }
    }
}
