/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = LinkedObjectList.Builder.class)
public final class LinkedObjectList {
    private final int totalCount;

    private final boolean hasMore;

    private final List<LinkedObject> data;

    private final Map<String, Object> additionalProperties;

    private LinkedObjectList(
            int totalCount, boolean hasMore, List<LinkedObject> data, Map<String, Object> additionalProperties) {
        this.totalCount = totalCount;
        this.hasMore = hasMore;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always list.
     */
    @JsonProperty("type")
    public String getType() {
        return "list";
    }

    /**
     * @return The total number of linked objects.
     */
    @JsonProperty("total_count")
    public int getTotalCount() {
        return totalCount;
    }

    /**
     * @return Whether or not there are more linked objects than returned.
     */
    @JsonProperty("has_more")
    public boolean getHasMore() {
        return hasMore;
    }

    /**
     * @return An array containing the linked conversations and linked tickets.
     */
    @JsonProperty("data")
    public List<LinkedObject> getData() {
        return data;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LinkedObjectList && equalTo((LinkedObjectList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LinkedObjectList other) {
        return totalCount == other.totalCount && hasMore == other.hasMore && data.equals(other.data);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.totalCount, this.hasMore, this.data);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    public interface TotalCountStage {
        /**
         * The total number of linked objects.
         */
        HasMoreStage totalCount(int totalCount);

        Builder from(LinkedObjectList other);
    }

    public interface HasMoreStage {
        /**
         * Whether or not there are more linked objects than returned.
         */
        _FinalStage hasMore(boolean hasMore);
    }

    public interface _FinalStage {
        LinkedObjectList build();

        /**
         * <p>An array containing the linked conversations and linked tickets.</p>
         */
        _FinalStage data(List<LinkedObject> data);

        _FinalStage addData(LinkedObject data);

        _FinalStage addAllData(List<LinkedObject> data);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TotalCountStage, HasMoreStage, _FinalStage {
        private int totalCount;

        private boolean hasMore;

        private List<LinkedObject> data = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(LinkedObjectList other) {
            totalCount(other.getTotalCount());
            hasMore(other.getHasMore());
            data(other.getData());
            return this;
        }

        /**
         * The total number of linked objects.<p>The total number of linked objects.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("total_count")
        public HasMoreStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        /**
         * Whether or not there are more linked objects than returned.<p>Whether or not there are more linked objects than returned.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("has_more")
        public _FinalStage hasMore(boolean hasMore) {
            this.hasMore = hasMore;
            return this;
        }

        /**
         * <p>An array containing the linked conversations and linked tickets.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllData(List<LinkedObject> data) {
            this.data.addAll(data);
            return this;
        }

        /**
         * <p>An array containing the linked conversations and linked tickets.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addData(LinkedObject data) {
            this.data.add(data);
            return this;
        }

        /**
         * <p>An array containing the linked conversations and linked tickets.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public _FinalStage data(List<LinkedObject> data) {
            this.data.clear();
            this.data.addAll(data);
            return this;
        }

        @java.lang.Override
        public LinkedObjectList build() {
            return new LinkedObjectList(totalCount, hasMore, data, additionalProperties);
        }
    }
}
