/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.contacts.types.Contact;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = LiveCanvasRequest.Builder.class)
public final class LiveCanvasRequest {
    private final String workspaceId;

    private final String workspaceRegion;

    private final CanvasObject canvas;

    private final Context context;

    private final Contact contact;

    private final Map<String, Object> additionalProperties;

    private LiveCanvasRequest(
            String workspaceId,
            String workspaceRegion,
            CanvasObject canvas,
            Context context,
            Contact contact,
            Map<String, Object> additionalProperties) {
        this.workspaceId = workspaceId;
        this.workspaceRegion = workspaceRegion;
        this.canvas = canvas;
        this.context = context;
        this.contact = contact;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The workspace ID of the teammate. Attribute is <code>app_id</code> for V1.2 and below.
     */
    @JsonProperty("workspace_id")
    public String getWorkspaceId() {
        return workspaceId;
    }

    /**
     * @return The Intercom hosted region that this app is located in.
     */
    @JsonProperty("workspace_region")
    public String getWorkspaceRegion() {
        return workspaceRegion;
    }

    /**
     * @return The current_canvas the teammate can see.
     */
    @JsonProperty("canvas")
    public CanvasObject getCanvas() {
        return canvas;
    }

    /**
     * @return The context of where the app is added, where the user last visited, and information on the Messenger settings.
     */
    @JsonProperty("context")
    public Context getContext() {
        return context;
    }

    /**
     * @return The contact who viewed the card.
     */
    @JsonProperty("contact")
    public Contact getContact() {
        return contact;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LiveCanvasRequest && equalTo((LiveCanvasRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LiveCanvasRequest other) {
        return workspaceId.equals(other.workspaceId)
                && workspaceRegion.equals(other.workspaceRegion)
                && canvas.equals(other.canvas)
                && context.equals(other.context)
                && contact.equals(other.contact);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.workspaceId, this.workspaceRegion, this.canvas, this.context, this.contact);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WorkspaceIdStage builder() {
        return new Builder();
    }

    public interface WorkspaceIdStage {
        /**
         * The workspace ID of the teammate. Attribute is `app_id` for V1.2 and below.
         */
        WorkspaceRegionStage workspaceId(@NotNull String workspaceId);

        Builder from(LiveCanvasRequest other);
    }

    public interface WorkspaceRegionStage {
        /**
         * The Intercom hosted region that this app is located in.
         */
        CanvasStage workspaceRegion(@NotNull String workspaceRegion);
    }

    public interface CanvasStage {
        /**
         * The current_canvas the teammate can see.
         */
        ContextStage canvas(@NotNull CanvasObject canvas);
    }

    public interface ContextStage {
        /**
         * The context of where the app is added, where the user last visited, and information on the Messenger settings.
         */
        ContactStage context(@NotNull Context context);
    }

    public interface ContactStage {
        /**
         * The contact who viewed the card.
         */
        _FinalStage contact(@NotNull Contact contact);
    }

    public interface _FinalStage {
        LiveCanvasRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements WorkspaceIdStage, WorkspaceRegionStage, CanvasStage, ContextStage, ContactStage, _FinalStage {
        private String workspaceId;

        private String workspaceRegion;

        private CanvasObject canvas;

        private Context context;

        private Contact contact;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(LiveCanvasRequest other) {
            workspaceId(other.getWorkspaceId());
            workspaceRegion(other.getWorkspaceRegion());
            canvas(other.getCanvas());
            context(other.getContext());
            contact(other.getContact());
            return this;
        }

        /**
         * The workspace ID of the teammate. Attribute is `app_id` for V1.2 and below.<p>The workspace ID of the teammate. Attribute is <code>app_id</code> for V1.2 and below.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("workspace_id")
        public WorkspaceRegionStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        /**
         * The Intercom hosted region that this app is located in.<p>The Intercom hosted region that this app is located in.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("workspace_region")
        public CanvasStage workspaceRegion(@NotNull String workspaceRegion) {
            this.workspaceRegion = Objects.requireNonNull(workspaceRegion, "workspaceRegion must not be null");
            return this;
        }

        /**
         * The current_canvas the teammate can see.<p>The current_canvas the teammate can see.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("canvas")
        public ContextStage canvas(@NotNull CanvasObject canvas) {
            this.canvas = Objects.requireNonNull(canvas, "canvas must not be null");
            return this;
        }

        /**
         * The context of where the app is added, where the user last visited, and information on the Messenger settings.<p>The context of where the app is added, where the user last visited, and information on the Messenger settings.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("context")
        public ContactStage context(@NotNull Context context) {
            this.context = Objects.requireNonNull(context, "context must not be null");
            return this;
        }

        /**
         * The contact who viewed the card.<p>The contact who viewed the card.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("contact")
        public _FinalStage contact(@NotNull Contact contact) {
            this.contact = Objects.requireNonNull(contact, "contact must not be null");
            return this;
        }

        @java.lang.Override
        public LiveCanvasRequest build() {
            return new LiveCanvasRequest(workspaceId, workspaceRegion, canvas, context, contact, additionalProperties);
        }
    }
}
