/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.news.types.NewsItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PaginatedNewsItemResponse.Builder.class)
public final class PaginatedNewsItemResponse {
    private final Optional<CursorPages> pages;

    private final int totalCount;

    private final List<NewsItem> data;

    private final Map<String, Object> additionalProperties;

    private PaginatedNewsItemResponse(
            Optional<CursorPages> pages,
            int totalCount,
            List<NewsItem> data,
            Map<String, Object> additionalProperties) {
        this.pages = pages;
        this.totalCount = totalCount;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object
     */
    @JsonProperty("type")
    public String getType() {
        return "list";
    }

    @JsonProperty("pages")
    public Optional<CursorPages> getPages() {
        return pages;
    }

    /**
     * @return A count of the total number of News Items.
     */
    @JsonProperty("total_count")
    public int getTotalCount() {
        return totalCount;
    }

    /**
     * @return An array of News Items
     */
    @JsonProperty("data")
    public List<NewsItem> getData() {
        return data;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PaginatedNewsItemResponse && equalTo((PaginatedNewsItemResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaginatedNewsItemResponse other) {
        return pages.equals(other.pages) && totalCount == other.totalCount && data.equals(other.data);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.pages, this.totalCount, this.data);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    public interface TotalCountStage {
        /**
         * A count of the total number of News Items.
         */
        _FinalStage totalCount(int totalCount);

        Builder from(PaginatedNewsItemResponse other);
    }

    public interface _FinalStage {
        PaginatedNewsItemResponse build();

        _FinalStage pages(Optional<CursorPages> pages);

        _FinalStage pages(CursorPages pages);

        /**
         * <p>An array of News Items</p>
         */
        _FinalStage data(List<NewsItem> data);

        _FinalStage addData(NewsItem data);

        _FinalStage addAllData(List<NewsItem> data);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TotalCountStage, _FinalStage {
        private int totalCount;

        private List<NewsItem> data = new ArrayList<>();

        private Optional<CursorPages> pages = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PaginatedNewsItemResponse other) {
            pages(other.getPages());
            totalCount(other.getTotalCount());
            data(other.getData());
            return this;
        }

        /**
         * A count of the total number of News Items.<p>A count of the total number of News Items.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        /**
         * <p>An array of News Items</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllData(List<NewsItem> data) {
            this.data.addAll(data);
            return this;
        }

        /**
         * <p>An array of News Items</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addData(NewsItem data) {
            this.data.add(data);
            return this;
        }

        /**
         * <p>An array of News Items</p>
         */
        @java.lang.Override
        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public _FinalStage data(List<NewsItem> data) {
            this.data.clear();
            this.data.addAll(data);
            return this;
        }

        @java.lang.Override
        public _FinalStage pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public _FinalStage pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        @java.lang.Override
        public PaginatedNewsItemResponse build() {
            return new PaginatedNewsItemResponse(pages, totalCount, data, additionalProperties);
        }
    }
}
