/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PhoneSwitch.Builder.class)
public final class PhoneSwitch {
    private final String phone;

    private final Map<String, Object> additionalProperties;

    private PhoneSwitch(String phone, Map<String, Object> additionalProperties) {
        this.phone = phone;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return
     */
    @JsonProperty("type")
    public String getType() {
        return "phone_call_redirect";
    }

    /**
     * @return Phone number in E.164 format, that has received the SMS to continue the conversation in the Messenger.
     */
    @JsonProperty("phone")
    public String getPhone() {
        return phone;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PhoneSwitch && equalTo((PhoneSwitch) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PhoneSwitch other) {
        return phone.equals(other.phone);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.phone);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PhoneStage builder() {
        return new Builder();
    }

    public interface PhoneStage {
        /**
         * Phone number in E.164 format, that has received the SMS to continue the conversation in the Messenger.
         */
        _FinalStage phone(@NotNull String phone);

        Builder from(PhoneSwitch other);
    }

    public interface _FinalStage {
        PhoneSwitch build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PhoneStage, _FinalStage {
        private String phone;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PhoneSwitch other) {
            phone(other.getPhone());
            return this;
        }

        /**
         * Phone number in E.164 format, that has received the SMS to continue the conversation in the Messenger.<p>Phone number in E.164 format, that has received the SMS to continue the conversation in the Messenger.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("phone")
        public _FinalStage phone(@NotNull String phone) {
            this.phone = Objects.requireNonNull(phone, "phone must not be null");
            return this;
        }

        @java.lang.Override
        public PhoneSwitch build() {
            return new PhoneSwitch(phone, additionalProperties);
        }
    }
}
