/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SlaApplied.Builder.class)
public final class SlaApplied {
    private final String type;

    private final String slaName;

    private final SlaStatus slaStatus;

    private final Map<String, Object> additionalProperties;

    private SlaApplied(String type, String slaName, SlaStatus slaStatus, Map<String, Object> additionalProperties) {
        this.type = type;
        this.slaName = slaName;
        this.slaStatus = slaStatus;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return object type
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * @return The name of the SLA as given by the teammate when it was created.
     */
    @JsonProperty("sla_name")
    public String getSlaName() {
        return slaName;
    }

    /**
     * @return SLA statuses:
     * - <code>hit</code>: If there’s at least one hit event in the underlying sla_events table, and no “missed” or “canceled” events for the conversation.
     * - <code>missed</code>: If there are any missed sla_events for the conversation and no canceled events. If there’s even a single missed sla event, the status will always be missed. A missed status is not applied when the SLA expires, only the next time a teammate replies.
     * - <code>active</code>: An SLA has been applied to a conversation, but has not yet been fulfilled. SLA status is active only if there are no “hit, “missed”, or “canceled” events.
     */
    @JsonProperty("sla_status")
    public SlaStatus getSlaStatus() {
        return slaStatus;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SlaApplied && equalTo((SlaApplied) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SlaApplied other) {
        return type.equals(other.type) && slaName.equals(other.slaName) && slaStatus.equals(other.slaStatus);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.slaName, this.slaStatus);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * object type
         */
        SlaNameStage type(@NotNull String type);

        Builder from(SlaApplied other);
    }

    public interface SlaNameStage {
        /**
         * The name of the SLA as given by the teammate when it was created.
         */
        SlaStatusStage slaName(@NotNull String slaName);
    }

    public interface SlaStatusStage {
        /**
         * SLA statuses:
         *             - `hit`: If there’s at least one hit event in the underlying sla_events table, and no “missed” or “canceled” events for the conversation.
         *             - `missed`: If there are any missed sla_events for the conversation and no canceled events. If there’s even a single missed sla event, the status will always be missed. A missed status is not applied when the SLA expires, only the next time a teammate replies.
         *             - `active`: An SLA has been applied to a conversation, but has not yet been fulfilled. SLA status is active only if there are no “hit, “missed”, or “canceled” events.
         */
        _FinalStage slaStatus(@NotNull SlaStatus slaStatus);
    }

    public interface _FinalStage {
        SlaApplied build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, SlaNameStage, SlaStatusStage, _FinalStage {
        private String type;

        private String slaName;

        private SlaStatus slaStatus;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SlaApplied other) {
            type(other.getType());
            slaName(other.getSlaName());
            slaStatus(other.getSlaStatus());
            return this;
        }

        /**
         * object type<p>object type</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public SlaNameStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * The name of the SLA as given by the teammate when it was created.<p>The name of the SLA as given by the teammate when it was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("sla_name")
        public SlaStatusStage slaName(@NotNull String slaName) {
            this.slaName = Objects.requireNonNull(slaName, "slaName must not be null");
            return this;
        }

        /**
         * SLA statuses:
         *             - `hit`: If there’s at least one hit event in the underlying sla_events table, and no “missed” or “canceled” events for the conversation.
         *             - `missed`: If there are any missed sla_events for the conversation and no canceled events. If there’s even a single missed sla event, the status will always be missed. A missed status is not applied when the SLA expires, only the next time a teammate replies.
         *             - `active`: An SLA has been applied to a conversation, but has not yet been fulfilled. SLA status is active only if there are no “hit, “missed”, or “canceled” events.<p>SLA statuses:
         * - <code>hit</code>: If there’s at least one hit event in the underlying sla_events table, and no “missed” or “canceled” events for the conversation.
         * - <code>missed</code>: If there are any missed sla_events for the conversation and no canceled events. If there’s even a single missed sla event, the status will always be missed. A missed status is not applied when the SLA expires, only the next time a teammate replies.
         * - <code>active</code>: An SLA has been applied to a conversation, but has not yet been fulfilled. SLA status is active only if there are no “hit, “missed”, or “canceled” events.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("sla_status")
        public _FinalStage slaStatus(@NotNull SlaStatus slaStatus) {
            this.slaStatus = Objects.requireNonNull(slaStatus, "slaStatus must not be null");
            return this;
        }

        @java.lang.Override
        public SlaApplied build() {
            return new SlaApplied(type, slaName, slaStatus, additionalProperties);
        }
    }

    public static final class SlaStatus {
        public static final SlaStatus HIT = new SlaStatus(Value.HIT, "hit");

        public static final SlaStatus CANCELLED = new SlaStatus(Value.CANCELLED, "cancelled");

        public static final SlaStatus ACTIVE = new SlaStatus(Value.ACTIVE, "active");

        public static final SlaStatus MISSED = new SlaStatus(Value.MISSED, "missed");

        private final Value value;

        private final String string;

        SlaStatus(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof SlaStatus && this.string.equals(((SlaStatus) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case HIT:
                    return visitor.visitHit();
                case CANCELLED:
                    return visitor.visitCancelled();
                case ACTIVE:
                    return visitor.visitActive();
                case MISSED:
                    return visitor.visitMissed();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static SlaStatus valueOf(String value) {
            switch (value) {
                case "hit":
                    return HIT;
                case "cancelled":
                    return CANCELLED;
                case "active":
                    return ACTIVE;
                case "missed":
                    return MISSED;
                default:
                    return new SlaStatus(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            HIT,

            MISSED,

            CANCELLED,

            ACTIVE,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitHit();

            T visitMissed();

            T visitCancelled();

            T visitActive();

            T visitUnknown(String unknownType);
        }
    }
}
